/*
 * Decompiled with CFR 0.152.
 */
package net.paoding.analysis.dictionary.support.detection;

import java.io.File;
import java.io.FileFilter;
import net.paoding.analysis.dictionary.support.detection.Difference;
import net.paoding.analysis.dictionary.support.detection.DifferenceListener;
import net.paoding.analysis.dictionary.support.detection.ExtensionFileFilter;
import net.paoding.analysis.dictionary.support.detection.Snapshot;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class Detector
implements Runnable {
    private Log log = LogFactory.getLog(this.getClass());
    private DifferenceListener listener;
    private File home;
    private FileFilter filter;
    private long interval;
    private Snapshot lastSnapshot;
    private Thread thread;
    private boolean alive = true;

    public void setListener(DifferenceListener listener) {
        this.listener = listener;
    }

    public void setInterval(int interval) {
        this.interval = interval * 1000;
    }

    public void setHome(File home) {
        this.home = home;
    }

    public void setHome(String home) {
        this.home = new File(home);
    }

    public void setFilter(FileFilter filter) {
        this.filter = filter;
    }

    public Snapshot flash() {
        return Snapshot.flash(this.home, this.filter);
    }

    public void start(boolean daemon) {
        if (this.lastSnapshot == null) {
            this.lastSnapshot = this.flash();
        }
        this.thread = new Thread(this);
        this.thread.setDaemon(daemon);
        this.thread.start();
    }

    public Snapshot getLastSnapshot() {
        return this.lastSnapshot;
    }

    public void setLastSnapshot(Snapshot last) {
        this.lastSnapshot = last;
    }

    public void run() {
        if (this.interval <= 0L) {
            throw new IllegalArgumentException("should set a interval(>0) for the detection.");
        }
        while (this.alive) {
            this.sleep();
            this.forceDetecting();
        }
    }

    public void forceDetecting() {
        Snapshot current = this.flash();
        Difference diff = current.diff(this.lastSnapshot);
        if (!diff.isEmpty()) {
            try {
                this.listener.on(diff);
                this.log.info((Object)("found differen for " + this.home));
                this.log.info((Object)diff);
                this.lastSnapshot = current;
            }
            catch (Exception e) {
                this.log.error((Object)"", (Throwable)e);
            }
        }
    }

    public void setStop() {
        this.alive = false;
        this.thread = null;
    }

    private void sleep() {
        try {
            Thread.sleep(this.interval);
        }
        catch (InterruptedException e) {
            e.printStackTrace();
        }
    }

    public static void main(String[] args) {
        Detector d = new Detector();
        d.setInterval(1);
        d.setHome(new File("dic"));
        d.setFilter(new ExtensionFileFilter(".dic"));
        d.setListener(new DifferenceListener(){

            public void on(Difference diff) {
                System.out.println(diff);
            }
        });
        d.start(false);
    }
}

