/*
 * Decompiled with CFR 0.152.
 */
package net.paoding.analysis.dictionary.support.detection;

import java.io.File;
import java.io.FileFilter;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.Map;
import net.paoding.analysis.dictionary.support.detection.Difference;
import net.paoding.analysis.dictionary.support.detection.Node;

public class Snapshot {
    private long version;
    private String root;
    private Map nodesMap = new HashMap();
    private InnerNode[] nodes;

    private Snapshot() {
    }

    public static Snapshot flash(String root, FileFilter filter) {
        return Snapshot.flash(new File(root), filter);
    }

    public static Snapshot flash(File rootFile, FileFilter filter) {
        Snapshot snapshot = new Snapshot();
        snapshot.implFlash(rootFile, filter);
        return snapshot;
    }

    private void implFlash(File rootFile, FileFilter filter) {
        this.version = System.currentTimeMillis();
        this.root = rootFile.getAbsolutePath().replace('\\', '/');
        if (!rootFile.exists()) {
            this.nodes = new InnerNode[0];
        } else {
            InnerNode rootNode = new InnerNode();
            rootNode.path = this.root;
            rootNode.isFile = rootFile.isFile();
            rootNode.lastModified = rootFile.lastModified();
            this.nodesMap.put(this.root, rootNode);
            if (rootFile.isDirectory()) {
                LinkedList files = this.getPosterity(rootFile, filter);
                this.nodes = new InnerNode[files.size()];
                Iterator iter = files.iterator();
                for (int i = 0; i < this.nodes.length; ++i) {
                    File f = (File)iter.next();
                    String path = f.getAbsolutePath().substring(this.root.length() + 1);
                    path = path.replace('\\', '/');
                    InnerNode node = new InnerNode();
                    node.path = path;
                    node.isFile = f.isFile();
                    node.lastModified = f.lastModified();
                    int index = path.lastIndexOf(47);
                    node.parent = index == -1 ? this.root : path.substring(0, index);
                    this.nodes[i] = node;
                    this.nodesMap.put(path, node);
                }
            }
        }
    }

    public long getVersion() {
        return this.version;
    }

    public void setVersion(long version) {
        this.version = version;
    }

    public String getRoot() {
        return this.root;
    }

    public void setRoot(String root) {
        this.root = root;
    }

    public Difference diff(Snapshot that) {
        int i;
        Snapshot older = that;
        Snapshot younger = this;
        if (that.version > this.version) {
            older = this;
            younger = that;
        }
        Difference diff = new Difference();
        if (!younger.root.equals(older.root)) {
            throw new IllegalArgumentException("the snaps should be same root");
        }
        for (i = 0; i < older.nodes.length; ++i) {
            InnerNode olderNode = older.nodes[i];
            InnerNode yongerNode = (InnerNode)younger.nodesMap.get(olderNode.path);
            if (yongerNode == null) {
                diff.getDeleted().add(olderNode);
                continue;
            }
            if (yongerNode.lastModified == olderNode.lastModified) continue;
            diff.getModified().add(olderNode);
        }
        for (i = 0; i < younger.nodes.length; ++i) {
            InnerNode yongerNode = younger.nodes[i];
            InnerNode olderNode = (InnerNode)older.nodesMap.get(yongerNode.path);
            if (olderNode != null) continue;
            diff.getNewcome().add(yongerNode);
        }
        diff.setOlder(older);
        diff.setYounger(younger);
        return diff;
    }

    public static void main(String[] args) throws InterruptedException {
        File f = new File("dic");
        Snapshot snapshot1 = Snapshot.flash(f, null);
        System.out.println("----");
        Thread.sleep(3000L);
        System.out.println("----");
        Thread.sleep(3000L);
        System.out.println("----");
        Snapshot snapshot2 = Snapshot.flash(f, null);
        Difference diff = snapshot2.diff(snapshot1);
        String deleted = Snapshot.ArraysToString(diff.getDeleted().toArray(new Node[0]));
        System.out.println("deleted: " + deleted);
        String modified = Snapshot.ArraysToString(diff.getModified().toArray(new Node[0]));
        System.out.println("modified: " + modified);
        String newcome = Snapshot.ArraysToString(diff.getNewcome().toArray(new Node[0]));
        System.out.println("newcome: " + newcome);
    }

    private static String ArraysToString(Object[] a) {
        if (a == null) {
            return "null";
        }
        int iMax = a.length - 1;
        if (iMax == -1) {
            return "[]";
        }
        StringBuffer b = new StringBuffer();
        b.append('[');
        int i = 0;
        while (true) {
            b.append(String.valueOf(a[i]));
            if (i == iMax) {
                return b.append(']').toString();
            }
            b.append(", ");
            ++i;
        }
    }

    private LinkedList getPosterity(File root, FileFilter filter) {
        ArrayList<File> dirs = new ArrayList<File>();
        LinkedList<File> files = new LinkedList<File>();
        dirs.add(root);
        int index = 0;
        while (index < dirs.size()) {
            File cur = (File)dirs.get(index++);
            File[] children = cur.listFiles();
            for (int i = 0; i < children.length; ++i) {
                File f = children[i];
                if (filter != null && !filter.accept(f)) continue;
                if (f.isDirectory()) {
                    dirs.add(f);
                    continue;
                }
                files.add(f);
            }
        }
        return files;
    }

    class InnerNode
    extends Node {
        String parent;
        long lastModified;

        InnerNode() {
        }
    }
}

