/*
 * Decompiled with CFR 0.152.
 */
package net.paoding.analysis.dictionary.support.filewords;

import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.net.URL;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.Map;
import net.paoding.analysis.dictionary.support.filewords.ReadListener;
import net.paoding.analysis.dictionary.support.filewords.SimpleReadListener;
import net.paoding.analysis.dictionary.support.filewords.SimpleReadListener2;
import net.paoding.analysis.knife.CharSet;

public class FileWordsReader {
    static /* synthetic */ Class class$net$paoding$analysis$dictionary$support$filewords$FileWordsReader;

    public static Map readWords(String fileOrDirectory, String charsetName) throws IOException {
        SimpleReadListener l = new SimpleReadListener();
        FileWordsReader.readWords(fileOrDirectory, l, charsetName);
        return l.getResult();
    }

    public static Map readWords(String fileOrDirectory, String charsetName, Class collectionClass, String ext) throws IOException {
        SimpleReadListener2 l = new SimpleReadListener2(collectionClass, ext);
        FileWordsReader.readWords(fileOrDirectory, l, charsetName);
        return l.getResult();
    }

    public static void readWords(String fileOrDirectory, ReadListener l, String charsetName) throws IOException {
        String dir;
        File file;
        if (fileOrDirectory.startsWith("classpath:")) {
            String name = fileOrDirectory.substring("classpath:".length());
            URL url = (class$net$paoding$analysis$dictionary$support$filewords$FileWordsReader == null ? (class$net$paoding$analysis$dictionary$support$filewords$FileWordsReader = FileWordsReader.class$("net.paoding.analysis.dictionary.support.filewords.FileWordsReader")) : class$net$paoding$analysis$dictionary$support$filewords$FileWordsReader).getClassLoader().getResource(name);
            if (url == null) {
                throw new FileNotFoundException("file \"" + name + "\" not found in classpath!");
            }
            file = new File(url.getFile());
        } else {
            file = new File(fileOrDirectory);
            if (!file.exists()) {
                throw new FileNotFoundException("file \"" + fileOrDirectory + "\" not found!");
            }
        }
        ArrayList<File> dirs = new ArrayList<File>();
        LinkedList<File> dics = new LinkedList<File>();
        if (file.isDirectory()) {
            dirs.add(file);
            dir = file.getAbsolutePath();
        } else {
            dics.add(file);
            dir = file.getParentFile().getAbsolutePath();
        }
        int index = 0;
        while (index < dirs.size()) {
            File cur = (File)dirs.get(index++);
            File[] files = cur.listFiles();
            for (int i = 0; i < files.length; ++i) {
                File f = files[i];
                if (f.isDirectory()) {
                    dirs.add(f);
                    continue;
                }
                dics.add(f);
            }
        }
        Iterator iter = dics.iterator();
        while (iter.hasNext()) {
            String word;
            File f = (File)iter.next();
            String name = f.getAbsolutePath().substring(dir.length() + 1);
            if (!l.onFileBegin(name = name.replace('\\', '/'))) continue;
            BufferedReader in = new BufferedReader(new InputStreamReader((InputStream)new FileInputStream(f), charsetName));
            boolean firstInDic = true;
            while ((word = in.readLine()) != null) {
                if (firstInDic) {
                    firstInDic = false;
                    if (word.length() > 0 && CharSet.isBom(word.charAt(0))) {
                        word = word.substring(1);
                    }
                }
                l.onWord(word);
            }
            l.onFileEnd(name);
            in.close();
        }
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

