/*
 * Decompiled with CFR 0.152.
 */
package net.paoding.analysis.dictionary.support.filewords;

import java.util.HashSet;
import java.util.Hashtable;
import java.util.Map;
import net.paoding.analysis.dictionary.Word;
import net.paoding.analysis.dictionary.support.filewords.ReadListener;
import net.paoding.analysis.knife.CharSet;

public class SimpleReadListener
implements ReadListener {
    private Map dics = new Hashtable();
    private HashSet words = new HashSet();
    private String ext = ".dic";

    public SimpleReadListener(String ext) {
        this.ext = ext;
    }

    public SimpleReadListener() {
    }

    public boolean onFileBegin(String file) {
        if (!file.endsWith(this.ext)) {
            return false;
        }
        this.words = new HashSet();
        return true;
    }

    public void onFileEnd(String file) {
        String name = file.substring(0, file.length() - 4);
        this.dics.put(name, this.words);
        this.words = null;
    }

    public void onWord(String wordText) {
        char ch;
        int num;
        if ((wordText = wordText.trim().toLowerCase()).length() == 0 || wordText.charAt(0) == '#' || wordText.charAt(0) == '-') {
            return;
        }
        for (int i = 0; !(i >= wordText.length() || (num = CharSet.toNumber(ch = wordText.charAt(i))) < 0 || i == 0 && num > 10 || num == 2 && (wordText.equals("\u4e24") || wordText.equals("\u4e24\u4e24"))); ++i) {
            if (i + 1 != wordText.length()) continue;
            return;
        }
        int index = wordText.indexOf(91);
        if (index == -1) {
            this.words.add(new Word(wordText));
        } else {
            Word w = new Word(wordText.substring(0, index));
            int mindex = wordText.indexOf("m=", index);
            if (mindex != -1) {
                int mEndIndex = wordText.indexOf("]", mindex);
                String m = wordText.substring(mindex + "m=".length(), mEndIndex);
                w.setModifiers(Integer.parseInt(m));
                this.words.add(w);
            }
        }
    }

    public Map getResult() {
        return this.dics;
    }
}

