/*
 * Decompiled with CFR 0.152.
 */
package net.paoding.analysis.examples.gettingstarted.ch4;

import net.paoding.analysis.analyzer.PaodingAnalyzer;
import net.paoding.analysis.examples.gettingstarted.BoldFormatter;
import net.paoding.analysis.examples.gettingstarted.ContentReader;
import org.apache.lucene.analysis.Analyzer;
import org.apache.lucene.analysis.TokenStream;
import org.apache.lucene.document.Document;
import org.apache.lucene.document.Field;
import org.apache.lucene.document.Fieldable;
import org.apache.lucene.index.IndexReader;
import org.apache.lucene.index.IndexWriter;
import org.apache.lucene.index.TermPositionVector;
import org.apache.lucene.queryParser.QueryParser;
import org.apache.lucene.search.Hits;
import org.apache.lucene.search.IndexSearcher;
import org.apache.lucene.search.Query;
import org.apache.lucene.search.highlight.Formatter;
import org.apache.lucene.search.highlight.Fragmenter;
import org.apache.lucene.search.highlight.Highlighter;
import org.apache.lucene.search.highlight.QueryScorer;
import org.apache.lucene.search.highlight.Scorer;
import org.apache.lucene.search.highlight.SimpleFragmenter;
import org.apache.lucene.search.highlight.TokenSources;
import org.apache.lucene.store.Directory;
import org.apache.lucene.store.RAMDirectory;

public class Chinese {
    private static String FIELD_NAME = "content";
    private static String QUERY = "\u4e2d\u534e";
    static /* synthetic */ Class class$net$paoding$analysis$examples$gettingstarted$ch4$Chinese;

    public static void main(String[] args) throws Exception {
        if (args.length != 0) {
            QUERY = args[0];
        }
        PaodingAnalyzer analyzer = new PaodingAnalyzer();
        String content = ContentReader.readText(class$net$paoding$analysis$examples$gettingstarted$ch4$Chinese == null ? (class$net$paoding$analysis$examples$gettingstarted$ch4$Chinese = Chinese.class$("net.paoding.analysis.examples.gettingstarted.ch4.Chinese")) : class$net$paoding$analysis$examples$gettingstarted$ch4$Chinese);
        RAMDirectory ramDir = new RAMDirectory();
        IndexWriter writer = new IndexWriter((Directory)ramDir, (Analyzer)analyzer);
        Document doc = new Document();
        Field fd = new Field(FIELD_NAME, content, Field.Store.YES, Field.Index.TOKENIZED, Field.TermVector.WITH_POSITIONS_OFFSETS);
        doc.add((Fieldable)fd);
        writer.addDocument(doc);
        writer.optimize();
        writer.close();
        IndexReader reader = IndexReader.open((Directory)ramDir);
        String queryString = QUERY;
        QueryParser parser = new QueryParser(FIELD_NAME, (Analyzer)analyzer);
        Query query = parser.parse(queryString);
        IndexSearcher searcher = new IndexSearcher((Directory)ramDir);
        query = query.rewrite(reader);
        System.out.println("Searching for: " + query.toString(FIELD_NAME));
        Hits hits = searcher.search(query);
        BoldFormatter formatter = new BoldFormatter();
        Highlighter highlighter = new Highlighter((Formatter)formatter, (Scorer)new QueryScorer(query));
        highlighter.setTextFragmenter((Fragmenter)new SimpleFragmenter(50));
        for (int i = 0; i < hits.length(); ++i) {
            String text = hits.doc(i).get(FIELD_NAME);
            int maxNumFragmentsRequired = 5;
            String fragmentSeparator = "...";
            TermPositionVector tpv = (TermPositionVector)reader.getTermFreqVector(hits.id(i), FIELD_NAME);
            TokenStream tokenStream = TokenSources.getTokenStream((TermPositionVector)tpv);
            String result = highlighter.getBestFragments(tokenStream, text, maxNumFragmentsRequired, fragmentSeparator);
            System.out.println("\n" + result);
        }
        reader.close();
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

