/*
 * Decompiled with CFR 0.152.
 */
package net.paoding.analysis.knife;

public class Beef
implements CharSequence {
    private final char[] value;
    private int offset;
    private int count;
    private int hash;

    public Beef(char[] value, int offset, int count) {
        this.value = value;
        this.set(offset, count);
    }

    public void set(int offset, int count) {
        if (offset < 0) {
            throw new StringIndexOutOfBoundsException(offset);
        }
        if (count < 0) {
            throw new StringIndexOutOfBoundsException(count);
        }
        if (offset > this.value.length - count) {
            throw new StringIndexOutOfBoundsException(offset + count);
        }
        this.offset = offset;
        this.count = count;
    }

    public char[] getValue() {
        return this.value;
    }

    public int getCount() {
        return this.count;
    }

    public int getOffset() {
        return this.offset;
    }

    public char charAt(int index) {
        if (index >= 0 && index < this.count) {
            char src = this.value[this.offset + index];
            if (src > '\uff00' && src < '\uff5f') {
                this.value[this.offset + index] = src = (char)(src - 65248);
            }
            if (src >= 'A' && src <= 'Z') {
                this.value[this.offset + index] = src = (char)(src + 32);
            } else if (src == '\u3000') {
                src = ' ';
                this.value[this.offset + index] = 32;
            }
            return src;
        }
        return '\uffff';
    }

    public int length() {
        return this.count;
    }

    public CharSequence subSequence(int start, int end) {
        return new String(this.value, this.offset + start, end - start);
    }

    public String toString() {
        return new String(this.value, this.offset, this.count);
    }

    public int hashCode() {
        int h = this.hash;
        if (h == 0) {
            int off = this.offset;
            char[] val = this.value;
            int len = this.count;
            for (int i = 0; i < len; ++i) {
                h = 31 * h + val[off++];
            }
            this.hash = h;
        }
        return h;
    }
}

