/*
 * Decompiled with CFR 0.152.
 */
package net.paoding.analysis.knife;

public class CharSet {
    public static boolean isArabianNumber(char ch) {
        return ch >= '0' && ch <= '9';
    }

    public static boolean isLantingLetter(char ch) {
        return ch >= 'a' && ch <= 'z' || ch >= 'A' && ch <= 'Z';
    }

    public static boolean isCjkUnifiedIdeographs(char ch) {
        return ch >= '\u4e00' && ch < '\ua000';
    }

    public static boolean isBom(char ch) {
        return ch == '\ufeff' || ch == '\ufffe';
    }

    public static int toNumber(char ch) {
        switch (ch) {
            case '0': 
            case '\u3007': 
            case '\u96f6': {
                return 0;
            }
            case '1': 
            case '\u4e00': 
            case '\u58f9': {
                return 1;
            }
            case '2': 
            case '\u4e24': 
            case '\u4e8c': 
            case '\u4fe9': 
            case '\u8cb3': {
                return 2;
            }
            case '3': 
            case '\u4e09': 
            case '\u53c1': {
                return 3;
            }
            case '4': 
            case '\u56db': 
            case '\u8086': {
                return 4;
            }
            case '5': 
            case '\u4e94': 
            case '\u4f0d': {
                return 5;
            }
            case '6': 
            case '\u516d': 
            case '\u9678': {
                return 6;
            }
            case '7': 
            case '\u4e03': 
            case '\u67d2': {
                return 7;
            }
            case '8': 
            case '\u516b': 
            case '\u634c': {
                return 8;
            }
            case '9': 
            case '\u4e5d': 
            case '\u7396': {
                return 9;
            }
            case '\u4ec0': 
            case '\u5341': {
                return 10;
            }
            case '\u4f70': 
            case '\u767e': {
                return 100;
            }
            case '\u4edf': 
            case '\u5343': {
                return 1000;
            }
            case '\u4e07': 
            case '\u842c': {
                return 10000;
            }
            case '\u4ebf': 
            case '\u5104': {
                return 100000000;
            }
        }
        return -1;
    }
}

