/*
 * Decompiled with CFR 0.152.
 */
package net.paoding.analysis.knife;

import java.util.HashSet;
import net.paoding.analysis.dictionary.Dictionary;
import net.paoding.analysis.dictionary.Hit;
import net.paoding.analysis.knife.Beef;
import net.paoding.analysis.knife.Collector;
import net.paoding.analysis.knife.Dictionaries;
import net.paoding.analysis.knife.DictionariesWare;
import net.paoding.analysis.knife.Knife;

public abstract class CombinatoricsKnife
implements Knife,
DictionariesWare {
    protected Dictionary combinatoricsDictionary;
    protected HashSet noiseTable;

    public CombinatoricsKnife() {
    }

    public CombinatoricsKnife(String[] noiseWords) {
        this.setNoiseWords(noiseWords);
    }

    public void setNoiseWords(String[] noiseWords) {
        this.noiseTable = new HashSet((int)((double)noiseWords.length * 1.5));
        for (int i = 0; i < noiseWords.length; ++i) {
            this.noiseTable.add(noiseWords[i]);
        }
    }

    public void setDictionaries(Dictionaries dictionaries) {
        this.combinatoricsDictionary = dictionaries.getCombinatoricsDictionary();
    }

    public int dissect(Collector collector, Beef beef, int offset) {
        int point = -1;
        int limit = offset + 1;
        block4: while (true) {
            switch (this.assignable(beef, offset, limit)) {
                case -1: {
                    break block4;
                }
                case 0: {
                    if (point == -1) {
                        point = limit;
                    }
                }
                default: {
                    ++limit;
                    continue block4;
                }
            }
            break;
        }
        if (limit == beef.length() && offset > 0) {
            return -offset;
        }
        int dicWordVote = -1;
        if (this.combinatoricsDictionary != null && beef.charAt(limit) > '\u00ff') {
            dicWordVote = this.tryDicWord(collector, beef, offset, limit);
        }
        int pointVote = this.collectPoint(collector, beef, offset, point, limit, dicWordVote);
        int limitVote = this.collectLimit(collector, beef, offset, point, limit, dicWordVote);
        return this.nextOffset(beef, offset, point, limit, pointVote, limitVote, dicWordVote);
    }

    protected int collectPoint(Collector collector, Beef beef, int offset, int point, int limit, int dicWordVote) {
        if (point != -1 && dicWordVote == -1) {
            this.collectIfNotNoise(collector, beef, offset, point);
        }
        return -1;
    }

    protected int collectLimit(Collector collector, Beef beef, int offset, int point, int limit, int dicWordVote) {
        if (dicWordVote == -1) {
            this.collectIfNotNoise(collector, beef, offset, limit);
        }
        return -1;
    }

    protected int tryDicWord(Collector collector, Beef beef, int offset, int limit) {
        Hit hit;
        int ret = limit;
        int end = limit + 1;
        int count = limit - offset + 1;
        while (end <= beef.length() && !(hit = this.combinatoricsDictionary.search(beef, offset, count)).isUndefined()) {
            boolean gotoNextChar;
            if (hit.isHit()) {
                this.collectIfNotNoise(collector, beef, offset, end);
                ret = end;
            }
            boolean bl = gotoNextChar = hit.isUnclosed() && end < beef.length() && beef.charAt(end) >= hit.getNext().charAt(count);
            if (!gotoNextChar) break;
            ++end;
            ++count;
        }
        return ret <= limit ? -1 : ret;
    }

    protected void collectIfNotNoise(Collector collector, Beef beef, int offset, int end) {
        String word = ((Object)beef.subSequence(offset, end)).toString();
        if (this.noiseTable != null && this.noiseTable.contains(word)) {
            word = null;
        }
        if (word != null) {
            this.doCollect(collector, word, beef, offset, end);
        }
    }

    protected void collect(Collector collector, Beef beef, int offset, int end) {
        String word = ((Object)beef.subSequence(offset, end)).toString();
        this.doCollect(collector, word, beef, offset, end);
    }

    protected void doCollect(Collector collector, String word, Beef beef, int offset, int end) {
        collector.collect(word, offset, end);
    }

    protected int nextOffset(Beef beef, int offset, int point, int limit, int pointVote, int limitVote, int dicWordVote) {
        int max = pointVote > limitVote ? pointVote : limitVote;
        int n = max = max > dicWordVote ? max : dicWordVote;
        if (max == -1) {
            return point != -1 ? point : limit;
        }
        if (max > limit) {
            return max;
        }
        return limit;
    }

    public abstract /* synthetic */ int assignable(Beef var1, int var2, int var3);
}

