/*
 * Decompiled with CFR 0.152.
 */
package net.paoding.analysis.knife;

import java.io.FileNotFoundException;
import java.io.IOException;
import java.util.Arrays;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import net.paoding.analysis.dictionary.BinaryDictionary;
import net.paoding.analysis.dictionary.Dictionary;
import net.paoding.analysis.dictionary.HashBinaryDictionary;
import net.paoding.analysis.dictionary.Hit;
import net.paoding.analysis.dictionary.Word;
import net.paoding.analysis.dictionary.support.detection.Detector;
import net.paoding.analysis.dictionary.support.detection.DifferenceListener;
import net.paoding.analysis.dictionary.support.detection.ExtensionFileFilter;
import net.paoding.analysis.dictionary.support.filewords.FileWordsReader;
import net.paoding.analysis.exception.PaodingAnalysisException;
import net.paoding.analysis.knife.Dictionaries;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class FileDictionaries
implements Dictionaries {
    protected Log log = LogFactory.getLog(this.getClass());
    protected Dictionary vocabularyDictionary;
    protected Dictionary combinatoricsDictionary;
    protected Dictionary confucianFamilyNamesDictionary;
    protected Dictionary noiseCharactorsDictionary;
    protected Dictionary noiseWordsDictionary;
    protected Dictionary unitsDictionary;
    protected Map allWords;
    protected String dicHome;
    protected String skipPrefix;
    protected String noiseCharactor;
    protected String noiseWord;
    protected String unit;
    protected String confucianFamilyName;
    protected String combinatorics;
    protected String charsetName;
    private Detector detector;

    public FileDictionaries() {
    }

    public FileDictionaries(String dicHome, String skipPrefix, String noiseCharactor, String noiseWord, String unit, String confucianFamilyName, String combinatorics, String charsetName) {
        this.dicHome = dicHome;
        this.skipPrefix = skipPrefix;
        this.noiseCharactor = noiseCharactor;
        this.noiseWord = noiseWord;
        this.unit = unit;
        this.confucianFamilyName = confucianFamilyName;
        this.combinatorics = combinatorics;
        this.charsetName = charsetName;
    }

    public String getDicHome() {
        return this.dicHome;
    }

    public void setDicHome(String dicHome) {
        this.dicHome = dicHome;
    }

    public String getSkipPrefix() {
        return this.skipPrefix;
    }

    public void setSkipPrefix(String skipPrefix) {
        this.skipPrefix = skipPrefix;
    }

    public String getNoiseCharactor() {
        return this.noiseCharactor;
    }

    public void setNoiseCharactor(String noiseCharactor) {
        this.noiseCharactor = noiseCharactor;
    }

    public String getNoiseWord() {
        return this.noiseWord;
    }

    public void setNoiseWord(String noiseWord) {
        this.noiseWord = noiseWord;
    }

    public String getUnit() {
        return this.unit;
    }

    public void setUnit(String unit) {
        this.unit = unit;
    }

    public String getConfucianFamilyName() {
        return this.confucianFamilyName;
    }

    public void setConfucianFamilyName(String confucianFamilyName) {
        this.confucianFamilyName = confucianFamilyName;
    }

    public String getCharsetName() {
        return this.charsetName;
    }

    public void setCharsetName(String charsetName) {
        this.charsetName = charsetName;
    }

    public void setLantinFllowedByCjk(String lantinFllowedByCjk) {
        this.combinatorics = lantinFllowedByCjk;
    }

    public String getLantinFllowedByCjk() {
        return this.combinatorics;
    }

    public synchronized Dictionary getVocabularyDictionary() {
        if (this.vocabularyDictionary == null) {
            this.vocabularyDictionary = new HashBinaryDictionary(this.getVocabularyWords(), 12287, 0.75f);
            Dictionary noiseWordsDic = this.getNoiseWordsDictionary();
            for (int i = 0; i < noiseWordsDic.size(); ++i) {
                Hit hit = this.vocabularyDictionary.search(noiseWordsDic.get(i), 0, noiseWordsDic.get(i).length());
                if (!hit.isHit()) continue;
                hit.getWord().setNoiseWord();
            }
            Dictionary noiseCharactorsDic = this.getNoiseCharactorsDictionary();
            for (int i = 0; i < noiseCharactorsDic.size(); ++i) {
                Hit hit = this.vocabularyDictionary.search(noiseCharactorsDic.get(i), 0, noiseCharactorsDic.get(i).length());
                if (!hit.isHit()) continue;
                hit.getWord().setNoiseCharactor();
            }
        }
        return this.vocabularyDictionary;
    }

    public synchronized Dictionary getConfucianFamilyNamesDictionary() {
        if (this.confucianFamilyNamesDictionary == null) {
            this.confucianFamilyNamesDictionary = new BinaryDictionary(this.getConfucianFamilyNames());
        }
        return this.confucianFamilyNamesDictionary;
    }

    public synchronized Dictionary getNoiseCharactorsDictionary() {
        if (this.noiseCharactorsDictionary == null) {
            this.noiseCharactorsDictionary = new HashBinaryDictionary(this.getNoiseCharactors(), 256, 0.75f);
        }
        return this.noiseCharactorsDictionary;
    }

    public synchronized Dictionary getNoiseWordsDictionary() {
        if (this.noiseWordsDictionary == null) {
            this.noiseWordsDictionary = new BinaryDictionary(this.getNoiseWords());
        }
        return this.noiseWordsDictionary;
    }

    public synchronized Dictionary getUnitsDictionary() {
        if (this.unitsDictionary == null) {
            this.unitsDictionary = new HashBinaryDictionary(this.getUnits(), 1024, 0.75f);
        }
        return this.unitsDictionary;
    }

    public synchronized Dictionary getCombinatoricsDictionary() {
        if (this.combinatoricsDictionary == null) {
            this.combinatoricsDictionary = new BinaryDictionary(this.getCombinatoricsWords());
        }
        return this.combinatoricsDictionary;
    }

    public synchronized void startDetecting(int interval, DifferenceListener l) {
        if (this.detector != null || interval < 0) {
            return;
        }
        Detector detector = new Detector();
        detector.setHome(this.dicHome);
        detector.setFilter(new ExtensionFileFilter(".dic"));
        detector.setLastSnapshot(detector.flash());
        detector.setListener(l);
        detector.setInterval(interval);
        detector.start(true);
        this.detector = detector;
    }

    public synchronized void stopDetecting() {
        if (this.detector == null) {
            return;
        }
        this.detector.setStop();
        this.detector = null;
    }

    protected synchronized void refreshDicWords(String dicPath) {
        int index = dicPath.lastIndexOf(".dic");
        String dicName = dicPath.substring(0, index);
        if (this.allWords != null) {
            try {
                Map temp = FileWordsReader.readWords(this.dicHome + dicPath, this.charsetName);
                this.allWords.put(dicName, temp.values().iterator().next());
            }
            catch (FileNotFoundException e) {
                this.allWords.remove(dicName);
            }
            catch (IOException e) {
                throw this.toRuntimeException(e);
            }
            if (!this.isSkipForVacabulary(dicName)) {
                this.vocabularyDictionary = null;
            }
            if (this.isNoiseWordDicFile(dicName)) {
                this.noiseWordsDictionary = null;
                this.vocabularyDictionary = null;
            } else if (this.isNoiseCharactorDicFile(dicName)) {
                this.noiseCharactorsDictionary = null;
                this.vocabularyDictionary = null;
            } else if (this.isUnitDicFile(dicName)) {
                this.unitsDictionary = null;
            } else if (this.isConfucianFamilyNameDicFile(dicName)) {
                this.confucianFamilyNamesDictionary = null;
            } else if (this.isLantinFollowedByCjkDicFile(dicName)) {
                this.combinatoricsDictionary = null;
            }
        }
    }

    protected Word[] getVocabularyWords() {
        Map dics = this.loadAllWordsIfNecessary();
        HashSet set = null;
        Iterator iter = dics.keySet().iterator();
        while (iter.hasNext()) {
            String name = (String)iter.next();
            if (this.isSkipForVacabulary(name)) continue;
            Set dic = (Set)dics.get(name);
            if (set == null) {
                set = new HashSet(dic);
                continue;
            }
            set.addAll(dic);
        }
        Object[] words = set.toArray(new Word[set.size()]);
        Arrays.sort(words);
        return words;
    }

    protected Word[] getConfucianFamilyNames() {
        return this.getDictionaryWords(this.confucianFamilyName);
    }

    protected Word[] getNoiseWords() {
        return this.getDictionaryWords(this.noiseWord);
    }

    protected Word[] getNoiseCharactors() {
        return this.getDictionaryWords(this.noiseCharactor);
    }

    protected Word[] getUnits() {
        return this.getDictionaryWords(this.unit);
    }

    protected Word[] getCombinatoricsWords() {
        return this.getDictionaryWords(this.combinatorics);
    }

    protected Word[] getDictionaryWords(String dicNameRelativeDicHome) {
        Map dics;
        try {
            dics = FileWordsReader.readWords(this.dicHome + "/" + dicNameRelativeDicHome + ".dic", this.charsetName);
        }
        catch (IOException e) {
            throw this.toRuntimeException(e);
        }
        Set set = (Set)dics.get(dicNameRelativeDicHome);
        Object[] words = set.toArray(new Word[set.size()]);
        Arrays.sort(words);
        return words;
    }

    protected synchronized Map loadAllWordsIfNecessary() {
        if (this.allWords == null) {
            try {
                this.log.info((Object)("loading dictionaries from " + this.dicHome));
                this.allWords = FileWordsReader.readWords(this.dicHome, this.charsetName);
                if (this.allWords.size() == 0) {
                    String message = "Not found any dictionary files, have you set the 'paoding.dic.home' right? (" + this.dicHome + ")";
                    this.log.error((Object)message);
                    throw new PaodingAnalysisException(message);
                }
                this.log.info((Object)"loaded success!");
            }
            catch (IOException e) {
                throw this.toRuntimeException(e);
            }
        }
        return this.allWords;
    }

    protected final boolean isSkipForVacabulary(String dicNameRelativeDicHome) {
        return dicNameRelativeDicHome.startsWith(this.skipPrefix) || dicNameRelativeDicHome.indexOf("/" + this.skipPrefix) != -1;
    }

    protected boolean isUnitDicFile(String dicName) {
        return dicName.equals(this.unit);
    }

    protected boolean isNoiseCharactorDicFile(String dicName) {
        return dicName.equals(this.noiseCharactor);
    }

    protected boolean isNoiseWordDicFile(String dicName) {
        return dicName.equals(this.noiseWord);
    }

    protected boolean isConfucianFamilyNameDicFile(String dicName) {
        return dicName.equals(this.confucianFamilyName);
    }

    protected boolean isLantinFollowedByCjkDicFile(String dicName) {
        return dicName.equals(this.combinatorics);
    }

    protected RuntimeException toRuntimeException(IOException e) {
        return new PaodingAnalysisException(e);
    }
}

