/*
 * Decompiled with CFR 0.152.
 */
package net.paoding.analysis.knife;

import java.util.Iterator;
import java.util.LinkedList;
import net.paoding.analysis.dictionary.support.detection.Difference;
import net.paoding.analysis.dictionary.support.detection.DifferenceListener;
import net.paoding.analysis.dictionary.support.detection.Node;
import net.paoding.analysis.knife.Dictionaries;
import net.paoding.analysis.knife.DictionariesWare;
import net.paoding.analysis.knife.FileDictionaries;
import net.paoding.analysis.knife.Knife;
import net.paoding.analysis.knife.KnifeBox;

public class FileDictionariesDifferenceListener
implements DifferenceListener {
    private FileDictionaries dictionaries;
    private KnifeBox knifeBox;

    public FileDictionariesDifferenceListener() {
    }

    public FileDictionariesDifferenceListener(Dictionaries dictionaries, KnifeBox knifeBox) {
        this.dictionaries = (FileDictionaries)dictionaries;
        this.knifeBox = knifeBox;
    }

    public Dictionaries getDictionaries() {
        return this.dictionaries;
    }

    public void setDictionaries(Dictionaries dictionaries) {
        this.dictionaries = (FileDictionaries)dictionaries;
    }

    public KnifeBox getKnifeBox() {
        return this.knifeBox;
    }

    public void setKnifeBox(KnifeBox knifeBox) {
        this.knifeBox = knifeBox;
    }

    public synchronized void on(Difference diff) {
        LinkedList all = new LinkedList();
        all.addAll(diff.getDeleted());
        all.addAll(diff.getModified());
        all.addAll(diff.getNewcome());
        Iterator iter = all.iterator();
        while (iter.hasNext()) {
            Node node = (Node)iter.next();
            if (!node.isFile()) continue;
            this.dictionaries.refreshDicWords(node.getPath());
        }
        Knife[] knives = this.knifeBox.getKnives();
        for (int i = 0; i < knives.length; ++i) {
            Knife knife = knives[i];
            if (!(knife instanceof DictionariesWare)) continue;
            ((DictionariesWare)((Object)knife)).setDictionaries(this.dictionaries);
        }
    }
}

