/*
 * Decompiled with CFR 0.152.
 */
package net.paoding.analysis.knife;

import net.paoding.analysis.dictionary.Dictionary;
import net.paoding.analysis.dictionary.Hit;
import net.paoding.analysis.knife.Beef;
import net.paoding.analysis.knife.CharSet;
import net.paoding.analysis.knife.Collector;
import net.paoding.analysis.knife.CombinatoricsKnife;
import net.paoding.analysis.knife.Dictionaries;
import net.paoding.analysis.knife.DictionariesWare;

public class NumberKnife
extends CombinatoricsKnife
implements DictionariesWare {
    private Dictionary units;

    public NumberKnife() {
    }

    public NumberKnife(Dictionaries dictionaries) {
        this.setDictionaries(dictionaries);
    }

    public void setDictionaries(Dictionaries dictionaries) {
        super.setDictionaries(dictionaries);
        this.units = dictionaries.getUnitsDictionary();
    }

    public int assignable(Beef beef, int offset, int index) {
        char ch = beef.charAt(index);
        if (CharSet.isArabianNumber(ch)) {
            return 1;
        }
        if (index > offset && (CharSet.isLantingLetter(ch) || ch == '.' || ch == '-' || ch == '_')) {
            if (CharSet.isLantingLetter(ch) || !CharSet.isArabianNumber(beef.charAt(index + 1))) {
                return 0;
            }
            return 1;
        }
        return -1;
    }

    protected int collectLimit(Collector collector, Beef beef, int offset, int point, int limit, int dicWordVote) {
        int curTail;
        if (point != -1) {
            return super.collectLimit(collector, beef, offset, point, limit, dicWordVote);
        }
        int _point = limit;
        int number1 = -1;
        int number2 = -1;
        int bitValue = 0;
        int maxUnit = 0;
        for (curTail = offset; (bitValue = CharSet.toNumber(beef.charAt(curTail))) >= 0 && (bitValue != 2 || beef.charAt(curTail) != '\u4e24' && beef.charAt(curTail) != '\u4fe9' && beef.charAt(curTail) != '\u5006' || curTail == offset); ++curTail) {
            if (bitValue >= 0 && bitValue < 10) {
                if (number2 < 0) {
                    number2 = bitValue;
                    continue;
                }
                number2 *= 10;
                number2 += bitValue;
                continue;
            }
            if (number2 < 0) {
                if (number1 < 0) {
                    number1 = 1;
                }
                number1 *= bitValue;
            } else {
                if (number1 < 0) {
                    number1 = 0;
                }
                if (bitValue >= maxUnit) {
                    number1 += number2;
                    number1 *= bitValue;
                    maxUnit = bitValue;
                } else {
                    number1 += number2 * bitValue;
                }
            }
            number2 = -1;
        }
        if (number2 > 0) {
            number1 = number1 < 0 ? number2 : (number1 += number2);
        }
        if (number1 >= 0 && curTail > _point) {
            this.doCollect(collector, String.valueOf(number1), beef, offset, curTail);
        } else {
            super.collectLimit(collector, beef, offset, point, limit, dicWordVote);
        }
        int n = curTail = curTail > limit ? curTail : limit;
        if (this.units != null && CharSet.isCjkUnifiedIdeographs(beef.charAt(curTail))) {
            Hit wd = null;
            Hit wd2 = null;
            int i = curTail + 1;
            while ((wd = this.units.search(beef, curTail, i - curTail)).isHit()) {
                wd2 = wd;
                ++i;
                if (wd.isUnclosed()) continue;
            }
            --i;
            if (wd2 != null) {
                collector.collect(wd2.getWord().getText(), curTail, i);
                return i;
            }
        }
        return curTail > limit ? curTail : -1;
    }
}

