/*
 * Decompiled with CFR 0.152.
 */
package net.paoding.analysis.knife;

import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.UnsupportedEncodingException;
import java.lang.reflect.Method;
import java.net.URL;
import java.net.URLDecoder;
import java.util.HashMap;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.Map;
import java.util.Properties;
import java.util.jar.JarEntry;
import java.util.jar.JarFile;
import net.paoding.analysis.Constants;
import net.paoding.analysis.dictionary.support.detection.Difference;
import net.paoding.analysis.dictionary.support.detection.DifferenceListener;
import net.paoding.analysis.exception.PaodingAnalysisException;
import net.paoding.analysis.knife.Dictionaries;
import net.paoding.analysis.knife.DictionariesCompiler;
import net.paoding.analysis.knife.DictionariesWare;
import net.paoding.analysis.knife.FileDictionaries;
import net.paoding.analysis.knife.Knife;
import net.paoding.analysis.knife.Paoding;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class PaodingMaker {
    public static final String DEFAULT_PROPERTIES_PATH = "classpath:paoding-analysis.properties";
    private static Log log = LogFactory.getLog((Class)(class$net$paoding$analysis$knife$PaodingMaker == null ? (class$net$paoding$analysis$knife$PaodingMaker = PaodingMaker.class$("net.paoding.analysis.knife.PaodingMaker")) : class$net$paoding$analysis$knife$PaodingMaker));
    private static ObjectHolder propertiesHolder = new ObjectHolder();
    private static ObjectHolder paodingHolder = new ObjectHolder();
    static /* synthetic */ Class class$net$paoding$analysis$knife$PaodingMaker;
    static /* synthetic */ Class class$net$paoding$analysis$analyzer$impl$MostWordsModeDictionariesCompiler;
    static /* synthetic */ Class class$net$paoding$analysis$analyzer$impl$SortingDictionariesCompiler;
    static /* synthetic */ Class class$java$lang$Object;
    static /* synthetic */ Class class$java$lang$String;

    private PaodingMaker() {
    }

    public static Paoding make() {
        return PaodingMaker.make(DEFAULT_PROPERTIES_PATH);
    }

    public static Paoding make(String propertiesPath) {
        return PaodingMaker.make(PaodingMaker.getProperties(propertiesPath));
    }

    public static Paoding make(Properties p) {
        PaodingMaker.postPropertiesLoaded(p);
        return PaodingMaker.implMake(p);
    }

    public static Properties getProperties() {
        return PaodingMaker.getProperties(DEFAULT_PROPERTIES_PATH);
    }

    public static Properties getProperties(String path) {
        if (path == null) {
            throw new NullPointerException("path should not be null!");
        }
        try {
            Properties p = (Properties)propertiesHolder.get(path);
            if (p == null || PaodingMaker.modified(p)) {
                p = PaodingMaker.loadProperties(new Properties(), path);
                propertiesHolder.set(path, p);
                paodingHolder.remove(path);
                PaodingMaker.postPropertiesLoaded(p);
                String absolutePaths = p.getProperty("paoding.analysis.properties.files.absolutepaths");
                log.info((Object)("config paoding analysis from: " + absolutePaths));
            }
            return p;
        }
        catch (IOException e) {
            throw new PaodingAnalysisException(e);
        }
    }

    private static boolean modified(Properties p) throws IOException {
        String lastModifieds = p.getProperty("paoding.analysis.properties.lastModifieds");
        String[] lastModifedsArray = lastModifieds.split(";");
        String files = p.getProperty("paoding.analysis.properties.files");
        String[] filesArray = files.split(";");
        for (int i = 0; i < filesArray.length; ++i) {
            File file = PaodingMaker.getFile(filesArray[i]);
            if (!file.exists() || String.valueOf(PaodingMaker.getFileLastModified(file)).equals(lastModifedsArray[i])) continue;
            return true;
        }
        return false;
    }

    private static Properties loadProperties(Properties p, String path) throws IOException {
        InputStream in;
        File file;
        boolean skipWhenNotExists = false;
        if (path.startsWith("ifexists:")) {
            skipWhenNotExists = true;
            path = path.substring("ifexists:".length());
        }
        if (path.startsWith("classpath:")) {
            path = path.substring("classpath:".length());
            URL url = PaodingMaker.getClassLoader().getResource(path);
            if (url == null) {
                if (skipWhenNotExists) {
                    return p;
                }
                throw new FileNotFoundException("Not found " + path + " in classpath.");
            }
            file = new File(url.getFile());
            in = url.openStream();
        } else {
            if (path.startsWith("dic-home:")) {
                File dicHome = new File(PaodingMaker.getDicHome(p));
                path = path.substring("dic-home:".length());
                file = new File(dicHome, path);
            } else {
                file = new File(path);
            }
            if (skipWhenNotExists && !file.exists()) {
                return p;
            }
            in = new FileInputStream(file);
        }
        String absolutePath = file.getAbsolutePath();
        p.load(in);
        in.close();
        String lastModifieds = p.getProperty("paoding.analysis.properties.lastModifieds");
        String files = p.getProperty("paoding.analysis.properties.files");
        String absolutePaths = p.getProperty("paoding.analysis.properties.files.absolutepaths");
        if (lastModifieds == null) {
            p.setProperty("paoding.dic.properties.path", path);
            lastModifieds = String.valueOf(PaodingMaker.getFileLastModified(file));
            files = path;
            absolutePaths = absolutePath;
        } else {
            lastModifieds = lastModifieds + ";" + PaodingMaker.getFileLastModified(file);
            files = files + ";" + path;
            absolutePaths = absolutePaths + ";" + absolutePath;
        }
        p.setProperty("paoding.analysis.properties.lastModifieds", lastModifieds);
        p.setProperty("paoding.analysis.properties.files", files);
        p.setProperty("paoding.analysis.properties.files.absolutepaths", absolutePaths);
        String importsValue = p.getProperty("paoding.imports");
        if (importsValue != null) {
            ((Hashtable)p).remove("paoding.imports");
            String[] imports = importsValue.split(";");
            for (int i = 0; i < imports.length; ++i) {
                PaodingMaker.loadProperties(p, imports[i]);
            }
        }
        return p;
    }

    private static long getFileLastModified(File file) throws IOException {
        String path = file.getPath();
        int jarIndex = path.indexOf(".jar!");
        if (jarIndex == -1) {
            return file.lastModified();
        }
        path = path.replaceAll("%20", " ").replaceAll("\\\\", "/");
        jarIndex = path.indexOf(".jar!");
        int protocalIndex = path.indexOf(":");
        String jarPath = path.substring(protocalIndex + ":".length(), jarIndex + ".jar".length());
        File jarPathFile = new File(jarPath);
        try {
            JarFile jarFile = new JarFile(jarPathFile);
            String entryPath = path.substring(jarIndex + ".jar!/".length());
            JarEntry entry = jarFile.getJarEntry(entryPath);
            return entry.getTime();
        }
        catch (IOException e) {
            System.err.println("error in handler path=" + path);
            System.err.println("error in handler jarPath=" + jarPath);
            throw e;
        }
    }

    private static String getDicHome(Properties p) {
        PaodingMaker.setDicHomeProperties(p);
        return p.getProperty("paoding.dic.home.absolute.path");
    }

    private static void postPropertiesLoaded(Properties p) {
        if ("done".equals(p.getProperty("paoding.analysis.postPropertiesLoaded"))) {
            return;
        }
        PaodingMaker.setDicHomeProperties(p);
        p.setProperty("paoding.analysis.postPropertiesLoaded", "done");
    }

    private static void setDicHomeProperties(Properties p) {
        String dicHomeAbsultePath = p.getProperty("paoding.dic.home.absolute.path");
        if (dicHomeAbsultePath != null) {
            return;
        }
        String dicHomeBySystemEnv = null;
        try {
            dicHomeBySystemEnv = PaodingMaker.getSystemEnv("PAODING_DIC_HOME");
        }
        catch (Error e) {
            log.warn((Object)"System.getenv() is not supported in JDK1.4. ");
        }
        String dicHome = PaodingMaker.getProperty(p, "paoding.dic.home");
        if (dicHomeBySystemEnv != null) {
            String first = PaodingMaker.getProperty(p, "paoding.dic.home.config-first");
            if (first != null && first.equalsIgnoreCase("this")) {
                if (dicHome == null) {
                    dicHome = dicHomeBySystemEnv;
                }
            } else {
                dicHome = dicHomeBySystemEnv;
            }
        }
        if (dicHome == null) {
            File f = new File("dic");
            if (f.exists()) {
                dicHome = "dic/";
            } else {
                URL url = (class$net$paoding$analysis$knife$PaodingMaker == null ? (class$net$paoding$analysis$knife$PaodingMaker = PaodingMaker.class$("net.paoding.analysis.knife.PaodingMaker")) : class$net$paoding$analysis$knife$PaodingMaker).getClassLoader().getResource("dic");
                if (url != null) {
                    dicHome = "classpath:dic/";
                }
            }
        }
        if (dicHome == null) {
            throw new PaodingAnalysisException("please set a system env PAODING_DIC_HOME or Config paoding.dic.home in paoding-dic-home.properties point to the dictionaries!");
        }
        if (!(dicHome = dicHome.replace('\\', '/')).endsWith("/")) {
            dicHome = dicHome + "/";
        }
        p.setProperty("paoding.dic.home", dicHome);
        File dicHomeFile2 = PaodingMaker.getFile(dicHome);
        String path = "";
        try {
            path = URLDecoder.decode(dicHomeFile2.getPath(), "UTF-8");
        }
        catch (UnsupportedEncodingException e) {
            e.printStackTrace();
        }
        File dicHomeFile = new File(path);
        if (!dicHomeFile.exists()) {
            throw new PaodingAnalysisException("not found the dic home dirctory! " + dicHomeFile.getAbsolutePath());
        }
        if (!dicHomeFile.isDirectory()) {
            throw new PaodingAnalysisException("dic home should not be a file, but a directory!");
        }
        p.setProperty("paoding.dic.home.absolute.path", dicHomeFile.getAbsolutePath());
    }

    private static Paoding implMake(final Properties p) {
        String path = p.getProperty("paoding.dic.properties.path");
        Object paodingKey = path != null ? path : p;
        Paoding paoding = (Paoding)paodingHolder.get(paodingKey);
        if (paoding != null) {
            return paoding;
        }
        try {
            final Paoding finalPaoding = paoding = PaodingMaker.createPaodingWithKnives(p);
            String compilerClassName = PaodingMaker.getProperty(p, "paoding.analyzer.dictionaries.compiler");
            Class compilerClass = null;
            if (compilerClassName != null) {
                compilerClass = Class.forName(compilerClassName);
            }
            if (compilerClass == null) {
                String analyzerMode = PaodingMaker.getProperty(p, "paoding.analyzer.mode");
                compilerClass = "most-words".equalsIgnoreCase(analyzerMode) || "default".equalsIgnoreCase(analyzerMode) ? (class$net$paoding$analysis$analyzer$impl$MostWordsModeDictionariesCompiler == null ? (class$net$paoding$analysis$analyzer$impl$MostWordsModeDictionariesCompiler = PaodingMaker.class$("net.paoding.analysis.analyzer.impl.MostWordsModeDictionariesCompiler")) : class$net$paoding$analysis$analyzer$impl$MostWordsModeDictionariesCompiler) : (class$net$paoding$analysis$analyzer$impl$SortingDictionariesCompiler == null ? (class$net$paoding$analysis$analyzer$impl$SortingDictionariesCompiler = PaodingMaker.class$("net.paoding.analysis.analyzer.impl.SortingDictionariesCompiler")) : class$net$paoding$analysis$analyzer$impl$SortingDictionariesCompiler);
            }
            final DictionariesCompiler compiler = (DictionariesCompiler)compilerClass.newInstance();
            new Function(){

                public void run() throws Exception {
                    Dictionaries dictionaries;
                    if (compiler.shouldCompile(p)) {
                        dictionaries = PaodingMaker.readUnCompiledDictionaries(p);
                        Paoding tempPaoding = PaodingMaker.createPaodingWithKnives(p);
                        PaodingMaker.setDictionaries(tempPaoding, dictionaries);
                        compiler.compile(dictionaries, tempPaoding, p);
                    }
                    dictionaries = compiler.readCompliedDictionaries(p);
                    PaodingMaker.setDictionaries(finalPaoding, dictionaries);
                    String intervalStr = PaodingMaker.getProperty(p, "paoding.dic.detector.interval");
                    int interval = Integer.parseInt(intervalStr);
                    if (interval > 0) {
                        dictionaries.startDetecting(interval, new DifferenceListener(){

                            public void on(Difference diff) throws Exception {
                                dictionaries.stopDetecting();
                                this.run();
                            }
                        });
                    }
                }
            }.run();
            paodingHolder.set(paodingKey, paoding);
            return paoding;
        }
        catch (Exception e) {
            throw new PaodingAnalysisException("", e);
        }
    }

    private static Paoding createPaodingWithKnives(Properties p) throws Exception {
        Paoding paoding = new Paoding();
        final HashMap<String, Knife> knifeMap = new HashMap<String, Knife>();
        LinkedList<Knife> knifeList = new LinkedList<Knife>();
        LinkedList<2> functions = new LinkedList<2>();
        Iterator iter = ((Hashtable)p).entrySet().iterator();
        while (iter.hasNext()) {
            Map.Entry e = iter.next();
            final String key = (String)e.getKey();
            final String value = (String)e.getValue();
            int index = key.indexOf("paoding.knife.class.");
            if (index != 0 || key.length() <= "paoding.knife.class.".length()) continue;
            final int end = key.indexOf(46, "paoding.knife.class.".length());
            if (end == -1) {
                Class<?> clazz = Class.forName(value);
                Knife knife = (Knife)clazz.newInstance();
                knifeList.add(knife);
                knifeMap.put(key, knife);
                log.info((Object)("add knike: " + value));
                continue;
            }
            functions.add(new Function(){

                public void run() throws Exception {
                    String knifeName = key.substring(0, end);
                    Object obj = knifeMap.get(knifeName);
                    if (!obj.getClass().getName().equals("org.springframework.beans.BeanWrapperImpl")) {
                        Class<?> beanWrapperImplClass = Class.forName("org.springframework.beans.BeanWrapperImpl");
                        Method setWrappedInstance = beanWrapperImplClass.getMethod("setWrappedInstance", class$java$lang$Object == null ? (class$java$lang$Object = PaodingMaker.class$("java.lang.Object")) : class$java$lang$Object);
                        Object beanWrapperImpl = beanWrapperImplClass.newInstance();
                        setWrappedInstance.invoke(beanWrapperImpl, obj);
                        knifeMap.put(knifeName, beanWrapperImpl);
                        obj = beanWrapperImpl;
                    }
                    String propertyName = key.substring(end + 1);
                    Method setPropertyValue = obj.getClass().getMethod("setPropertyValue", class$java$lang$String == null ? (class$java$lang$String = PaodingMaker.class$("java.lang.String")) : class$java$lang$String, class$java$lang$Object == null ? (class$java$lang$Object = PaodingMaker.class$("java.lang.Object")) : class$java$lang$Object);
                    setPropertyValue.invoke(obj, propertyName, value);
                }
            });
        }
        Iterator iterator = functions.iterator();
        while (iterator.hasNext()) {
            Function function = (Function)iterator.next();
            function.run();
        }
        paoding.setKnives(knifeList);
        return paoding;
    }

    private static Dictionaries readUnCompiledDictionaries(Properties p) {
        String skipPrefix = PaodingMaker.getProperty(p, "paoding.dic.skip.prefix");
        String noiseCharactor = PaodingMaker.getProperty(p, "paoding.dic.noise-charactor");
        String noiseWord = PaodingMaker.getProperty(p, "paoding.dic.noise-word");
        String unit = PaodingMaker.getProperty(p, "paoding.dic.unit");
        String confucianFamilyName = PaodingMaker.getProperty(p, "paoding.dic.confucian-family-name");
        String combinatorics = PaodingMaker.getProperty(p, "paoding.dic.for-combinatorics");
        String charsetName = PaodingMaker.getProperty(p, "paoding.dic.charset");
        FileDictionaries dictionaries = new FileDictionaries(PaodingMaker.getDicHome(p), skipPrefix, noiseCharactor, noiseWord, unit, confucianFamilyName, combinatorics, charsetName);
        return dictionaries;
    }

    private static void setDictionaries(Paoding paoding, Dictionaries dictionaries) {
        Knife[] knives = paoding.getKnives();
        for (int i = 0; i < knives.length; ++i) {
            Knife knife = knives[i];
            if (!(knife instanceof DictionariesWare)) continue;
            ((DictionariesWare)((Object)knife)).setDictionaries(dictionaries);
        }
    }

    private static File getFile(String path) {
        File file;
        if (path.startsWith("classpath:")) {
            path = path.substring("classpath:".length());
            URL url = PaodingMaker.getClassLoader().getResource(path);
            final boolean fileExist = url != null;
            file = new File(fileExist ? url.getFile() : path){
                private static final long serialVersionUID = 4009013298629147887L;

                public boolean exists() {
                    return fileExist;
                }
            };
        } else {
            file = new File(path);
        }
        return file;
    }

    private static ClassLoader getClassLoader() {
        ClassLoader loader = Thread.currentThread().getContextClassLoader();
        if (loader == null) {
            loader = (class$net$paoding$analysis$knife$PaodingMaker == null ? (class$net$paoding$analysis$knife$PaodingMaker = PaodingMaker.class$("net.paoding.analysis.knife.PaodingMaker")) : class$net$paoding$analysis$knife$PaodingMaker).getClassLoader();
        }
        return loader;
    }

    private static String getProperty(Properties p, String name) {
        return Constants.getProperty(p, name);
    }

    private static String getSystemEnv(String name) {
        try {
            return System.getenv(name);
        }
        catch (Error error) {
            String osName = System.getProperty("os.name").toLowerCase();
            try {
                String line;
                String cmd = osName.indexOf("win") != -1 ? "cmd /c SET" : "/usr/bin/printenv";
                Process process = Runtime.getRuntime().exec(cmd);
                InputStreamReader isr = new InputStreamReader(process.getInputStream());
                BufferedReader br = new BufferedReader(isr);
                while ((line = br.readLine()) != null && line.startsWith(name)) {
                    int index = line.indexOf(name + "=");
                    if (index == -1) continue;
                    return line.substring(index + name.length() + 1);
                }
            }
            catch (Exception e) {
                log.warn((Object)("unable to read env from os\ufffd\ufffd" + e.getMessage()), (Throwable)e);
            }
            return null;
        }
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }

    private static interface Function {
        public void run() throws Exception;
    }

    private static class ObjectHolder {
        private Map objects = new HashMap();

        private ObjectHolder() {
        }

        public Object get(Object name) {
            return this.objects.get(name);
        }

        public void set(Object name, Object object) {
            this.objects.put(name, object);
        }

        public void remove(Object name) {
            this.objects.remove(name);
        }
    }
}

