/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.loader.entity;

import java.util.Collections;
import org.hibernate.FetchMode;
import org.hibernate.LockMode;
import org.hibernate.MappingException;
import org.hibernate.engine.CascadeStyle;
import org.hibernate.engine.LoadQueryInfluencers;
import org.hibernate.engine.SessionFactoryImplementor;
import org.hibernate.loader.AbstractEntityJoinWalker;
import org.hibernate.persister.entity.OuterJoinLoadable;
import org.hibernate.type.AssociationType;

public class EntityJoinWalker
extends AbstractEntityJoinWalker {
    private final LockMode lockMode;

    public EntityJoinWalker(OuterJoinLoadable persister, String[] uniqueKey, int batchSize, LockMode lockMode, SessionFactoryImplementor factory, LoadQueryInfluencers loadQueryInfluencers) throws MappingException {
        super(persister, factory, loadQueryInfluencers);
        this.lockMode = lockMode;
        StringBuffer whereCondition = this.whereString(this.getAlias(), uniqueKey, batchSize).append(persister.filterFragment(this.getAlias(), Collections.EMPTY_MAP));
        this.initAll(whereCondition.toString(), "", lockMode);
    }

    protected int getJoinType(OuterJoinLoadable persister, String path, int propertyNumber, AssociationType associationType, FetchMode metadataFetchMode, CascadeStyle metadataCascadeStyle, String lhsTable, String[] lhsColumns, boolean nullable, int currentDepth) throws MappingException {
        if (this.lockMode.greaterThan(LockMode.READ)) {
            return -1;
        }
        if (this.isTooDeep(currentDepth) || associationType.isCollectionType() && this.isTooManyCollections()) {
            return -1;
        }
        if (!this.isJoinedFetchEnabledInMapping(metadataFetchMode, associationType) && !this.isJoinFetchEnabledByProfile(persister, path, propertyNumber)) {
            return -1;
        }
        if (this.isDuplicateAssociation(lhsTable, lhsColumns, associationType)) {
            return -1;
        }
        return this.getJoinType(nullable, currentDepth);
    }

    public String getComment() {
        return "load " + this.getPersister().getEntityName();
    }
}

