/*
 * Decompiled with CFR 0.152.
 */
package com.sinba.common.dao;

import com.sinba.common.dao.IEntityDAO;
import com.sinba.common.dto.PageDTO;
import com.sinba.common.entity.BaseDomainEntity;
import com.sinba.common.util.Assert;
import java.io.Serializable;
import java.lang.reflect.Field;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.ParameterizedType;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import org.apache.commons.beanutils.PropertyUtils;
import org.apache.log4j.Logger;
import org.hibernate.Criteria;
import org.hibernate.LockMode;
import org.hibernate.Session;
import org.hibernate.criterion.CriteriaSpecification;
import org.hibernate.criterion.Criterion;
import org.hibernate.criterion.DetachedCriteria;
import org.hibernate.criterion.Example;
import org.hibernate.criterion.Order;
import org.hibernate.criterion.Projection;
import org.hibernate.criterion.Projections;
import org.hibernate.criterion.Restrictions;
import org.hibernate.impl.CriteriaImpl;
import org.hibernate.metadata.ClassMetadata;
import org.springframework.orm.hibernate3.HibernateCallback;
import org.springframework.orm.hibernate3.support.HibernateDaoSupport;
import org.springframework.util.ReflectionUtils;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class BaseDAOImplHibernate<T>
extends HibernateDaoSupport
implements IEntityDAO<T> {
    private static final Logger LOGGER = Logger.getLogger(BaseDAOImplHibernate.class);
    private Class<T> entityClass = (Class)((ParameterizedType)this.getClass().getGenericSuperclass()).getActualTypeArguments()[0];

    public List<T> findByIds(Serializable[] ids) {
        Assert.notNull(ids, "fail find entities:ids is null");
        String hql = "from " + this.entityClass.getName() + " where " + this.getIdName() + " in (:ids)";
        List entities = this.getHibernateTemplate().findByNamedParam(hql, "ids", (Object)ids);
        return entities;
    }

    @Override
    public void deleteByIds(Serializable[] ids) {
        Assert.notNull(ids, "fail delete entities:ids is null");
        List<T> entities = this.findByIds(ids);
        for (T entity : entities) {
            this.delete(entity);
        }
    }

    @Override
    public void save(T entity) {
        this.getHibernateTemplate().save(entity);
    }

    @Override
    public void update(T entity) {
        this.getHibernateTemplate().saveOrUpdate(entity);
    }

    @Override
    public void updateAll(Collection<T> entities) {
        this.getHibernateTemplate().saveOrUpdateAll(entities);
    }

    @Override
    public T merge(T entity) {
        return (T)this.getHibernateTemplate().merge(entity);
    }

    @Override
    public Collection<Object> mergeAll(Collection<T> entities) {
        ArrayList<Object> updatedPersistentInstances = null;
        if (entities != null && entities.size() > 0) {
            updatedPersistentInstances = new ArrayList<Object>();
            for (T entity : entities) {
                updatedPersistentInstances.add(this.getHibernateTemplate().merge(entity));
            }
        }
        return updatedPersistentInstances;
    }

    @Override
    public void delete(T entity) {
        if (entity instanceof BaseDomainEntity) {
            BaseDomainEntity domainEntity = (BaseDomainEntity)entity;
            domainEntity.setDataFlag(BaseDomainEntity.DELETED.byteValue());
        } else {
            this.getHibernateTemplate().delete(entity);
        }
    }

    @Override
    public void deleteAll() {
        this.getHibernateTemplate().deleteAll(this.findByCriteria(new Criterion[0]));
    }

    @Override
    public void deleteAll(Collection<T> entities) {
        this.getHibernateTemplate().deleteAll(entities);
    }

    @Override
    public T findById(Serializable id) {
        Assert.notNull(id, "fail find entity:ids is null");
        return (T)this.getHibernateTemplate().get(this.getEntityClass(), id);
    }

    @Override
    public T findById(Serializable id, boolean lock) {
        Assert.notNull(id, "fail find entity:ids is null");
        Object entity = lock ? this.getHibernateTemplate().get(this.getEntityClass(), id, LockMode.UPGRADE) : this.getHibernateTemplate().get(this.getEntityClass(), id);
        return (T)entity;
    }

    @Override
    public List<T> findAll() {
        return this.findByCriteria(new Criterion[0]);
    }

    public List<T> findByExample(T exampleInstance) {
        DetachedCriteria detachedCriteria = DetachedCriteria.forClass(this.getEntityClass());
        Example example = Example.create(exampleInstance);
        detachedCriteria.add((Criterion)example);
        return this.getHibernateTemplate().findByCriteria(detachedCriteria);
    }

    @Override
    public List<T> findByExample(T exampleInstance, String ... excludedProperties) {
        DetachedCriteria detachedCriteria = DetachedCriteria.forClass(this.getEntityClass());
        Example example = Example.create(exampleInstance);
        for (String excludedProperty : excludedProperties) {
            example.excludeProperty(excludedProperty);
        }
        detachedCriteria.add((Criterion)example);
        return this.getHibernateTemplate().findByCriteria(detachedCriteria);
    }

    @Override
    public List<T> findBy(String propertyName, Object value) {
        Assert.hasText(propertyName);
        return this.findByCriteria(new Criterion[]{Restrictions.eq((String)propertyName, (Object)value)});
    }

    @Override
    public List<T> findBy(String propertyName, Object value, String orderBy, boolean isAsc) {
        Assert.hasText(propertyName);
        Assert.hasText(orderBy);
        return this.findByCriteria(orderBy, isAsc, new Criterion[]{Restrictions.eq((String)propertyName, (Object)value)});
    }

    @Override
    public T findUniqueBy(String propertyName, Object value) {
        Assert.hasText(propertyName);
        DetachedCriteria dc = this.createCriteria(new Criterion[]{Restrictions.eq((String)propertyName, (Object)value)});
        List entities = this.getHibernateTemplate().findByCriteria(dc);
        if (entities.size() > 0) {
            return (T)entities.get(0);
        }
        return null;
    }

    @Override
    public boolean isUnique(T entity, String uniquePropertyNames) {
        Assert.hasText(uniquePropertyNames);
        DetachedCriteria criteria = this.createCriteria(new Criterion[0]).setProjection(Projections.rowCount());
        String[] namesList = uniquePropertyNames.split(",");
        try {
            for (String name : namesList) {
                criteria.add((Criterion)Restrictions.eq((String)name, (Object)PropertyUtils.getProperty(entity, (String)name)));
            }
            String idName = this.getIdName();
            Serializable id = this.getId(entity);
            if (id != null) {
                criteria.add(Restrictions.not((Criterion)Restrictions.eq((String)idName, (Object)id)));
            }
        }
        catch (Exception e) {
            ReflectionUtils.handleReflectionException((Exception)e);
        }
        return (Integer)this.getHibernateTemplate().findByCriteria(criteria).get(0) == 0;
    }

    protected Serializable getId(T entity) throws NoSuchMethodException, IllegalAccessException, InvocationTargetException {
        Assert.notNull(entity);
        Assert.notNull(this.entityClass);
        return (Serializable)PropertyUtils.getProperty(entity, (String)this.getIdName());
    }

    protected String getIdName() {
        Assert.notNull(this.getEntityClass());
        ClassMetadata meta = this.getSessionFactory().getClassMetadata(this.getEntityClass());
        Assert.notNull(meta, "Class " + this.getEntityClass() + " not define in hibernate session factory.");
        String idName = meta.getIdentifierPropertyName();
        Assert.hasText(idName, this.getEntityClass().getSimpleName() + " has no identifier property define.");
        return idName;
    }

    protected List<T> findByCriteria(Criterion ... criterions) {
        DetachedCriteria detachedCriteria = DetachedCriteria.forClass(this.getEntityClass());
        for (Criterion criterion : criterions) {
            detachedCriteria.add(criterion);
        }
        if (BaseDomainEntity.class.isAssignableFrom(this.entityClass)) {
            detachedCriteria.add((Criterion)Restrictions.ne((String)"dataFlag", (Object)BaseDomainEntity.DELETED.byteValue()));
        }
        return this.getHibernateTemplate().findByCriteria(detachedCriteria);
    }

    protected List<T> findByCriteria(String orderBy, boolean isAsc, Criterion ... criterions) {
        DetachedCriteria detachedCriteria = DetachedCriteria.forClass(this.getEntityClass());
        for (Criterion criterion : criterions) {
            detachedCriteria.add(criterion);
        }
        if (isAsc) {
            detachedCriteria.addOrder(Order.asc((String)orderBy));
        } else {
            detachedCriteria.addOrder(Order.desc((String)orderBy));
        }
        if (BaseDomainEntity.class.isAssignableFrom(this.entityClass)) {
            detachedCriteria.add((Criterion)Restrictions.ne((String)"dataFlag", (Object)BaseDomainEntity.DELETED.byteValue()));
        }
        return this.getHibernateTemplate().findByCriteria(detachedCriteria);
    }

    protected DetachedCriteria createCriteria(Criterion ... criterions) {
        DetachedCriteria criteria = DetachedCriteria.forClass(this.getEntityClass());
        for (Criterion criterion : criterions) {
            criteria.add(criterion);
        }
        return criteria;
    }

    protected DetachedCriteria createCriteria(String orderBy, boolean isAsc, Criterion ... criterions) {
        Assert.hasText(orderBy);
        DetachedCriteria criteria = this.createCriteria(criterions);
        if (isAsc) {
            criteria.addOrder(Order.asc((String)orderBy));
        } else {
            criteria.addOrder(Order.desc((String)orderBy));
        }
        return criteria;
    }

    public Class<T> getEntityClass() {
        return this.entityClass;
    }

    public PageDTO findPageByCriteria(final DetachedCriteria detachedCriteria, final int start, final int limit) {
        if (BaseDomainEntity.class.isAssignableFrom(this.entityClass)) {
            detachedCriteria.add((Criterion)Restrictions.ne((String)"dataFlag", (Object)BaseDomainEntity.DELETED.byteValue()));
        }
        return (PageDTO)this.getHibernateTemplate().execute((HibernateCallback)new HibernateCallback<PageDTO>(){

            public PageDTO doInHibernate(Session session) {
                Criteria criteria = detachedCriteria.getExecutableCriteria(session);
                CriteriaImpl.OrderEntry[] orderEntries = BaseDAOImplHibernate.getOrders(criteria);
                criteria = BaseDAOImplHibernate.removeOrders(criteria);
                Projection projection = BaseDAOImplHibernate.getProjection(criteria);
                int totalCount = ((Number)criteria.setProjection(Projections.rowCount()).uniqueResult()).intValue();
                criteria.setProjection(projection);
                if (projection == null) {
                    criteria.setResultTransformer(CriteriaSpecification.ROOT_ENTITY);
                }
                criteria = BaseDAOImplHibernate.addOrders(criteria, orderEntries);
                criteria.setFirstResult(start);
                criteria.setMaxResults(limit);
                List items = criteria.list();
                criteria.setFirstResult(0).setMaxResults(totalCount);
                PageDTO pageDTO = new PageDTO();
                pageDTO.setTotalSize(totalCount);
                pageDTO.setData(items);
                return pageDTO;
            }
        });
    }

    private static Projection getProjection(Criteria criteria) {
        BaseDAOImplHibernate.assertType(criteria);
        CriteriaImpl impl = (CriteriaImpl)criteria;
        return impl.getProjection();
    }

    private static void assertType(Criteria criteria) {
        Assert.notNull(criteria, " criteria is required. ");
        String message = criteria + "";
        if (!CriteriaImpl.class.isInstance(criteria) && LOGGER.isDebugEnabled()) {
            LOGGER.debug((Object)message);
        }
    }

    private static CriteriaImpl.OrderEntry[] getOrders(Criteria criteria) {
        BaseDAOImplHibernate.assertType(criteria);
        CriteriaImpl impl = (CriteriaImpl)criteria;
        Field field = BaseDAOImplHibernate.getOrderEntriesField(criteria);
        try {
            return ((List)field.get(impl)).toArray(new CriteriaImpl.OrderEntry[0]);
        }
        catch (Exception e) {
            BaseDAOImplHibernate.logAndThrowException(criteria, e);
            throw new InternalError(" Runtime Exception impossibility can't throw ");
        }
    }

    private static Criteria removeOrders(Criteria criteria) {
        BaseDAOImplHibernate.assertType(criteria);
        CriteriaImpl impl = (CriteriaImpl)criteria;
        try {
            Field field = BaseDAOImplHibernate.getOrderEntriesField(criteria);
            field.set(impl, new ArrayList());
            return impl;
        }
        catch (Exception e) {
            BaseDAOImplHibernate.logAndThrowException(criteria, e);
            throw new InternalError(" Runtime Exception impossibility can't throw ");
        }
    }

    private static Criteria addOrders(Criteria criteria, CriteriaImpl.OrderEntry[] orderEntries) {
        BaseDAOImplHibernate.assertType(criteria);
        CriteriaImpl impl = (CriteriaImpl)criteria;
        try {
            Field field = BaseDAOImplHibernate.getOrderEntriesField(criteria);
            for (int i = 0; i < orderEntries.length; ++i) {
                List innerOrderEntries = (List)field.get(criteria);
                innerOrderEntries.add(orderEntries[i]);
            }
            return impl;
        }
        catch (Exception e) {
            BaseDAOImplHibernate.logAndThrowException(criteria, e);
            throw new InternalError(" Runtime Exception impossibility can't throw ");
        }
    }

    private static void logAndThrowException(Criteria criteria, Exception e) {
        String message = criteria + "";
        if (LOGGER.isDebugEnabled()) {
            LOGGER.debug((Object)message, (Throwable)e);
        }
    }

    private static Field getOrderEntriesField(Criteria criteria) {
        Assert.notNull(criteria, " criteria is requried. ");
        try {
            Field field = CriteriaImpl.class.getDeclaredField("orderEntries");
            field.setAccessible(true);
            return field;
        }
        catch (Exception e) {
            BaseDAOImplHibernate.logAndThrowException(criteria, e);
            throw new InternalError();
        }
    }
}

