/*
 * Decompiled with CFR 0.152.
 */
package com.sinba.common.dao;

import com.sinba.common.dao.IEntityDAO;
import com.sinba.common.dto.PageDTO;
import java.io.Serializable;
import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Type;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import javax.persistence.EntityManager;
import javax.persistence.Query;
import org.springframework.orm.jpa.JpaCallback;
import org.springframework.orm.jpa.support.JpaDaoSupport;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class BaseDAOImplJPA<T>
extends JpaDaoSupport
implements IEntityDAO<T> {
    protected Class<T> entityClass = null;

    public BaseDAOImplJPA() {
        Type t = this.getClass().getGenericSuperclass();
        if (t instanceof ParameterizedType) {
            this.entityClass = (Class)((ParameterizedType)t).getActualTypeArguments()[0];
        }
    }

    @Override
    public void save(T entity) {
        this.getJpaTemplate().persist(entity);
    }

    @Override
    public void delete(T entity) {
        this.getJpaTemplate().remove(entity);
    }

    @Override
    public void update(T entity) {
        this.save(entity);
    }

    @Override
    public T merge(T entity) {
        return (T)this.getJpaTemplate().merge(entity);
    }

    @Override
    public T findById(Serializable id) {
        return (T)this.getJpaTemplate().find(this.entityClass, (Object)id);
    }

    @Override
    public List<T> findAll() {
        return this.getJpaTemplate().find("from " + this.entityClass.getName());
    }

    @Override
    public void deleteAll() {
        this.deleteAll(this.findAll());
    }

    @Override
    public void deleteAll(Collection<T> entities) {
        for (T entity : entities) {
            this.delete(entity);
        }
    }

    @Override
    public void updateAll(Collection<T> entities) {
        for (T entity : entities) {
            this.update(entity);
        }
    }

    @Override
    public Collection mergeAll(Collection<T> entities) {
        ArrayList<T> ets = new ArrayList<T>();
        for (T entity : entities) {
            ets.add(this.merge(entity));
        }
        return ets;
    }

    @Override
    public List findBy(String propertyName, Object value) {
        return null;
    }

    @Override
    public List findBy(String propertyName, Object value, String orderBy, boolean isAsc) {
        return null;
    }

    @Override
    public T findById(Serializable id, boolean lock) {
        return null;
    }

    @Override
    public T findUniqueBy(String propertyName, Object value) {
        return null;
    }

    protected PageDTO findPager(final String ql1, final String ql2, final int start, final int limit) {
        PageDTO p = (PageDTO)this.getJpaTemplate().execute((JpaCallback)new JpaCallback<PageDTO>(){

            public PageDTO doInJpa(EntityManager em) {
                Query q1 = em.createQuery(ql1);
                Integer totalSize = ((Number)q1.getSingleResult()).intValue();
                Query q2 = em.createQuery(ql2);
                q2.setFirstResult(start);
                q2.setMaxResults(limit);
                PageDTO p = new PageDTO();
                p.setTotalSize(totalSize);
                p.setData(q2.getResultList());
                p.getData().size();
                return p;
            }
        });
        return p;
    }

    @Override
    public void deleteByIds(Serializable[] ids) {
    }
}

