/*
 * Decompiled with CFR 0.152.
 */
package com.sinba.common.file.csv;

import com.sinba.common.util.StringUtils;
import java.io.IOException;
import java.io.PrintWriter;
import java.io.Reader;
import java.io.Writer;
import java.math.BigDecimal;
import java.sql.Clob;
import java.sql.Date;
import java.sql.ResultSet;
import java.sql.ResultSetMetaData;
import java.sql.SQLException;
import java.sql.Time;
import java.sql.Timestamp;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.List;
import org.springframework.jdbc.support.rowset.SqlRowSet;
import org.springframework.jdbc.support.rowset.SqlRowSetMetaData;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class CSVWriter {
    public static final char DEFAULT_ESCAPE_CHARACTER = '\"';
    public static final char DEFAULT_SEPARATOR = ',';
    public static final char DEFAULT_QUOTE_CHARACTER = '\"';
    public static final char NO_QUOTE_CHARACTER = '\u0000';
    public static final char NO_ESCAPE_CHARACTER = '\u0000';
    public static final String DEFAULT_LINE_END = "\n";
    private static final SimpleDateFormat TIMESTAMP_FORMATTER = new SimpleDateFormat("dd-MMM-yyyy HH:mm:ss");
    private static final SimpleDateFormat DATE_FORMATTER = new SimpleDateFormat("dd-MMM-yyyy");
    private Writer rawWriter;
    private PrintWriter pw;
    private char separator;
    private char quotechar;
    private char escapechar;
    private String lineEnd;

    public CSVWriter(Writer writer) {
        this(writer, ',');
    }

    public CSVWriter(Writer writer, char separator) {
        this(writer, separator, '\"');
    }

    public CSVWriter(Writer writer, char separator, char quotechar) {
        this(writer, separator, quotechar, '\"');
    }

    public CSVWriter(Writer writer, char separator, char quotechar, char escapechar) {
        this(writer, separator, quotechar, escapechar, DEFAULT_LINE_END);
    }

    public CSVWriter(Writer writer, char separator, char quotechar, String lineEnd) {
        this(writer, separator, quotechar, '\"', lineEnd);
    }

    public CSVWriter(Writer writer, char separator, char quotechar, char escapechar, String lineEnd) {
        this.rawWriter = writer;
        this.pw = new PrintWriter(writer);
        this.separator = separator;
        this.quotechar = quotechar;
        this.escapechar = escapechar;
        this.lineEnd = lineEnd;
    }

    public void writeAll(List<?> allLines) {
        for (String[] nextLine : allLines) {
            this.writeNext(nextLine);
        }
    }

    public void writeAll(ResultSet resultSet, boolean writeColumnName) throws SQLException, IOException {
        ResultSetMetaData metadata = resultSet.getMetaData();
        if (writeColumnName) {
            this.writeColumnNames(metadata);
        }
        int columnCount = metadata.getColumnCount();
        while (resultSet.next()) {
            String[] nextLine = new String[columnCount];
            for (int i = 0; i < columnCount; ++i) {
                nextLine[i] = CSVWriter.getColumnValue(resultSet, metadata.getColumnType(i + 1), i + 1);
            }
            this.writeNext(nextLine);
        }
    }

    public void writeAll(SqlRowSet sqlRowSet, String[] excludedColumnNames, boolean writeColumnName) throws SQLException, IOException {
        SqlRowSetMetaData metadata = sqlRowSet.getMetaData();
        if (writeColumnName) {
            this.writeColumnNames(metadata, excludedColumnNames);
        }
        int columnCount = metadata.getColumnCount();
        String[] allColumnNames = metadata.getColumnNames();
        String[] actualExcludedColumnNames = StringUtils.intersectStringArrays(excludedColumnNames, allColumnNames, false);
        if (actualExcludedColumnNames != null && actualExcludedColumnNames.length > 0) {
            while (sqlRowSet.next()) {
                ArrayList<String> nextLine = new ArrayList<String>();
                for (int i = 0; i < columnCount; ++i) {
                    String columnName = metadata.getColumnName(i + 1);
                    if (StringUtils.contains(actualExcludedColumnNames, columnName, false)) continue;
                    nextLine.add(CSVWriter.getColumnValue(sqlRowSet, metadata.getColumnType(i + 1), i + 1));
                }
                this.writeNext(StringUtils.toStringArray(nextLine));
            }
        } else {
            while (sqlRowSet.next()) {
                String[] nextLine = new String[columnCount];
                for (int i = 0; i < columnCount; ++i) {
                    nextLine[i] = CSVWriter.getColumnValue(sqlRowSet, metadata.getColumnType(i + 1), i + 1);
                }
                this.writeNext(nextLine);
            }
        }
    }

    protected void writeColumnNames(ResultSetMetaData metadata) throws SQLException {
        int columnCount = metadata.getColumnCount();
        String[] nextLine = new String[columnCount];
        for (int i = 0; i < columnCount; ++i) {
            nextLine[i] = metadata.getColumnName(i + 1);
        }
        this.writeNext(nextLine);
    }

    protected void writeColumnNames(SqlRowSetMetaData metadata, String[] excludedColumnNames) throws SQLException {
        int columnCount = metadata.getColumnCount();
        String[] allColumnNames = metadata.getColumnNames();
        String[] actualExcludedColumnNames = StringUtils.intersectStringArrays(excludedColumnNames, allColumnNames, false);
        if (actualExcludedColumnNames != null && actualExcludedColumnNames.length > 0) {
            ArrayList<String> nextLine = new ArrayList<String>();
            for (int i = 0; i < columnCount; ++i) {
                String columnName = metadata.getColumnName(i + 1);
                if (StringUtils.contains(actualExcludedColumnNames, columnName, false)) continue;
                nextLine.add(columnName);
            }
            this.writeNext(StringUtils.toStringArray(nextLine));
        } else {
            String[] nextLine = new String[columnCount];
            for (int i = 0; i < columnCount; ++i) {
                nextLine[i] = metadata.getColumnName(i + 1);
            }
            this.writeNext(nextLine);
        }
    }

    private static String getColumnValue(ResultSet resultSet, int colType, int colIndex) throws SQLException, IOException {
        String value = "";
        switch (colType) {
            case -7: {
                Object bit = resultSet.getObject(colIndex);
                if (bit == null) break;
                value = String.valueOf(bit);
                break;
            }
            case 16: {
                boolean b = resultSet.getBoolean(colIndex);
                if (resultSet.wasNull()) break;
                value = Boolean.valueOf(b).toString();
                break;
            }
            case 2005: {
                Clob c = resultSet.getClob(colIndex);
                if (c == null) break;
                value = CSVWriter.read(c);
                break;
            }
            case -5: 
            case 2: 
            case 3: 
            case 6: 
            case 7: 
            case 8: {
                BigDecimal bd = resultSet.getBigDecimal(colIndex);
                if (bd == null) break;
                value = "" + bd.doubleValue();
                break;
            }
            case -6: 
            case 4: 
            case 5: {
                int intValue = resultSet.getInt(colIndex);
                if (resultSet.wasNull()) break;
                value = "" + intValue;
                break;
            }
            case 2000: {
                Object obj = resultSet.getObject(colIndex);
                if (obj == null) break;
                value = String.valueOf(obj);
                break;
            }
            case 91: {
                Date date = resultSet.getDate(colIndex);
                if (date == null) break;
                value = DATE_FORMATTER.format(date);
                break;
            }
            case 92: {
                Time t = resultSet.getTime(colIndex);
                if (t == null) break;
                value = t.toString();
                break;
            }
            case 93: {
                Timestamp tstamp = resultSet.getTimestamp(colIndex);
                if (tstamp == null) break;
                value = TIMESTAMP_FORMATTER.format(tstamp);
                break;
            }
            case -1: 
            case 1: 
            case 12: {
                value = resultSet.getString(colIndex);
                break;
            }
            default: {
                value = "";
            }
        }
        if (value == null) {
            value = "";
        }
        return value;
    }

    private static String getColumnValue(SqlRowSet sqlRowSet, int colType, int colIndex) throws SQLException, IOException {
        String value = "";
        switch (colType) {
            case -7: {
                Object bit = sqlRowSet.getObject(colIndex);
                if (bit == null) break;
                value = String.valueOf(bit);
                break;
            }
            case 16: {
                boolean b = sqlRowSet.getBoolean(colIndex);
                if (sqlRowSet.wasNull()) break;
                value = Boolean.valueOf(b).toString();
                break;
            }
            case 2005: {
                Object o = sqlRowSet.getObject(colIndex);
                if (o == null || !(o instanceof Clob)) break;
                Clob c = (Clob)o;
                value = CSVWriter.read(c);
                break;
            }
            case -5: 
            case 2: 
            case 3: 
            case 6: 
            case 7: 
            case 8: {
                BigDecimal bd = sqlRowSet.getBigDecimal(colIndex);
                if (bd == null) break;
                value = "" + bd.doubleValue();
                break;
            }
            case -6: 
            case 4: 
            case 5: {
                int intValue = sqlRowSet.getInt(colIndex);
                if (sqlRowSet.wasNull()) break;
                value = "" + intValue;
                break;
            }
            case 2000: {
                Object obj = sqlRowSet.getObject(colIndex);
                if (obj == null) break;
                value = String.valueOf(obj);
                break;
            }
            case 91: {
                Date date = sqlRowSet.getDate(colIndex);
                if (date == null) break;
                value = DATE_FORMATTER.format(date);
                break;
            }
            case 92: {
                Time t = sqlRowSet.getTime(colIndex);
                if (t == null) break;
                value = t.toString();
                break;
            }
            case 93: {
                Timestamp tstamp = sqlRowSet.getTimestamp(colIndex);
                if (tstamp == null) break;
                value = TIMESTAMP_FORMATTER.format(tstamp);
                break;
            }
            case -1: 
            case 1: 
            case 12: {
                value = sqlRowSet.getString(colIndex);
                break;
            }
            default: {
                value = "";
            }
        }
        if (value == null) {
            value = "";
        }
        return value;
    }

    private static String read(Clob c) throws SQLException, IOException {
        StringBuffer sb = new StringBuffer((int)c.length());
        Reader r = c.getCharacterStream();
        char[] cbuf = new char[2048];
        int n = 0;
        while ((n = r.read(cbuf, 0, cbuf.length)) != -1) {
            if (n <= 0) continue;
            sb.append(cbuf, 0, n);
        }
        return sb.toString();
    }

    public void writeNext(String[] nextLine) {
        if (nextLine == null) {
            return;
        }
        StringBuffer sb = new StringBuffer();
        for (int i = 0; i < nextLine.length; ++i) {
            String nextElement;
            if (i != 0) {
                sb.append(this.separator);
            }
            if ((nextElement = nextLine[i]) == null) continue;
            if (this.quotechar != '\u0000') {
                sb.append(this.quotechar);
            }
            for (int j = 0; j < nextElement.length(); ++j) {
                char nextChar = nextElement.charAt(j);
                if (this.escapechar != '\u0000' && nextChar == this.quotechar) {
                    sb.append(this.escapechar).append(nextChar);
                    continue;
                }
                if (this.escapechar != '\u0000' && nextChar == this.escapechar) {
                    sb.append(this.escapechar).append(nextChar);
                    continue;
                }
                sb.append(nextChar);
            }
            if (this.quotechar == '\u0000') continue;
            sb.append(this.quotechar);
        }
        sb.append(this.lineEnd);
        this.pw.write(sb.toString());
    }

    public void flush() throws IOException {
        this.pw.flush();
    }

    public void close() throws IOException {
        this.pw.flush();
        this.pw.close();
        this.rawWriter.close();
    }
}

