/*
 * Decompiled with CFR 0.152.
 */
package com.sinba.common.service;

import org.apache.log4j.Logger;
import org.springframework.security.core.context.SecurityContextHolder;
import org.springframework.security.core.userdetails.UserDetails;
import org.springframework.security.web.authentication.WebAuthenticationDetails;

public class BaseService {
    private static final Logger LOGGER = Logger.getLogger(BaseService.class);
    private String username = "Unknown User";
    private String clientHostAddress = "Unknown Host";

    public String getUsername() {
        if (SecurityContextHolder.getContext().getAuthentication() != null) {
            Object principal = SecurityContextHolder.getContext().getAuthentication().getPrincipal();
            this.username = principal instanceof UserDetails ? ((UserDetails)principal).getUsername() : principal.toString();
        }
        return this.username;
    }

    protected String getClientHostAddress() {
        Object details;
        if (SecurityContextHolder.getContext().getAuthentication() != null && (details = SecurityContextHolder.getContext().getAuthentication().getDetails()) instanceof WebAuthenticationDetails) {
            this.clientHostAddress = ((WebAuthenticationDetails)details).getRemoteAddress();
        }
        return this.clientHostAddress;
    }

    protected void logAuditTrail(String actionDesc) {
        StringBuilder logMessage = new StringBuilder();
        logMessage.append(this.getUsername());
        logMessage.append(" from ");
        logMessage.append(this.getClientHostAddress());
        logMessage.append(": ");
        logMessage.append(actionDesc);
        LOGGER.info((Object)logMessage.toString());
    }
}

