/*
 * Decompiled with CFR 0.152.
 */
package org.jbpm.integration.tomcat6;

import java.security.Principal;
import java.sql.Connection;
import java.sql.DriverManager;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.List;
import javax.naming.Context;
import javax.naming.NamingException;
import javax.sql.DataSource;
import org.apache.catalina.Realm;
import org.apache.catalina.ServerFactory;
import org.apache.catalina.core.StandardServer;
import org.apache.catalina.realm.GenericPrincipal;
import org.apache.catalina.realm.RealmBase;
import org.apache.naming.ContextBindings;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class JbpmConsoleRealm
extends RealmBase {
    private String driverName;
    private String connectionUrl;
    private String connectionName;
    private String connectionPassword;
    private String dataSourceName;
    private boolean localDataSource;
    private DataSource dataSource;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public Principal authenticate(String user, String credentials) {
        try {
            Connection conn = this.openConnection();
            try {
                long userId = this.retrieveUserId(conn, user, credentials);
                if (userId == -1L) return null;
                List<String> roles = this.retrieveRoles(conn, userId);
                GenericPrincipal genericPrincipal = new GenericPrincipal((Realm)this, user, credentials, roles);
                return genericPrincipal;
            }
            finally {
                conn.close();
            }
        }
        catch (SQLException e) {
            this.containerLog.error((Object)e);
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private long retrieveUserId(Connection conn, String username, String password) throws SQLException {
        PreparedStatement stm = conn.prepareStatement("SELECT DBID_\nFROM JBPM4_ID_USER\nWHERE ID_=? AND PASSWORD_=?");
        try {
            stm.setString(1, username);
            stm.setString(2, password);
            ResultSet rs = stm.executeQuery();
            if (rs.next()) {
                long l = rs.getLong(1);
                return l;
            }
        }
        finally {
            stm.close();
        }
        return -1L;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private List<String> retrieveRoles(Connection conn, Long userDbId) throws SQLException {
        PreparedStatement stm = conn.prepareStatement("SELECT JBPM4_ID_GROUP.NAME_\nFROM JBPM4_ID_GROUP\nINNER JOIN JBPM4_ID_MEMBERSHIP ON JBPM4_ID_MEMBERSHIP.GROUP_=JBPM4_ID_GROUP.DBID_\nINNER JOIN JBPM4_ID_USER ON JBPM4_ID_MEMBERSHIP.USER_=JBPM4_ID_USER.DBID_\nWHERE JBPM4_ID_USER.DBID_=?");
        try {
            stm.setLong(1, userDbId);
            ResultSet rs = stm.executeQuery();
            ArrayList<String> roles = new ArrayList<String>();
            while (rs.next()) {
                roles.add(rs.getString(1));
            }
            ArrayList<String> arrayList = roles;
            return arrayList;
        }
        finally {
            stm.close();
        }
    }

    public Principal authenticate(String user, byte[] credentials) {
        return this.authenticate(user, new String(credentials));
    }

    public Principal authenticate(String arg0, String arg1, String arg2, String arg3, String arg4, String arg5, String arg6, String arg7) {
        throw new UnsupportedOperationException();
    }

    protected String getPassword(String username) {
        throw new UnsupportedOperationException();
    }

    protected Principal getPrincipal(String userName) {
        throw new UnsupportedOperationException();
    }

    protected String getName() {
        return ((Object)((Object)this)).getClass().getName();
    }

    public String getInfo() {
        return "JbpmConsoleRealm";
    }

    private Connection openConnection() throws SQLException {
        if (this.dataSourceName != null) {
            if (this.dataSource == null) {
                try {
                    Context context;
                    if (this.localDataSource) {
                        context = (Context)ContextBindings.getClassLoader().lookup("comp/env");
                    } else {
                        StandardServer server = (StandardServer)ServerFactory.getServer();
                        context = server.getGlobalNamingContext();
                    }
                    this.dataSource = (DataSource)context.lookup(this.dataSourceName);
                }
                catch (NamingException e) {
                    SQLException sqlException = new SQLException("failed to retrieve " + this.dataSourceName);
                    sqlException.initCause(e);
                    throw sqlException;
                }
            }
            return this.dataSource.getConnection();
        }
        try {
            Class.forName(this.driverName);
            Connection connection = DriverManager.getConnection(this.connectionUrl, this.connectionName, this.connectionPassword);
            connection.setReadOnly(true);
            return connection;
        }
        catch (ClassNotFoundException e) {
            SQLException sqlException = new SQLException("could not find " + this.driverName);
            sqlException.initCause(e);
            throw sqlException;
        }
    }

    public String getDataSourceName() {
        return this.dataSourceName;
    }

    public void setDataSourceName(String dataSourceName) {
        this.dataSourceName = dataSourceName;
    }

    public String getDriverName() {
        return this.driverName;
    }

    public void setDriverName(String driverName) {
        this.driverName = driverName;
    }

    public String getConnectionUrl() {
        return this.connectionUrl;
    }

    public void setConnectionUrl(String connectionUrl) {
        this.connectionUrl = connectionUrl;
    }

    public String getConnectionName() {
        return this.connectionName;
    }

    public void setConnectionName(String connectionName) {
        this.connectionName = connectionName;
    }

    public String getConnectionPassword() {
        return this.connectionPassword;
    }

    public void setConnectionPassword(String connectionPassword) {
        this.connectionPassword = connectionPassword;
    }
}

