/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.test.annotation;

import java.lang.reflect.Method;
import java.util.Map;
import javax.sql.DataSource;
import org.apache.commons.logging.Log;
import org.springframework.context.ApplicationContext;
import org.springframework.jdbc.core.JdbcOperations;
import org.springframework.jdbc.core.simple.SimpleJdbcTemplate;
import org.springframework.test.AbstractTransactionalDataSourceSpringContextTests;
import org.springframework.test.annotation.DirtiesContext;
import org.springframework.test.annotation.ExpectedException;
import org.springframework.test.annotation.IfProfileValue;
import org.springframework.test.annotation.NotTransactional;
import org.springframework.test.annotation.ProfileValueSource;
import org.springframework.test.annotation.Repeat;
import org.springframework.test.annotation.SystemProfileValueSource;
import org.springframework.test.annotation.Timed;
import org.springframework.transaction.TransactionDefinition;
import org.springframework.transaction.annotation.AnnotationTransactionAttributeSource;
import org.springframework.transaction.interceptor.TransactionAttribute;
import org.springframework.transaction.interceptor.TransactionAttributeSource;

public abstract class AbstractAnnotationAwareTransactionalTests
extends AbstractTransactionalDataSourceSpringContextTests {
    protected SimpleJdbcTemplate simpleJdbcTemplate;
    private TransactionAttributeSource transactionAttributeSource = new AnnotationTransactionAttributeSource();
    protected ProfileValueSource profileValueSource = SystemProfileValueSource.getInstance();

    public void setDataSource(DataSource dataSource) {
        super.setDataSource(dataSource);
        this.simpleJdbcTemplate = new SimpleJdbcTemplate((JdbcOperations)this.jdbcTemplate);
    }

    protected void findUniqueProfileValueSourceFromContext(ApplicationContext ac) {
        Map beans = ac.getBeansOfType(ProfileValueSource.class);
        if (beans.size() == 1) {
            this.profileValueSource = (ProfileValueSource)beans.values().iterator().next();
        }
    }

    public void runBare() throws Throwable {
        if (this.isDisabledInThisEnvironment(this.getName())) {
            super.runBare();
            return;
        }
        final Method testMethod = ((Object)((Object)this)).getClass().getMethod(this.getName(), null);
        if (this.isDisabledInThisEnvironment(testMethod)) {
            this.logger.info((Object)("**** " + ((Object)((Object)this)).getClass().getName() + "." + this.getName() + " disabled in this environment: " + "Total disabled tests=" + AbstractAnnotationAwareTransactionalTests.getDisabledTestCount()));
            this.recordDisabled();
            return;
        }
        TransactionAttribute explicitTransactionDefinition = this.transactionAttributeSource.getTransactionAttribute(testMethod, ((Object)((Object)this)).getClass());
        if (explicitTransactionDefinition != null) {
            this.logger.info((Object)("Custom transaction definition [" + explicitTransactionDefinition + " for test method " + this.getName()));
            this.setTransactionDefinition((TransactionDefinition)explicitTransactionDefinition);
        } else if (testMethod.isAnnotationPresent(NotTransactional.class)) {
            this.preventTransaction();
        }
        AbstractAnnotationAwareTransactionalTests.runTestTimed(new TestExecutionCallback(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public void run() throws Throwable {
                try {
                    AbstractAnnotationAwareTransactionalTests.super.runBare();
                }
                finally {
                    if (testMethod.isAnnotationPresent(DirtiesContext.class)) {
                        AbstractAnnotationAwareTransactionalTests.this.setDirty();
                    }
                }
            }
        }, testMethod, this.logger);
    }

    protected boolean isDisabledInThisEnvironment(Method testMethod) {
        IfProfileValue inProfile = testMethod.getAnnotation(IfProfileValue.class);
        if (inProfile == null) {
            inProfile = ((Object)((Object)this)).getClass().getAnnotation(IfProfileValue.class);
        }
        if (inProfile != null) {
            return !this.profileValueSource.get(inProfile.name()).equals(inProfile.value());
        }
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void runTestTimed(TestExecutionCallback tec, Method testMethod, Log logger) throws Throwable {
        Timed timed = testMethod.getAnnotation(Timed.class);
        if (timed == null) {
            AbstractAnnotationAwareTransactionalTests.runTest(tec, testMethod, logger);
        } else {
            long startTime = System.currentTimeMillis();
            try {
                AbstractAnnotationAwareTransactionalTests.runTest(tec, testMethod, logger);
            }
            finally {
                long elapsed = System.currentTimeMillis() - startTime;
                if (elapsed > timed.millis()) {
                    AbstractAnnotationAwareTransactionalTests.fail((String)("Took " + elapsed + " ms; limit was " + timed.millis()));
                }
            }
        }
    }

    private static void runTest(TestExecutionCallback tec, Method testMethod, Log logger) throws Throwable {
        ExpectedException ee = testMethod.getAnnotation(ExpectedException.class);
        Repeat repeat = testMethod.getAnnotation(Repeat.class);
        int runs = repeat != null ? repeat.value() : 1;
        for (int i = 0; i < runs; ++i) {
            try {
                if (i > 0 && logger != null) {
                    logger.info((Object)("Repetition " + i + " of test " + testMethod.getName()));
                }
                tec.run();
                if (ee == null) continue;
                AbstractAnnotationAwareTransactionalTests.fail((String)("Expected throwable of class " + ee.value()));
                continue;
            }
            catch (Throwable ex) {
                if (ee == null) {
                    throw ex;
                }
                if (ee.value().isAssignableFrom(ex.getClass())) continue;
                throw ex;
            }
        }
    }

    private static interface TestExecutionCallback {
        public void run() throws Throwable;
    }
}

