/*
 * Decompiled with CFR 0.152.
 */
package org.apache.struts2.sitemesh;

import com.opensymphony.module.sitemesh.Decorator;
import com.opensymphony.module.sitemesh.HTMLPage;
import com.opensymphony.module.sitemesh.Page;
import com.opensymphony.xwork2.ActionContext;
import com.opensymphony.xwork2.inject.Inject;
import com.opensymphony.xwork2.util.logging.Logger;
import com.opensymphony.xwork2.util.logging.LoggerFactory;
import java.io.IOException;
import java.io.PrintWriter;
import java.io.Writer;
import javax.servlet.ServletContext;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.struts2.sitemesh.TemplatePageFilter;
import org.apache.struts2.views.velocity.VelocityManager;
import org.apache.velocity.Template;
import org.apache.velocity.context.Context;

public class VelocityPageFilter
extends TemplatePageFilter {
    private static final Logger LOG = LoggerFactory.getLogger(VelocityPageFilter.class);
    private static VelocityManager velocityManager;

    @Inject(required=false)
    public static void setVelocityManager(VelocityManager mgr) {
        velocityManager = mgr;
    }

    protected void applyDecorator(Page page, Decorator decorator, HttpServletRequest req, HttpServletResponse res, ServletContext servletContext, ActionContext ctx) throws ServletException, IOException {
        if (velocityManager == null) {
            throw new ServletException("Missing freemarker dependency");
        }
        try {
            velocityManager.init(servletContext);
            String encoding = this.getEncoding();
            Template template = velocityManager.getVelocityEngine().getTemplate(decorator.getPage(), encoding);
            Context context = velocityManager.createContext(ctx.getValueStack(), req, res);
            context.put("page", (Object)page);
            if (page instanceof HTMLPage) {
                HTMLPage htmlPage = (HTMLPage)page;
                context.put("head", (Object)htmlPage.getHead());
            }
            context.put("title", (Object)page.getTitle());
            context.put("body", (Object)page.getBody());
            PrintWriter writer = res.getWriter();
            template.merge(context, (Writer)writer);
            writer.flush();
        }
        catch (Exception e) {
            String msg = "Error applying decorator: " + e.getMessage();
            LOG.error(msg, (Throwable)e, new String[0]);
            throw new ServletException(msg, (Throwable)e);
        }
    }
}

