/*
 * Decompiled with CFR 0.152.
 */
package com.sinba.common.report.action;

import com.opensymphony.xwork2.ActionContext;
import com.opensymphony.xwork2.ActionSupport;
import com.sinba.common.config.util.AppConfigUtils;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.InputStream;
import java.sql.Connection;
import java.sql.SQLException;
import javax.sql.DataSource;
import net.sf.jasperreports.engine.JRException;
import net.sf.jasperreports.engine.JRExporterParameter;
import net.sf.jasperreports.engine.JasperCompileManager;
import net.sf.jasperreports.engine.JasperFillManager;
import net.sf.jasperreports.engine.JasperPrint;
import net.sf.jasperreports.engine.export.JExcelApiExporter;
import net.sf.jasperreports.engine.export.JRCsvExporter;
import net.sf.jasperreports.engine.export.JRHtmlExporter;
import net.sf.jasperreports.engine.export.JRHtmlExporterParameter;
import net.sf.jasperreports.engine.export.JRPdfExporter;

public class ReportAction
extends ActionSupport {
    private static final String JASPER_PATH = AppConfigUtils.getInstance().getReportPath();
    private String jrxmlPath = "";
    private String jasperPath = "";
    private String format = "html";
    private DataSource dataSource;
    private InputStream exportStream;
    private String contentType;
    private String htmlReport;
    private String fileName;

    public String getJrxmlPath() {
        return this.jrxmlPath;
    }

    public void setJrxmlPath(String jrxmlPath) {
        this.jrxmlPath = jrxmlPath;
    }

    public String getFormat() {
        return this.format;
    }

    public void setFormat(String format) {
        this.format = format;
    }

    public DataSource getDataSource() {
        return this.dataSource;
    }

    public void setDataSource(DataSource dataSource) {
        this.dataSource = dataSource;
    }

    public InputStream getExportStream() {
        return this.exportStream;
    }

    public void setExportStream(InputStream exportStream) {
        this.exportStream = exportStream;
    }

    public String getContentType() {
        return this.contentType;
    }

    public void setContentType(String contentType) {
        this.contentType = contentType;
    }

    public String getHtmlReport() {
        return this.htmlReport;
    }

    public void setHtmlReport(String htmlReport) {
        this.htmlReport = htmlReport;
    }

    public static String getJasperPath() {
        return JASPER_PATH;
    }

    public String getFileName() {
        return this.fileName;
    }

    public void setFileName(String fileName) {
        this.fileName = fileName;
    }

    public String exportReport() throws JRException {
        this.jrxmlPath = JASPER_PATH + "/" + this.fileName + ".jrxml";
        this.jasperPath = JASPER_PATH + "/" + this.fileName + ".jasper";
        JasperCompileManager.compileReportToFile((String)this.jrxmlPath, (String)this.jasperPath);
        JasperPrint jasperPrint = null;
        try {
            jasperPrint = JasperFillManager.fillReport((String)this.jasperPath, null, (Connection)this.dataSource.getConnection());
        }
        catch (SQLException e) {
            e.printStackTrace();
        }
        String encoding = "UTF-8";
        this.contentType = "application/" + this.format;
        JRPdfExporter exporter = null;
        if ("pdf".equals(this.format)) {
            exporter = new JRPdfExporter();
        } else if ("html".equals(this.format)) {
            exporter = new JRHtmlExporter();
            this.contentType = "text/html; charset=UTF-8";
        } else if ("csv".equals(this.format)) {
            exporter = new JRCsvExporter();
            encoding = "GBK";
            this.contentType = "text/csv; charset=GBK";
        } else if ("xls".equals(this.format)) {
            exporter = new JExcelApiExporter();
            this.contentType = "application/vnd.ms-excel";
        }
        exporter.setParameter(JRExporterParameter.JASPER_PRINT, (Object)jasperPrint);
        ByteArrayOutputStream outstream = new ByteArrayOutputStream();
        exporter.setParameter(JRExporterParameter.OUTPUT_STREAM, (Object)outstream);
        exporter.setParameter(JRExporterParameter.CHARACTER_ENCODING, (Object)encoding);
        exporter.exportReport();
        this.exportStream = new ByteArrayInputStream(outstream.toByteArray());
        return "success";
    }

    public String previewReport(String fileName) {
        try {
            String folderName = "report_" + Math.random();
            this.jrxmlPath = JASPER_PATH + "/" + fileName + ".jrxml";
            this.jasperPath = JASPER_PATH + "/" + fileName + ".jasper";
            JasperCompileManager.compileReportToFile((String)this.jrxmlPath, (String)this.jasperPath);
            JasperPrint jasperPrint = JasperFillManager.fillReport((String)this.jasperPath, null, (Connection)this.dataSource.getConnection());
            ActionContext.getContext().getSession().put("currentReportPrint", jasperPrint);
            StringBuffer sbuffer = new StringBuffer();
            JRHtmlExporter exporter = new JRHtmlExporter();
            exporter.setParameter(JRExporterParameter.JASPER_PRINT, (Object)jasperPrint);
            exporter.setParameter(JRExporterParameter.OUTPUT_STRING_BUFFER, (Object)sbuffer);
            exporter.setParameter((JRExporterParameter)JRHtmlExporterParameter.IMAGES_URI, (Object)("../jasper/images/" + folderName + "/"));
            exporter.setParameter((JRExporterParameter)JRHtmlExporterParameter.IMAGES_DIR_NAME, (Object)(JASPER_PATH + "\\images\\" + folderName + "\\"));
            exporter.setParameter((JRExporterParameter)JRHtmlExporterParameter.IS_OUTPUT_IMAGES_TO_DIR, (Object)Boolean.TRUE);
            exporter.exportReport();
            if (sbuffer.toString().indexOf("JR_PAGE_ANCHOR_0_1") != -1) {
                return sbuffer.toString();
            }
            return null;
        }
        catch (Exception e) {
            e.printStackTrace();
            return null;
        }
    }

    public String statReport() {
        this.htmlReport = this.previewReport(this.fileName);
        return "preview";
    }

    public String exportHTML() {
        this.htmlReport = this.previewReport(this.fileName);
        return "exportHTML";
    }
}

