/*
 * Decompiled with CFR 0.152.
 */
package com.sinba.itsm.cim.dao;

import com.sinba.common.dao.BaseDAOImplHibernate;
import com.sinba.common.dto.PageDTO;
import com.sinba.itsm.cim.dao.ICIRelevanceDAO;
import com.sinba.itsm.cim.dto.CIRelevanceDTO;
import com.sinba.itsm.cim.entity.CIRelevance;
import java.util.List;
import org.hibernate.criterion.Criterion;
import org.hibernate.criterion.DetachedCriteria;
import org.hibernate.criterion.Disjunction;
import org.hibernate.criterion.Order;
import org.hibernate.criterion.Restrictions;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class CIRelevanceDAO
extends BaseDAOImplHibernate<CIRelevance>
implements ICIRelevanceDAO {
    @Override
    public PageDTO findPager(Long ciRelevanceId, int start, int limit) {
        DetachedCriteria dc = DetachedCriteria.forClass(CIRelevance.class);
        Disjunction disjunction = Restrictions.disjunction();
        dc.add((Criterion)disjunction);
        dc.createAlias("ciRelevanceId", "cir");
        dc.createAlias("unCiRelevanceId", "unc");
        disjunction.add((Criterion)Restrictions.eq((String)"cir.ciId", (Object)ciRelevanceId));
        disjunction.add((Criterion)Restrictions.eq((String)"unc.ciId", (Object)ciRelevanceId));
        dc.addOrder(Order.desc((String)"relevanceId"));
        return super.findPageByCriteria(dc, start, limit);
    }

    @Override
    public List<CIRelevance> findCiRelevanceList(Long ciId) {
        String hql = " from CIRelevance cire where cire.ciRelevanceId.ciId=? and cire.dataFlag not in(99)";
        return super.getHibernateTemplate().find(hql, (Object)ciId);
    }

    @Override
    public List<CIRelevance> findNuCiRelevanceList(Long ciId) {
        String hql = " from CIRelevance cire where cire.unCiRelevanceId.ciId=? and cire.dataFlag not in(99)";
        return super.getHibernateTemplate().find(hql, (Object)ciId);
    }

    @Override
    public boolean ciIfRelevance(CIRelevanceDTO ciReleDto) {
        boolean result = false;
        if (ciReleDto != null) {
            String hql = " from CIRelevance cire where ((cire.unCiRelevanceId.ciId=? and cire.ciRelevanceId.ciId=? ) or (cire.unCiRelevanceId.ciId=? and cire.ciRelevanceId.ciId=? )) and cire.dataFlag not in(99)";
            List list = super.getHibernateTemplate().find(hql, new Object[]{ciReleDto.getCiRelevanceId(), ciReleDto.getUnCiRelevanceId(), ciReleDto.getUnCiRelevanceId(), ciReleDto.getCiRelevanceId()});
            result = list.size() != 0;
        }
        return result;
    }
}

