/*
 * Decompiled with CFR 0.152.
 */
package com.sinba.itsm.cim.service;

import com.sinba.common.config.category.dto.CategoryDTO;
import com.sinba.common.config.category.dto.CategoryTreeViewDTO;
import com.sinba.common.config.category.entity.Category;
import com.sinba.common.exception.ApplicationException;
import com.sinba.itsm.cim.dao.ICICategoryDAO;
import com.sinba.itsm.cim.entity.CICategory;
import com.sinba.itsm.cim.service.ICICategoryService;
import java.util.ArrayList;
import java.util.List;
import org.apache.commons.beanutils.BeanUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.transaction.annotation.Transactional;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class CICategoryService
implements ICICategoryService {
    @Autowired
    private ICICategoryDAO cicategoryDAO;

    @Override
    @Transactional
    public List<CategoryTreeViewDTO> findCICategoryTreeDtos(String name) {
        ArrayList<CategoryTreeViewDTO> dtos = new ArrayList<CategoryTreeViewDTO>();
        List<CICategory> entities = this.cicategoryDAO.findConfigurationItems(name);
        for (CICategory entity : entities) {
            CategoryTreeViewDTO dto = new CategoryTreeViewDTO();
            CICategoryService.entity2dto((Category)entity, dto);
            dtos.add(dto);
        }
        return dtos;
    }

    @Override
    @Transactional
    public CategoryDTO findCICategoryById(Long dto) {
        CICategory entity = (CICategory)((Object)this.cicategoryDAO.findById(dto));
        CategoryDTO dtos = new CategoryDTO();
        CICategoryService.entity2dto(entity, dtos);
        return dtos;
    }

    @Override
    @Transactional
    public void saveCICategory(CategoryDTO dto) {
        CICategory entity = new CICategory();
        CICategoryService.dto2entity(dto, entity);
        if (dto.getParentNo() != null) {
            CICategory parent = (CICategory)((Object)this.cicategoryDAO.findById(dto.getParentNo()));
            entity.setParent(parent);
        }
        this.cicategoryDAO.save((Object)entity);
    }

    @Override
    @Transactional
    public boolean removeCICategory(Long cno) {
        boolean result = true;
        Byte delete = 1;
        CICategory ciCategory = (CICategory)((Object)this.cicategoryDAO.findById(cno));
        if (ciCategory.getDataFlag().equals(delete)) {
            result = true;
        } else {
            this.cicategoryDAO.delete((Object)ciCategory);
        }
        return result;
    }

    @Override
    @Transactional
    public void updateCICategory(CategoryDTO dto) {
        CICategory entity = (CICategory)((Object)this.cicategoryDAO.findById(dto.getCno()));
        if (dto.getCname() != null) {
            entity.setCname(dto.getCname());
        }
        if (dto.getDescription() != null) {
            entity.setDescription(dto.getDescription());
        }
        if (dto.getIconPath() != null) {
            entity.setIconPath(dto.getIconPath());
        }
        if (dto.getCategoryType() != null) {
            entity.setCategoryType(dto.getCategoryType());
        }
    }

    @Override
    @Transactional
    public void changeCICategory(CategoryDTO dto) {
        CICategory entity = (CICategory)((Object)this.cicategoryDAO.findById(dto.getCno()));
        CICategory parent = (CICategory)((Object)this.cicategoryDAO.findById(dto.getParentNo()));
        entity.setParent(parent);
        this.cicategoryDAO.save((Object)entity);
    }

    public void setChild(CICategory parent, CICategory child) {
        if (child.getChildren() != null && child.getChildren().size() > 0) {
            for (Category c : child.getChildren()) {
                CICategory nc = new CICategory();
                nc.setCategoryType(c.getCategoryType());
                nc.setCname(c.getCname());
                nc.setIconPath(c.getIconPath());
                nc.setDescription(c.getDescription());
                nc.setParent(parent);
                this.cicategoryDAO.save((Object)nc);
                this.setChild(nc, (CICategory)c);
            }
        }
    }

    @Override
    @Transactional
    public void copyCICategory(CategoryDTO dto) {
        CICategory entity = (CICategory)((Object)this.cicategoryDAO.findById(dto.getCno()));
        CICategory parent = (CICategory)((Object)this.cicategoryDAO.findById(dto.getParentNo()));
        CICategory newChild = new CICategory();
        newChild.setCategoryType(entity.getCategoryType());
        newChild.setCname(entity.getCname());
        newChild.setIconPath(entity.getIconPath());
        newChild.setDescription(entity.getDescription());
        newChild.setParent(parent);
        this.cicategoryDAO.save((Object)newChild);
        this.setChild(newChild, entity);
    }

    public static void dto2entity(CategoryDTO dto, CICategory entity) {
        try {
            BeanUtils.copyProperties((Object)((Object)entity), (Object)dto);
        }
        catch (Exception ex) {
            throw new ApplicationException(ex);
        }
    }

    public static void entity2dto(CICategory entity, CategoryDTO dto) {
        try {
            BeanUtils.copyProperties((Object)dto, (Object)((Object)entity));
        }
        catch (Exception ex) {
            throw new ApplicationException(ex);
        }
    }

    public static void entity2dto(Category entity, CategoryTreeViewDTO dto) {
        if (entity.getDataFlag() != null && entity.getDataFlag() != 99) {
            try {
                dto.setData(entity.getCname());
                dto.getAttr().put("cno", "" + entity.getCno());
                dto.getAttr().put("cname", entity.getCname());
                dto.getAttr().put("description", entity.getDescription());
                dto.getAttr().put("iconPath", entity.getIconPath());
                if (entity.getCategoryType() != null) {
                    dto.getAttr().put("categoryType", entity.getCategoryType().toString());
                }
                if (!entity.getChildren().isEmpty() && CICategoryService.selectChilren(entity.getChildren())) {
                    for (Category ctg : entity.getChildren()) {
                        CategoryTreeViewDTO regDTO = new CategoryTreeViewDTO();
                        CICategoryService.entity2dto(ctg, regDTO);
                        dto.getChildren().add(regDTO);
                    }
                }
            }
            catch (Exception ex) {
                throw new ApplicationException("Exception caused while converting Entity into DTO: " + ex.getMessage());
            }
        }
    }

    public static boolean selectChilren(List<Category> clist) {
        Boolean hasChildren = false;
        for (Category ct : clist) {
            if (ct.getDataFlag() == null || ct.getDataFlag() == 99) continue;
            hasChildren = true;
            break;
        }
        return hasChildren;
    }
}

