/*
 * Decompiled with CFR 0.152.
 */
package com.sinba.itsm.cim.service;

import com.sinba.common.dto.PageDTO;
import com.sinba.common.exception.ApplicationException;
import com.sinba.itsm.cim.dao.ICIDAO;
import com.sinba.itsm.cim.dao.ICIRelevanceDAO;
import com.sinba.itsm.cim.dto.CIRelevanceDTO;
import com.sinba.itsm.cim.dto.CiRelevanceTreeViewDTO;
import com.sinba.itsm.cim.entity.CI;
import com.sinba.itsm.cim.entity.CIRelevance;
import com.sinba.itsm.cim.service.ICIRelevanceService;
import java.util.ArrayList;
import java.util.List;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.transaction.annotation.Transactional;

public class CIRelevanceService
implements ICIRelevanceService {
    @Autowired
    private ICIRelevanceDAO ciRelevanceDAO;
    @Autowired
    private ICIDAO ciDAO;

    private void entity2dto(CIRelevance ciEntity, CIRelevanceDTO ciDto) {
        try {
            ciDto.setRelevanceId(ciEntity.getRelevanceId());
            ciDto.setRelevanceDesc(ciEntity.getRelevanceDesc());
            ciDto.setCiRelevanceName(ciEntity.getCiRelevanceId().getCiname());
            ciDto.setCiRelevanceId(ciEntity.getCiRelevanceId().getCiId());
            ciDto.setUnCiRelevanceId(ciEntity.getUnCiRelevanceId().getCiId());
            ciDto.setUnCiRelevanceName(ciEntity.getUnCiRelevanceId().getCiname());
        }
        catch (Exception e) {
            throw new ApplicationException(e);
        }
    }

    public PageDTO configureItemRelevanceFindPager(Long ciRelevanceId, int start, int limit) {
        PageDTO page = this.ciRelevanceDAO.findPager(ciRelevanceId, start, limit);
        List entities = page.getData();
        ArrayList<CIRelevanceDTO> dtos = new ArrayList<CIRelevanceDTO>(entities.size());
        for (CIRelevance entity : entities) {
            CIRelevanceDTO dto = new CIRelevanceDTO();
            this.entity2dto(entity, dto);
            dtos.add(dto);
        }
        page.setData(dtos);
        return page;
    }

    public void configureItemRelevanceAdd(CIRelevanceDTO ciRelevanceDTO) {
        CIRelevance ciRelevance = new CIRelevance();
        ciRelevance.setRelevanceDesc(ciRelevanceDTO.getRelevanceDesc());
        CI ci = new CI();
        ci.setCiId(ciRelevanceDTO.getCiRelevanceId());
        ciRelevance.setCiRelevanceId(ci);
        CI ci1 = new CI();
        ci1.setCiId(ciRelevanceDTO.getUnCiRelevanceId());
        ciRelevance.setUnCiRelevanceId(ci1);
        this.ciRelevanceDAO.save((Object)ciRelevance);
    }

    public void configureItemRelevanceUpdate(CIRelevanceDTO ciRelevanceDTO) {
        CIRelevance ciRelevance = new CIRelevance();
        ciRelevance.setRelevanceDesc(ciRelevanceDTO.getRelevanceDesc());
        CI ci = new CI();
        ci.setCiId(ciRelevanceDTO.getCiRelevanceId());
        ciRelevance.setCiRelevanceId(ci);
        CI ci1 = new CI();
        ci1.setCiId(ciRelevanceDTO.getUnCiRelevanceId());
        ciRelevance.setUnCiRelevanceId(ci1);
        this.ciRelevanceDAO.merge((Object)ciRelevance);
    }

    public void configureItemRelevanceDelete(Long[] relevanceIds) {
        if (relevanceIds != null) {
            ArrayList<CIRelevance> reList = new ArrayList<CIRelevance>();
            for (Long id : relevanceIds) {
                CIRelevance cirele = (CIRelevance)((Object)this.ciRelevanceDAO.findById(id));
                reList.add(cirele);
            }
            this.ciRelevanceDAO.deleteAll(reList);
        }
    }

    public static void entity2dto1(CIRelevance entity, CIRelevanceDTO dto) {
        try {
            dto.setCiRelevanceId(entity.getRelevanceId());
            dto.setCiRelevanceId(entity.getCiRelevanceId().getCiId());
            dto.setCiRelevanceName(entity.getCiRelevanceId().getCiname());
            dto.setRelevanceDesc(entity.getRelevanceDesc());
            dto.setUnCiRelevanceId(entity.getUnCiRelevanceId().getCiId());
            dto.setUnCiRelevanceName(entity.getUnCiRelevanceId().getCiname());
        }
        catch (Exception ex) {
            throw new ApplicationException(ex);
        }
    }

    public void entity2dto(CIRelevance entity, CiRelevanceTreeViewDTO dto) {
        CIRelevanceDTO ciReleDto = new CIRelevanceDTO();
        CIRelevanceService.entity2dto1(entity, ciReleDto);
        dto.setData(ciReleDto.getCiRelevanceName());
        dto.getAttr().put("relevanceId", "" + ciReleDto.getRelevanceId());
        dto.getAttr().put("relevanceDesc", ciReleDto.getRelevanceDesc());
        dto.getAttr().put("ciRelevanceId", "" + ciReleDto.getCiRelevanceId());
        dto.getAttr().put("ciRelevanceName", ciReleDto.getCiRelevanceName());
        dto.getAttr().put("unCiRelevanceId", "" + ciReleDto.getUnCiRelevanceName());
        dto.getAttr().put("unCiRelevanceName", ciReleDto.getUnCiRelevanceName());
    }

    public void entity2dto2(CIRelevance entity, CiRelevanceTreeViewDTO dto) {
        CIRelevanceDTO ciReleDto = new CIRelevanceDTO();
        CIRelevanceService.entity2dto1(entity, ciReleDto);
        dto.setData(ciReleDto.getUnCiRelevanceName());
        dto.getAttr().put("relevanceId", "" + ciReleDto.getRelevanceId());
        dto.getAttr().put("relevanceDesc", ciReleDto.getRelevanceDesc());
        dto.getAttr().put("ciRelevanceId", "" + ciReleDto.getUnCiRelevanceId());
        dto.getAttr().put("ciRelevanceName", ciReleDto.getUnCiRelevanceName());
        dto.getAttr().put("unCiRelevanceId", "" + ciReleDto.getCiRelevanceId());
        dto.getAttr().put("unCiRelevanceName", ciReleDto.getCiRelevanceName());
    }

    @Transactional
    public CiRelevanceTreeViewDTO ciReleTree(Long ciId, String forward, String back) {
        List<CIRelevance> ciReleList = this.ciRelevanceDAO.findCiRelevanceList(ciId);
        List<CIRelevance> nuCiReleList = this.ciRelevanceDAO.findNuCiRelevanceList(ciId);
        CiRelevanceTreeViewDTO dto = new CiRelevanceTreeViewDTO();
        CI ci = (CI)((Object)this.ciDAO.findById(ciId));
        dto.setData(ci.getCiname());
        dto.getAttr().put("ciRelevanceId", "");
        dto.getAttr().put("ciRelevanceName", ci.getCiname());
        CiRelevanceTreeViewDTO dto1 = new CiRelevanceTreeViewDTO();
        dto1.setData(forward);
        dto1.getAttr().put("ciRelevanceId", "");
        dto1.getAttr().put("ciRelevanceName", back);
        ArrayList<CiRelevanceTreeViewDTO> ciReleTree1 = new ArrayList<CiRelevanceTreeViewDTO>();
        for (CIRelevance cire : ciReleList) {
            CiRelevanceTreeViewDTO cireledto = new CiRelevanceTreeViewDTO();
            this.entity2dto2(cire, cireledto);
            ciReleTree1.add(cireledto);
        }
        dto1.setChildren(ciReleTree1);
        CiRelevanceTreeViewDTO dto2 = new CiRelevanceTreeViewDTO();
        dto2.setData(forward);
        dto2.getAttr().put("ciRelevanceId", "");
        dto2.getAttr().put("ciRelevanceName", back);
        ArrayList<CiRelevanceTreeViewDTO> ciReleTree2 = new ArrayList<CiRelevanceTreeViewDTO>();
        for (CIRelevance cire : nuCiReleList) {
            CiRelevanceTreeViewDTO cireledto = new CiRelevanceTreeViewDTO();
            this.entity2dto(cire, cireledto);
            ciReleTree2.add(cireledto);
        }
        dto2.setChildren(ciReleTree2);
        ArrayList<CiRelevanceTreeViewDTO> ciReleTree = new ArrayList<CiRelevanceTreeViewDTO>();
        ciReleTree.add(dto1);
        ciReleTree.add(dto2);
        dto.setChildren(ciReleTree);
        return dto;
    }

    public boolean ciIfRelevance(CIRelevanceDTO ciReleDto) {
        return this.ciRelevanceDAO.ciIfRelevance(ciReleDto);
    }
}

