/*
 * Decompiled with CFR 0.152.
 */
package com.sinba.itsm.cim.service;

import com.sinba.common.config.attachment.dao.IAttachmentDAO;
import com.sinba.common.config.attachment.entity.Attachment;
import com.sinba.common.config.attachment.service.IAttachmentService;
import com.sinba.common.config.category.entity.Category;
import com.sinba.common.config.dictionary.dao.IDataDictionaryItemsDAO;
import com.sinba.common.config.dictionary.entity.DataDictionaryItems;
import com.sinba.common.dto.PageDTO;
import com.sinba.common.eav.dao.IAttributesDAO;
import com.sinba.common.eav.entity.Attribute;
import com.sinba.common.eav.service.EavCommService;
import com.sinba.common.exception.ApplicationException;
import com.sinba.common.file.excel.ExcelUtil;
import com.sinba.itsm.cim.dao.ICICategoryDAO;
import com.sinba.itsm.cim.dao.ICIDAO;
import com.sinba.itsm.cim.dao.ICiHardwareDAO;
import com.sinba.itsm.cim.dao.ICiSoftwareDAO;
import com.sinba.itsm.cim.dto.CIDTO;
import com.sinba.itsm.cim.dto.CIQueryDTO;
import com.sinba.itsm.cim.dto.CiHardwareDTO;
import com.sinba.itsm.cim.dto.CiSoftwareDTO;
import com.sinba.itsm.cim.entity.CI;
import com.sinba.itsm.cim.entity.CICategory;
import com.sinba.itsm.cim.entity.CiHardware;
import com.sinba.itsm.cim.entity.CiSoftware;
import com.sinba.itsm.cim.service.ICIService;
import java.io.InputStream;
import java.io.Serializable;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import java.util.Map;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.transaction.annotation.Transactional;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class CIService
implements ICIService {
    @Autowired
    private ICIDAO ciDAO;
    @Autowired
    private IAttributesDAO attributesDAO;
    @Autowired
    private IDataDictionaryItemsDAO dataDictionaryItemsDAO;
    @Autowired
    private ICICategoryDAO cicategoryDAO;
    @Autowired
    private IAttachmentDAO attachmentDAO;
    @Autowired
    private IAttachmentService attachmentService;
    @Autowired
    private ICiHardwareDAO ciHardwareDAO;
    @Autowired
    private ICiSoftwareDAO ciSoftwareDAO;
    @Autowired
    private EavCommService eavCommService;

    @Override
    public boolean configureItemExist(Long ciId) {
        boolean bool = false;
        CI ci = (CI)((Object)this.ciDAO.findById(ciId));
        if (ci != null) {
            bool = true;
        }
        return bool;
    }

    @Override
    public boolean configureItemExist(String ciNo) {
        CI ci = (CI)((Object)this.ciDAO.findUniqueBy("cino", ciNo));
        return ci != null;
    }

    public void findCICategorys(Long cno, List<Long> longList) {
        CICategory category = (CICategory)((Object)this.cicategoryDAO.findById(cno));
        longList.add(category.getCno());
        if (category != null && category.getChildren() != null && category.getChildren().size() > 0) {
            for (Category c : category.getChildren()) {
                longList.add(c.getCno());
                this.findCICategorys(c.getCno(), longList);
            }
        }
    }

    @Override
    @Transactional
    public PageDTO findPagerConfigureItem(CIQueryDTO ciQueryDTO, int start, int limit, String sidx, String sord) {
        if (ciQueryDTO != null && ciQueryDTO.getCategoryNo() != null) {
            ArrayList<Long> longList = new ArrayList<Long>();
            this.findCICategorys(ciQueryDTO.getCategoryNo(), longList);
            Long[] cnos = new Long[longList.size()];
            for (int i = 0; i < longList.size(); ++i) {
                cnos[i] = (Long)longList.get(i);
            }
            ciQueryDTO.setCategoryNos(cnos);
        }
        PageDTO page = this.ciDAO.findPager(ciQueryDTO, start, limit, sidx, sord);
        List entities = page.getData();
        ArrayList<CIDTO> dtos = new ArrayList<CIDTO>(entities.size());
        for (CI entity : entities) {
            CIDTO dto = new CIDTO();
            this.entity2dto(entity, dto);
            dtos.add(dto);
        }
        page.setData(dtos);
        return page;
    }

    @Transactional
    private void findPagerEntity2dto(CI ciEntity, CIDTO ciDto) {
        CIDTO.entity2dto((Object)((Object)ciEntity), (Object)((Object)ciDto));
        if (null != ciEntity.getBrand()) {
            ciDto.setBrandId(ciEntity.getBrand().getDcode());
            ciDto.setBrandName(ciEntity.getBrand().getDname());
        }
        if (null != ciEntity.getLoc()) {
            ciDto.setLocId(ciEntity.getLoc().getDcode());
            ciDto.setLoc(ciEntity.getLoc().getDname());
        }
        if (null != ciEntity.getProvider()) {
            ciDto.setProviderId(ciEntity.getProvider().getDcode());
            ciDto.setProviderName(ciEntity.getProvider().getDname());
        }
        if (null != ciEntity.getStatus()) {
            ciDto.setStatusId(ciEntity.getStatus().getDcode());
            ciDto.setStatus(ciEntity.getStatus().getDname());
        }
        if (null != ciEntity.getCategory()) {
            ciDto.setCategoryNo(ciEntity.getCategory().getCno());
            ciDto.setCategoryName(ciEntity.getCategory().getCname());
            if (ciEntity.getCategory().getCategoryType() != null && ciEntity.getCategory().getCategoryType() > 0L) {
                ciDto.setEavNo(ciEntity.getCategory().getCategoryType());
            }
        }
    }

    @Override
    @Transactional
    public CIDTO findConfigureItemById(Long ciId) {
        CI entity = (CI)((Object)this.ciDAO.findById(ciId));
        CIDTO dto = new CIDTO();
        List<Attachment> attrs = entity.getCiAttachements();
        if (attrs != null && attrs.size() > 0) {
            dto.setAttachments(attrs);
        }
        this.entity2dto(entity, dto);
        return dto;
    }

    @Override
    @Transactional
    public boolean deleteConfigureItem(Long[] ciIds) {
        boolean bool = true;
        this.ciDAO.deleteByIds(ciIds);
        return bool;
    }

    @Override
    @Transactional
    public void addConfigureItem(CIDTO ciDTO) {
        List attrs;
        CI entity = new CI();
        this.dto2entity(ciDTO, entity);
        entity.setStatus((DataDictionaryItems)this.dataDictionaryItemsDAO.findById((Serializable)ciDTO.getStatusId()));
        entity.setBrand((DataDictionaryItems)this.dataDictionaryItemsDAO.findById((Serializable)ciDTO.getBrandId()));
        entity.setLoc((DataDictionaryItems)this.dataDictionaryItemsDAO.findById((Serializable)ciDTO.getLocId()));
        entity.setProvider((DataDictionaryItems)this.dataDictionaryItemsDAO.findById((Serializable)ciDTO.getProviderId()));
        CICategory categoryNo = (CICategory)((Object)this.cicategoryDAO.findById(ciDTO.getCategoryNo()));
        entity.setCategory(categoryNo);
        for (String attrName : ciDTO.getAttrVals().keySet()) {
            Attribute attr = (Attribute)this.attributesDAO.findUniqueBy("attrName", (Object)attrName);
            String attrRawVal = ciDTO.getAttrVals().get(attrName);
            entity.getAttrVals().put(attr, this.eavCommService.getObjectByType(attr.getAttrType(), attr, attrRawVal));
        }
        if (ciDTO.getAttachmentStr() != null && (attrs = this.attachmentService.saveAttachment(ciDTO.getAttachmentStr())) != null) {
            entity.setCiAttachements(attrs);
        }
        this.ciDAO.save((Object)entity);
    }

    @Override
    @Transactional
    public void updateConfigureItem(CIDTO ciDTO) {
        CI entity = (CI)((Object)this.ciDAO.findById(ciDTO.getCiId()));
        this.dto2entity(ciDTO, entity);
        entity.setStatus((DataDictionaryItems)this.dataDictionaryItemsDAO.findById((Serializable)ciDTO.getStatusId()));
        entity.setBrand((DataDictionaryItems)this.dataDictionaryItemsDAO.findById((Serializable)ciDTO.getBrandId()));
        entity.setLoc((DataDictionaryItems)this.dataDictionaryItemsDAO.findById((Serializable)ciDTO.getLocId()));
        entity.setProvider((DataDictionaryItems)this.dataDictionaryItemsDAO.findById((Serializable)ciDTO.getProviderId()));
        Category categoryNo = (Category)this.cicategoryDAO.findById(ciDTO.getCategoryNo());
        entity.setCategory(categoryNo);
        for (String attrName : ciDTO.getAttrVals().keySet()) {
            Attribute attr = (Attribute)this.attributesDAO.findUniqueBy("attrName", (Object)attrName);
            String attrRawVal = ciDTO.getAttrVals().get(attrName);
            entity.getAttrVals().put(attr, this.eavCommService.getObjectByType(attr.getAttrType(), attr, attrRawVal));
        }
        if (ciDTO.getAttachmentStr() != null) {
            List attrs = this.attachmentService.saveAttachment(ciDTO.getAttachmentStr());
            entity.getCiAttachements().addAll(attrs);
        }
        this.ciDAO.merge((Object)entity);
    }

    @Override
    @Transactional
    public void deleteAttachement(Long ciId, Long aid) {
        CI ci = (CI)((Object)this.ciDAO.findById(ciId));
        Attachment at = (Attachment)this.attachmentDAO.findById((Serializable)aid);
        if (ci.getCiAttachements() != null && ci.getCiAttachements().contains(at)) {
            ci.getCiAttachements().remove(at);
        }
        this.ciDAO.merge((Object)ci);
    }

    private void dto2entity(CIDTO dto, CI entity) {
        try {
            if (dto != null) {
                entity.setCiId(dto.getCiId());
                entity.setCino(dto.getCino());
                entity.setCiname(dto.getCiname());
                entity.setModel(dto.getModel());
                entity.setLifeCycle(dto.getLifeCycle());
                entity.setSerialNumber(dto.getSerialNumber());
                entity.setBarcode(dto.getBarcode());
                entity.setBuyDate(dto.getBuyDate());
                entity.setArrivalDate(dto.getArrivalDate());
                entity.setPoNo(dto.getPoNo());
                entity.setWarningDate(dto.getWarningDate());
                entity.setWarranty(dto.getWarranty());
                entity.setUserName(dto.getUserName());
                entity.setOwner(dto.getOwner());
            }
        }
        catch (Exception ex) {
            throw new ApplicationException(ex);
        }
    }

    @Transactional
    private void entity2dto(CI ciEntity, CIDTO ciDto) {
        CIDTO.entity2dto((Object)((Object)ciEntity), (Object)((Object)ciDto));
        if (null != ciEntity.getBrand()) {
            ciDto.setBrandId(ciEntity.getBrand().getDcode());
            ciDto.setBrandName(ciEntity.getBrand().getDname());
        }
        if (null != ciEntity.getLoc()) {
            ciDto.setLocId(ciEntity.getLoc().getDcode());
            ciDto.setLoc(ciEntity.getLoc().getDname());
        }
        if (null != ciEntity.getProvider()) {
            ciDto.setProviderId(ciEntity.getProvider().getDcode());
            ciDto.setProviderName(ciEntity.getProvider().getDname());
        }
        if (null != ciEntity.getStatus()) {
            ciDto.setStatusId(ciEntity.getStatus().getDcode());
            ciDto.setStatus(ciEntity.getStatus().getDname());
        }
        if (null != ciEntity.getCategory()) {
            ciDto.setCategoryNo(ciEntity.getCategory().getCno());
            ciDto.setCategoryName(ciEntity.getCategory().getCname());
            if (ciEntity.getCategory().getCategoryType() != null && ciEntity.getCategory().getCategoryType() > 0L) {
                ciDto.setEavNo(ciEntity.getCategory().getCategoryType());
            }
        }
        if (ciEntity.getAttrVals() != null) {
            Map attributeVals = this.eavCommService.attributeValue2String(ciEntity.getAttrVals());
            ciDto.setAttrVals(attributeVals);
        }
    }

    @Override
    @Transactional
    public void saveCiConfigInfo(Long ciId, CiHardwareDTO hardwareDTO, CiSoftwareDTO softwareDTO) {
        CI ci = (CI)((Object)this.ciDAO.findById(ciId));
        CiHardware hardware = new CiHardware();
        if (ci.getCiHardware() != null) {
            hardware = ci.getCiHardware();
            this.dto2entityExceptNull(hardwareDTO, hardware);
            this.ciHardwareDAO.merge((Object)hardware);
        } else {
            CiHardwareDTO.dto2entity((Object)((Object)hardwareDTO), (Object)((Object)hardware));
            this.ciHardwareDAO.save((Object)hardware);
        }
        this.saveSoftware(ciId, softwareDTO);
        ci.setCiHardware(hardware);
        this.ciDAO.merge((Object)ci);
    }

    public void dto2entityExceptNull(CiHardwareDTO hardwareDTO, CiHardware hardware) {
        if (hardwareDTO.getCdDrive() != null) {
            hardware.setCdDrive(hardwareDTO.getCdDrive());
        }
        if (hardware.getComputerName() != null) {
            hardware.setComputerName(hardwareDTO.getComputerName());
        }
        if (hardware.getCpu() != null) {
            hardware.setCpu(hardwareDTO.getCpu());
        }
        if (hardware.getCpuGrade() != null) {
            hardware.setCpuGrade(hardwareDTO.getCpuGrade());
        }
        if (hardware.getCpuSpeed() != null) {
            hardware.setCpuSpeed(hardwareDTO.getCpuSpeed());
        }
        if (hardware.getDesktopMonitor() != null) {
            hardware.setDesktopMonitor(hardwareDTO.getDesktopMonitor());
        }
        if (hardware.getHardDriveModel() != null) {
            hardware.setHardDriveModel(hardwareDTO.getHardDriveModel());
        }
        if (hardware.getHardDriveSize() != null) {
            hardware.setHardDriveSize(hardwareDTO.getHardDriveSize());
        }
        if (hardware.getLastLogin() != null) {
            hardware.setLastLogin(hardwareDTO.getLastLogin());
        }
        if (hardware.getMainboard() != null) {
            hardware.setMainboard(hardwareDTO.getMainboard());
        }
        if (hardware.getMemorySize() != null) {
            hardware.setMemorySize(hardwareDTO.getMemorySize());
        }
        if (hardware.getMonitor() != null) {
            hardware.setMonitor(hardwareDTO.getMonitor());
        }
        if (hardware.getNetworkAdapter() != null) {
            hardware.setNetworkAdapter(hardwareDTO.getNetworkAdapter());
        }
        if (hardware.getSerialNumber() != null) {
            hardware.setSerialNumber(hardwareDTO.getSerialNumber());
        }
        if (hardware.getSystemName() != null) {
            hardware.setSystemName(hardwareDTO.getSystemName());
        }
        if (hardware.getSystemVersion() != null) {
            hardware.setSystemVersion(hardwareDTO.getSystemVersion());
        }
        if (hardware.getNetworkDescription() != null) {
            hardware.setNetworkDescription(hardwareDTO.getNetworkDescription());
        }
        if (hardware.getNetworkIpAddress() != null) {
            hardware.setNetworkIpAddress(hardwareDTO.getNetworkIpAddress());
        }
        if (hardware.getNetworkMacAddress() != null) {
            hardware.setNetworkMacAddress(hardwareDTO.getNetworkMacAddress());
        }
    }

    @Transactional
    public void saveSoftware(Long ciId, CiSoftwareDTO softwareDTO) {
        CI ci = (CI)((Object)this.ciDAO.findById(ciId));
        ArrayList<CiSoftware> softwares = new ArrayList<CiSoftware>();
        if (softwareDTO.getSoftwareStr() != null) {
            String softwareStr = softwareDTO.getSoftwareStr();
            String[] attrArr = softwareStr.split("<>");
            for (int i = 0; i < attrArr.length; ++i) {
                String[] attrArrs;
                String str = attrArr[i];
                if (str == null || str.equals("") || (attrArrs = str.split("==")) == null) continue;
                CiSoftware software = new CiSoftware();
                software.setSoftwareName(attrArrs[0]);
                software.setInstallDate(attrArrs[1]);
                if (str == null) continue;
                this.ciSoftwareDAO.save(software);
                softwares.add(software);
            }
        }
        ci.setCiSoftwares(softwares);
        this.ciDAO.merge((Object)ci);
    }

    @Override
    @Transactional
    public void saveHardware(CiHardwareDTO hardwareDTO) {
        CI ci = (CI)((Object)this.ciDAO.findById(hardwareDTO.getCiId()));
        CiHardware hardware = new CiHardware();
        if (ci.getCiHardware() != null) {
            hardware = ci.getCiHardware();
            CiHardwareDTO.dto2entity((Object)((Object)hardwareDTO), (Object)((Object)hardware));
            this.ciHardwareDAO.merge((Object)hardware);
        } else {
            CiHardwareDTO.dto2entity((Object)((Object)hardwareDTO), (Object)((Object)hardware));
            this.ciHardwareDAO.save((Object)hardware);
        }
        ci.setCiHardware(hardware);
        this.ciDAO.merge((Object)ci);
    }

    public void dto2entity(CiHardwareDTO dto, CiHardware ciHard) {
        ciHard.setCdDrive(dto.getCdDrive());
        ciHard.setCiHardwareId(dto.getCiHardwareId());
        ciHard.setComputerName(dto.getComputerName());
        ciHard.setCpu(dto.getCpu());
        ciHard.setCpuGrade(dto.getCpuGrade());
        ciHard.setCpuSpeed(dto.getCpuSpeed());
        ciHard.setDesktopMonitor(dto.getDesktopMonitor());
        ciHard.setHardDriveModel(dto.getHardDriveModel());
        ciHard.setHardDriveSize(dto.getHardDriveSize());
        ciHard.setLastLogin(dto.getLastLogin());
        ciHard.setMainboard(dto.getMainboard());
        ciHard.setMemorySize(dto.getMemorySize());
        ciHard.setMonitor(dto.getMonitor());
        ciHard.setNetworkAdapter(dto.getNetworkAdapter());
        ciHard.setNetworkDescription(dto.getNetworkDescription());
        ciHard.setNetworkIpAddress(dto.getNetworkIpAddress());
        ciHard.setNetworkMacAddress(dto.getNetworkMacAddress());
        ciHard.setSerialNumber(dto.getSerialNumber());
        ciHard.setSystemName(dto.getSystemName());
        ciHard.setSystemVersion(dto.getSystemVersion());
    }

    @Override
    @Transactional
    public CiHardwareDTO getCiHardware(Long ciId) {
        CI ci = (CI)((Object)this.ciDAO.findById(ciId));
        CiHardwareDTO hardwareDTO = new CiHardwareDTO();
        if (ci.getCiHardware() != null) {
            CiHardwareDTO.entity2dto((Object)((Object)ci.getCiHardware()), (Object)((Object)hardwareDTO));
        }
        return hardwareDTO;
    }

    @Override
    @Transactional
    public PageDTO getCiSoftware(Long ciId, int page, int limit) {
        CI ci = (CI)((Object)this.ciDAO.findById(ciId));
        PageDTO pages = new PageDTO();
        if (ci.getCiSoftwares() != null && ci.getCiSoftwares().size() > 0) {
            int totalSize = ci.getCiSoftwares().size();
            int start = (page - 1) * limit;
            int end = 0;
            if (totalSize < limit) {
                end = totalSize - 1;
            } else {
                end = limit * page - 1;
                if (end > totalSize) {
                    end = totalSize - 1;
                }
            }
            ArrayList<CiSoftwareDTO> softwares = new ArrayList<CiSoftwareDTO>();
            for (int i = start; i <= end; ++i) {
                CiSoftwareDTO dto = new CiSoftwareDTO();
                CiSoftwareDTO.entity2dto((Object)ci.getCiSoftwares().get(i), (Object)((Object)dto));
                softwares.add(dto);
            }
            pages.setData(softwares);
            pages.setTotalSize(totalSize);
        }
        return pages;
    }

    @Override
    @Transactional
    public InputStream exportConfigureItems(CIQueryDTO ciQueryDTO, int start, int limit, String sidx, String sord) {
        PageDTO p;
        String sheetName = "\u914d\u7f6e\u9879";
        String[] colNames = new String[]{"\u5206\u7c7b", "\u7f16\u53f7", "\u540d\u79f0", "\u4ea7\u54c1\u578b\u53f7", "\u5e8f\u5217\u53f7", "\u72b6\u6001", "\u4f7f\u7528\u4eba", "\u4f4d\u7f6e", "\u8d2d\u4e70\u65e5\u671f", "\u5230\u8d27\u65e5\u671f", "\u9884\u8b66\u65e5\u671f", "\u751f\u547d\u5468\u671f\uff08\u6708\uff09", "\u4fdd\u4fee\u671f\uff08\u6708\uff09", "\u62e5\u6709\u8005", "\u91c7\u8d2d\u5355\u53f7", "\u54c1\u724c", "\u4f9b\u5e94\u5546", "\u6761\u5f62\u7801", " ", "\u8ba1\u7b97\u673a\u540d", "\u7528\u6237\u8d26\u53f7", "\u5e8f\u5217\u53f7", "\u64cd\u4f5c\u7cfb\u7edf", "\u7cfb\u7edf\u7248\u672c", "\u4e3b\u677f\u5236\u9020\u5546", "CPU", "\u5185\u5b58\u5927\u5c0f(MB)", "\u786c\u76d8\u9a71\u52a8", "\u786c\u76d8\u5bb9\u91cf(MB)", "\u5149\u76d8\u9a71\u52a8\u5668", "\u7f51\u7edc\u9002\u914d\u5668", "\u663e\u793a\u5361", "\u76d1\u89c6\u5668\u7c7b\u578b", "\u63cf\u8ff0", "IP\u5730\u5740", "MAC", "\u5907\u6ce8"};
        ArrayList<String[]> data = new ArrayList<String[]>();
        if (ciQueryDTO != null && ciQueryDTO.getCategoryNo() != null) {
            ArrayList<Long> longList = new ArrayList<Long>();
            this.findCICategorys(ciQueryDTO.getCategoryNo(), longList);
            Long[] cnos = new Long[longList.size()];
            for (int i = 0; i < longList.size(); ++i) {
                cnos[i] = (Long)longList.get(i);
            }
            ciQueryDTO.setCategoryNos(cnos);
        }
        if ((p = this.ciDAO.findPager(ciQueryDTO, start, limit, sidx, sord)) != null && p.getData() != null && p.getData().size() > 0) {
            List entities = p.getData();
            for (CI item : entities) {
                this.convertChangeToStringArray(item, data);
            }
            try {
                return ExcelUtil.createSheetExcel((String)sheetName, (String[])colNames, data);
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
        return ExcelUtil.createSheetExcel((String)sheetName, (String[])colNames, data);
    }

    public void convertChangeToStringArray(CI item, List<String[]> data) {
        CIDTO dto = new CIDTO();
        this.entity2dto(item, dto);
        String buyDate = "";
        String arrivalDate = "";
        String warningDate = "";
        String lifeCycle = "";
        String warranty = "";
        CiHardware chw = null;
        if (item.getBuyDate() != null) {
            buyDate = CIService.DateToStr(dto.getBuyDate());
        }
        if (item.getArrivalDate() != null) {
            arrivalDate = CIService.DateToStr(dto.getArrivalDate());
        }
        if (item.getWarningDate() != null) {
            warningDate = CIService.DateToStr(dto.getWarningDate());
        }
        if (item.getLifeCycle() != null) {
            lifeCycle = String.valueOf(dto.getLifeCycle());
        }
        if (item.getWarranty() != null) {
            warranty = String.valueOf(item.getWarranty());
        }
        if (item.getCiHardware() != null) {
            chw = item.getCiHardware();
            data.add(new String[]{dto.getCategoryName(), dto.getCino(), dto.getCiname(), dto.getModel(), dto.getSerialNumber(), dto.getStatus(), dto.getUserName(), dto.getLoc(), buyDate, arrivalDate, warningDate, lifeCycle, warranty, dto.getOwner(), dto.getPoNo(), dto.getBrandName(), dto.getProviderName(), dto.getBarcode(), " ", chw.getComputerName(), chw.getLastLogin(), chw.getSerialNumber(), chw.getSystemName(), chw.getSystemVersion(), chw.getMainboard(), chw.getCpu(), chw.getMemorySize(), chw.getHardDriveModel(), chw.getHardDriveSize(), chw.getCdDrive(), chw.getNetworkAdapter(), chw.getDesktopMonitor(), chw.getMonitor(), chw.getNetworkDescription(), chw.getNetworkIpAddress(), chw.getNetworkMacAddress(), chw.getRemark()});
        } else {
            data.add(new String[]{dto.getCategoryName(), dto.getCino(), dto.getCiname(), dto.getModel(), dto.getSerialNumber(), dto.getStatus(), dto.getUserName(), dto.getLoc(), buyDate, arrivalDate, warningDate, lifeCycle, warranty, dto.getOwner(), dto.getPoNo(), dto.getBrandName(), dto.getProviderName(), dto.getBarcode(), " ", " ", " ", " ", " ", " ", " ", " ", " ", " ", " ", " ", " ", " ", " ", " ", " ", " ", " "});
        }
    }

    public static String DateToStr(Date date) {
        SimpleDateFormat format = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
        String str = format.format(date);
        return str;
    }
}

