/*
 * Decompiled with CFR 0.152.
 */
package com.sinba.itsm.snmp.dao;

import com.sinba.common.dao.BaseDAOImplHibernate;
import com.sinba.itsm.snmp.dao.ILansIpDAO;
import com.sinba.itsm.snmp.dto.LansIpDTO;
import com.sinba.itsm.snmp.entity.LansIp;
import java.net.InetAddress;
import java.util.ArrayList;
import java.util.List;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class LansIpDAO
extends BaseDAOImplHibernate<LansIp>
implements ILansIpDAO {
    @Override
    public boolean ipExist(String ip) {
        return this.findUniqueBy("ipAddress", ip) != null;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    public List<LansIpDTO> scanLansIp() {
        ArrayList<LansIpDTO> lists = new ArrayList<LansIpDTO>();
        try {
            int i;
            InetAddress addr = InetAddress.getLocalHost();
            byte[] addrs = addr.getAddress();
            for (i = 0; i < addrs.length; ++i) {
            }
            if ((addrs[0] & 0x80) == 0 || (addrs[0] & 0xC0) == 128) return lists;
            if ((addrs[0] & 0xE0) == 192) {
                addrs[3] = 1;
                for (i = 0; i < 20; ++i) {
                    InetAddress n = InetAddress.getByAddress(addrs);
                    LansIpDTO lanIp = new LansIpDTO();
                    if (n.isReachable(1200)) {
                        String result = n.toString();
                        lanIp.setIpAddress(result.replaceAll("/", ""));
                        lanIp.setHostName(n.getHostName());
                        if (!this.ipExist(result.replaceAll("/", ""))) {
                            LansIpDTO dto = new LansIpDTO();
                            dto.setHostName(n.getHostName());
                            dto.setIpAddress(result.replaceAll("/", ""));
                            LansIp lansIp2 = new LansIp();
                            LansIpDTO.dto2entity((Object)((Object)dto), (Object)((Object)lansIp2));
                            this.save((Object)lansIp2);
                        }
                        lists.add(lanIp);
                    }
                    addrs[3] = (byte)(addrs[3] + 1);
                }
                return lists;
            }
            if ((addrs[0] & 0xF0) != 224 && (addrs[0] & 0xF8) != 240) return lists;
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return lists;
    }
}

