/*
 * Decompiled with CFR 0.152.
 */
package com.sinba.itsm.snmp.dao;

import com.sinba.common.dao.BaseDAOImplHibernate;
import com.sinba.itsm.snmp.dao.ISnmpDAO;
import com.sinba.itsm.snmp.dto.MibDTO;
import com.sinba.itsm.snmp.entity.LansIp;
import java.io.IOException;
import java.io.UnsupportedEncodingException;
import java.net.UnknownHostException;
import java.util.ArrayList;
import java.util.List;
import java.util.Vector;
import org.snmp4j.CommandResponder;
import org.snmp4j.CommandResponderEvent;
import org.snmp4j.CommunityTarget;
import org.snmp4j.MessageDispatcher;
import org.snmp4j.MessageDispatcherImpl;
import org.snmp4j.PDU;
import org.snmp4j.Snmp;
import org.snmp4j.Target;
import org.snmp4j.TransportMapping;
import org.snmp4j.event.ResponseEvent;
import org.snmp4j.mp.MPv1;
import org.snmp4j.mp.MPv2c;
import org.snmp4j.mp.MPv3;
import org.snmp4j.mp.MessageProcessingModel;
import org.snmp4j.security.SecurityModel;
import org.snmp4j.security.SecurityModels;
import org.snmp4j.security.SecurityProtocols;
import org.snmp4j.security.USM;
import org.snmp4j.smi.Address;
import org.snmp4j.smi.GenericAddress;
import org.snmp4j.smi.OID;
import org.snmp4j.smi.OctetString;
import org.snmp4j.smi.TcpAddress;
import org.snmp4j.smi.UdpAddress;
import org.snmp4j.smi.Variable;
import org.snmp4j.smi.VariableBinding;
import org.snmp4j.transport.DefaultTcpTransportMapping;
import org.snmp4j.transport.DefaultUdpTransportMapping;
import org.snmp4j.util.MultiThreadedMessageDispatcher;
import org.snmp4j.util.ThreadPool;
import org.snmp4j.util.WorkerPool;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SnmpDAO
extends BaseDAOImplHibernate<LansIp>
implements ISnmpDAO,
CommandResponder {
    private Snmp snmp = null;
    private Address targetAddress = null;
    private MultiThreadedMessageDispatcher dispatcher;
    private ThreadPool threadPool;

    @Override
    public boolean connTest(String ip) {
        boolean testResult = true;
        try {
            this.targetAddress = GenericAddress.parse((String)("udp:" + ip + "/161"));
            DefaultUdpTransportMapping transport = new DefaultUdpTransportMapping();
            this.snmp = new Snmp((TransportMapping)transport);
            transport.listen();
            CommunityTarget target = new CommunityTarget();
            target.setCommunity(new OctetString("public"));
            target.setAddress(this.targetAddress);
            target.setRetries(2);
            target.setTimeout(1500L);
            target.setVersion(1);
            PDU pdu = new PDU();
            pdu.add(new VariableBinding(new OID("0.0")));
            pdu.setType(-95);
            ResponseEvent respEvnt = this.snmp.send(pdu, (Target)target);
            if (respEvnt == null || respEvnt.getResponse() == null) {
                testResult = false;
            }
        }
        catch (Exception e) {
            testResult = false;
            e.printStackTrace();
        }
        return testResult;
    }

    @Override
    public void initComm(String ip) {
        try {
            this.targetAddress = GenericAddress.parse((String)("udp:" + ip + "/161"));
            DefaultUdpTransportMapping transport = new DefaultUdpTransportMapping();
            this.snmp = new Snmp((TransportMapping)transport);
            transport.listen();
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    @Override
    public String[] sendPDU(String reqOid) {
        CommunityTarget target = new CommunityTarget();
        target.setCommunity(new OctetString("public"));
        target.setAddress(this.targetAddress);
        target.setRetries(2);
        target.setTimeout(1500L);
        target.setVersion(1);
        PDU pdu = new PDU();
        pdu.add(new VariableBinding(new OID(reqOid)));
        pdu.setType(-95);
        String[] outinfo = new String[]{"", ""};
        try {
            Vector recVBs;
            ResponseEvent respEvnt = this.snmp.send(pdu, (Target)target);
            if (respEvnt != null && respEvnt.getResponse() != null && (recVBs = respEvnt.getResponse().getVariableBindings()).size() > 0) {
                VariableBinding recVB = (VariableBinding)recVBs.elementAt(0);
                System.out.println(recVB.getOid() + " : " + recVB.getVariable());
                outinfo[0] = recVB.getOid().toString();
                outinfo[1] = recVB.getVariable().toString();
            }
        }
        catch (Exception e) {
            // empty catch block
        }
        return outinfo;
    }

    @Override
    public String getAll() {
        CommunityTarget target = new CommunityTarget();
        target.setCommunity(new OctetString("public"));
        target.setAddress(this.targetAddress);
        target.setRetries(2);
        target.setTimeout(1500L);
        target.setVersion(0);
        PDU pdu = new PDU();
        pdu.setType(-95);
        String stroid = "0.0";
        String snmpvalue = "";
        int j = 0;
        String all = "";
        System.out.println();
        int eofmib = 0;
        try {
            while (eofmib != 5) {
                ++j;
                pdu.clear();
                pdu.add(new VariableBinding(new OID(stroid)));
                ResponseEvent respEvnt = this.snmp.send(pdu, (Target)target);
                stroid = "oid:";
                if (respEvnt != null && respEvnt.getResponse() != null) {
                    Vector recVBs = respEvnt.getResponse().getVariableBindings();
                    if (recVBs.size() <= 0) continue;
                    VariableBinding recVB = (VariableBinding)recVBs.elementAt(0);
                    stroid = recVB.getOid().toString();
                    snmpvalue = recVB.getVariable().toString();
                    eofmib = recVB.getSyntax();
                    if (eofmib == 5) continue;
                    all = all + stroid + "\n";
                    all = all + snmpvalue + "\n";
                    System.out.println(all);
                    continue;
                }
                all = "\u5c1a\u672a\u5b89\u88c5snmp\u534f\u8bae";
                return all;
            }
        }
        catch (Exception e) {
            // empty catch block
        }
        return all;
    }

    @Override
    public String getSnmpAll(String ip) {
        String name = ip;
        String all = "";
        try {
            this.initComm(name);
            all = this.getAll();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return all;
    }

    @Override
    public String[] getValue(String ip) {
        String name = ip;
        String[] snmpinfo = new String[]{"0.0", ""};
        int ii = 0;
        String[] returnValue = new String[50];
        try {
            do {
                this.initComm(name);
                snmpinfo = this.sendPDU(snmpinfo[0]);
                returnValue[ii] = snmpinfo[1];
            } while (++ii < 50);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return returnValue;
    }

    @Override
    public List<MibDTO> getPartMIB(String stroids, int oidindex, boolean ifChangeCN) {
        CommunityTarget target = new CommunityTarget();
        target.setCommunity(new OctetString("public"));
        target.setAddress(this.targetAddress);
        target.setRetries(2);
        target.setTimeout(1500L);
        target.setVersion(1);
        PDU pdu = new PDU();
        pdu.setType(-95);
        String stroid = stroids;
        int i = 0;
        Boolean iscomplete = false;
        ArrayList<MibDTO> outmib = new ArrayList<MibDTO>();
        try {
            String[] arrind = stroids.split("\\.");
            String strind = arrind[--oidindex];
            while (!iscomplete.booleanValue()) {
                pdu.clear();
                pdu.add(new VariableBinding(new OID(stroid)));
                ResponseEvent respEvnt = this.snmp.send(pdu, (Target)target);
                if (respEvnt != null && respEvnt.getResponse() != null) {
                    Vector recVBs = respEvnt.getResponse().getVariableBindings();
                    if (recVBs.size() <= 0) continue;
                    VariableBinding recVB = (VariableBinding)recVBs.elementAt(0);
                    String[] strtemp = recVB.getOid().toString().split("\\.");
                    if (recVB.getSyntax() != 5 && strtemp[oidindex].equals(strind)) {
                        MibDTO mib = new MibDTO();
                        if (ifChangeCN) {
                            if (recVB.getVariable().getSyntaxString().equals("OCTET STRING")) {
                                if (recVB.getVariable().toString().indexOf(":") > -1) {
                                    mib.setDesc(this.exchange(recVB.getVariable().toString()));
                                    mib.setOid(recVB.getOid().toString());
                                } else {
                                    mib.setDesc(recVB.getVariable().toString());
                                    mib.setOid(recVB.getOid().toString());
                                }
                            }
                        } else {
                            mib.setDesc(recVB.getVariable().toString());
                            mib.setOid(recVB.getOid().toString());
                        }
                        outmib.add(mib);
                        ++i;
                        stroid = recVB.getOid().toString();
                        continue;
                    }
                    iscomplete = true;
                    continue;
                }
                iscomplete = true;
            }
        }
        catch (Exception e) {
            outmib = null;
            e.printStackTrace();
        }
        return outmib;
    }

    @Override
    public List<MibDTO> getPartMIB1(String stroids, String endoids, boolean ifChangeCN) {
        CommunityTarget target = new CommunityTarget();
        target.setCommunity(new OctetString("public"));
        target.setAddress(this.targetAddress);
        target.setRetries(2);
        target.setTimeout(1500L);
        target.setVersion(1);
        PDU pdu = new PDU();
        pdu.setType(-95);
        String stroid = stroids;
        int i = 0;
        Boolean iscomplete = false;
        ArrayList<MibDTO> outmib = new ArrayList<MibDTO>();
        try {
            String[] arrind = stroids.split("\\.");
            String strind = endoids;
            while (!iscomplete.booleanValue()) {
                pdu.clear();
                pdu.add(new VariableBinding(new OID(stroid)));
                ResponseEvent respEvnt = this.snmp.send(pdu, (Target)target);
                if (respEvnt != null && respEvnt.getResponse() != null) {
                    Vector recVBs = respEvnt.getResponse().getVariableBindings();
                    if (recVBs.size() <= 0) continue;
                    VariableBinding recVB = (VariableBinding)recVBs.elementAt(0);
                    String strtemp = recVB.getOid().toString();
                    if (recVB.getSyntax() != 5 && !stroid.equals(strind)) {
                        MibDTO mib = new MibDTO();
                        if (ifChangeCN) {
                            if (recVB.getVariable().toString().indexOf(":") > -1) {
                                mib.setDesc(this.exchange(recVB.getVariable().toString()));
                                mib.setOid(recVB.getOid().toString());
                            } else {
                                mib.setDesc(recVB.getVariable().toString());
                                mib.setOid(recVB.getOid().toString());
                            }
                        } else {
                            mib.setDesc(recVB.getVariable().toString());
                            mib.setOid(recVB.getOid().toString());
                        }
                        outmib.add(mib);
                        ++i;
                        stroid = recVB.getOid().toString();
                        continue;
                    }
                    iscomplete = true;
                    continue;
                }
                iscomplete = true;
            }
        }
        catch (Exception e) {
            outmib = null;
        }
        return outmib;
    }

    @Override
    public List<MibDTO> getPartMIB2(String stroids, int endindex, boolean ifChangeCN) {
        CommunityTarget target = new CommunityTarget();
        target.setCommunity(new OctetString("public"));
        target.setAddress(this.targetAddress);
        target.setRetries(2);
        target.setTimeout(1500L);
        target.setVersion(1);
        PDU pdu = new PDU();
        pdu.setType(-95);
        String stroid = stroids;
        int i = 0;
        Boolean iscomplete = false;
        ArrayList<MibDTO> outmib = new ArrayList<MibDTO>();
        try {
            while (!iscomplete.booleanValue()) {
                pdu.clear();
                pdu.add(new VariableBinding(new OID(stroid)));
                ResponseEvent respEvnt = this.snmp.send(pdu, (Target)target);
                if (respEvnt != null && respEvnt.getResponse() != null) {
                    Vector recVBs = respEvnt.getResponse().getVariableBindings();
                    if (recVBs.size() <= 0) continue;
                    VariableBinding recVB = (VariableBinding)recVBs.elementAt(0);
                    String strtemp = recVB.getOid().toString();
                    if (recVB.getSyntax() != 5 && i > endindex) {
                        MibDTO mib = new MibDTO();
                        if (ifChangeCN) {
                            if (recVB.getVariable().toString().indexOf(":") > -1) {
                                mib.setDesc(this.exchange(recVB.getVariable().toString()));
                                mib.setOid(recVB.getOid().toString());
                            } else {
                                mib.setDesc(recVB.getVariable().toString());
                                mib.setOid(recVB.getOid().toString());
                            }
                        } else {
                            mib.setDesc(recVB.getVariable().toString());
                            mib.setOid(recVB.getOid().toString());
                        }
                        outmib.add(mib);
                        ++i;
                        stroid = recVB.getOid().toString();
                        continue;
                    }
                    iscomplete = true;
                    continue;
                }
                iscomplete = true;
            }
        }
        catch (Exception e) {
            outmib = null;
        }
        return outmib;
    }

    @Override
    public String exchange(String input) {
        String result;
        if (!"".equals(input)) {
            StringBuffer sb = new StringBuffer();
            String hexs = input;
            String[] sa = hexs.indexOf(":") > -1 ? hexs.split(":") : null;
            if (sa != null && sa.length > 3) {
                for (String s : sa) {
                    char c = (char)Integer.parseInt(s, 16);
                    sb.append(c);
                }
                result = sb.toString();
                try {
                    result = new String(result.getBytes("ISO-8859-1"), "GBK");
                }
                catch (UnsupportedEncodingException e) {
                    e.printStackTrace();
                }
            } else {
                result = input;
            }
        } else {
            result = input;
        }
        return result;
    }

    @Override
    public List<MibDTO> getMIBinstall(String ip, String stroids, int oidindex, boolean ifChangeCN) {
        this.initComm(ip);
        List<MibDTO> arrmibho = null;
        ArrayList<MibDTO> mibLists = new ArrayList<MibDTO>();
        try {
            arrmibho = this.getPartMIB(stroids, oidindex, ifChangeCN);
            if (arrmibho != null) {
                int each = arrmibho.size() / 5;
                for (int i = 0; i < arrmibho.size(); ++i) {
                    MibDTO mibdtos = new MibDTO();
                    if (i >= each && i < each * 2) {
                        mibdtos.setDesc(this.exchange(arrmibho.get(i).getDesc()));
                        mibdtos.setOid(arrmibho.get(i).getOid());
                    } else {
                        mibdtos.setDesc(arrmibho.get(i).getDesc());
                        mibdtos.setOid(arrmibho.get(i).getOid());
                    }
                    mibLists.add(mibdtos);
                }
            }
        }
        catch (Exception e) {
            e.printStackTrace();
            mibLists = null;
        }
        return mibLists;
    }

    @Override
    public List<MibDTO> getMIBproc(String ip, String stroids, int oidindex, boolean ifChangeCN) {
        this.initComm(ip);
        List<MibDTO> arrmibho = null;
        ArrayList<MibDTO> mibLists = new ArrayList<MibDTO>();
        try {
            arrmibho = this.getPartMIB(stroids, oidindex, ifChangeCN);
            if (arrmibho != null) {
                int each = arrmibho.size() / 9;
                for (int i = 0; i < arrmibho.size(); ++i) {
                    MibDTO mibdtos = new MibDTO();
                    if (i >= each && i < each * 2) {
                        mibdtos.setDesc(this.exchange(arrmibho.get(i).getDesc()));
                        mibdtos.setOid(arrmibho.get(i).getOid());
                    } else if (i >= each * 3 && i < each * 4) {
                        mibdtos.setDesc(this.exchange(arrmibho.get(i).getDesc()));
                        mibdtos.setOid(arrmibho.get(i).getOid());
                    } else {
                        mibdtos.setDesc(arrmibho.get(i).getDesc());
                        mibdtos.setOid(arrmibho.get(i).getOid());
                    }
                    mibLists.add(mibdtos);
                }
            }
        }
        catch (Exception e) {
            e.printStackTrace();
            mibLists = null;
        }
        return mibLists;
    }

    @Override
    public List<MibDTO> getMIBstorage(String ip, String stroids, int oidindex, boolean ifChangeCN) {
        this.initComm(ip);
        List<MibDTO> arrmibho = null;
        ArrayList<MibDTO> mibLists = new ArrayList<MibDTO>();
        try {
            arrmibho = this.getPartMIB(stroids, oidindex, ifChangeCN);
            if (arrmibho != null) {
                int each = arrmibho.size() / 7;
                for (int i = 0; i < arrmibho.size(); ++i) {
                    MibDTO mibdtos = new MibDTO();
                    if (i >= each * 2 && i < each * 3) {
                        mibdtos.setDesc(this.exchange(arrmibho.get(i).getDesc()));
                        mibdtos.setOid(arrmibho.get(i).getOid());
                    } else {
                        if (i < each * 4 || i < each * 6) {
                            // empty if block
                        }
                        mibdtos.setDesc(arrmibho.get(i).getDesc());
                        mibdtos.setOid(arrmibho.get(i).getOid());
                    }
                    mibLists.add(mibdtos);
                }
            }
        }
        catch (Exception e) {
            e.printStackTrace();
            mibLists = null;
        }
        return mibLists;
    }

    @Override
    public List<MibDTO> getMIBinterfaces(String ip, String stroids, int oidindex, boolean ifChangeCN) {
        this.initComm(ip);
        List<MibDTO> arrmibho = null;
        ArrayList<MibDTO> mibLists = new ArrayList<MibDTO>();
        try {
            arrmibho = this.getPartMIB(stroids, oidindex, ifChangeCN);
            if (arrmibho != null) {
                int each = arrmibho.size() / 22;
                for (int i = 0; i < arrmibho.size(); ++i) {
                    MibDTO mibdtos = new MibDTO();
                    if (i >= each && i < each * 2) {
                        mibdtos.setDesc(this.exchange(arrmibho.get(i).getDesc()));
                        mibdtos.setOid(arrmibho.get(i).getOid());
                    } else {
                        mibdtos.setDesc(arrmibho.get(i).getDesc());
                        mibdtos.setOid(arrmibho.get(i).getOid());
                    }
                    mibLists.add(mibdtos);
                }
            }
        }
        catch (Exception e) {
            e.printStackTrace();
            mibLists = null;
        }
        return mibLists;
    }

    private void init() throws UnknownHostException, IOException {
        this.threadPool = ThreadPool.create((String)"Trap", (int)2);
        this.dispatcher = new MultiThreadedMessageDispatcher((WorkerPool)this.threadPool, (MessageDispatcher)new MessageDispatcherImpl());
        this.targetAddress = GenericAddress.parse((String)System.getProperty("snmp4j.listenAddress", "udp:192.168.1.112/162"));
        Object transport = this.targetAddress instanceof UdpAddress ? new DefaultUdpTransportMapping((UdpAddress)this.targetAddress) : new DefaultTcpTransportMapping((TcpAddress)this.targetAddress);
        this.snmp = new Snmp((MessageDispatcher)this.dispatcher, (TransportMapping)transport);
        this.snmp.getMessageDispatcher().addMessageProcessingModel((MessageProcessingModel)new MPv1());
        this.snmp.getMessageDispatcher().addMessageProcessingModel((MessageProcessingModel)new MPv2c());
        this.snmp.getMessageDispatcher().addMessageProcessingModel((MessageProcessingModel)new MPv3());
        USM usm = new USM(SecurityProtocols.getInstance(), new OctetString(MPv3.createLocalEngineID()), 0);
        SecurityModels.getInstance().addSecurityModel((SecurityModel)usm);
        this.snmp.listen();
    }

    public void run() {
        try {
            this.init();
            this.snmp.addCommandResponder((CommandResponder)this);
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
    }

    public void processPdu(CommandResponderEvent respEvnt) {
        System.out.println("\u76d1\u542c\u5230\u4e86\uff0c\u6709\u5bb6\u4f19");
        if (respEvnt != null && respEvnt.getPDU() != null) {
            Vector recVBs = respEvnt.getPDU().getVariableBindings();
            for (int i = 0; i < recVBs.size(); ++i) {
                VariableBinding recVB = (VariableBinding)recVBs.elementAt(i);
                System.out.println(recVB.getOid() + " : " + recVB.getVariable());
            }
        }
    }

    public void initComm1() throws IOException {
        this.targetAddress = GenericAddress.parse((String)"udp:192.168.1.112/162");
        DefaultUdpTransportMapping transport = new DefaultUdpTransportMapping();
        this.snmp = new Snmp((TransportMapping)transport);
        transport.listen();
    }

    @Override
    public void sendPDU1() {
        try {
            CommunityTarget target = new CommunityTarget();
            target.setAddress(this.targetAddress);
            target.setRetries(2);
            target.setTimeout(1500L);
            target.setVersion(1);
            PDU pdu = new PDU();
            pdu.add(new VariableBinding(new OID("")));
            pdu.add(new VariableBinding(new OID(".1.3.6.1.2.3377.10.1.1.1.2"), (Variable)new OctetString("JavaEE")));
            pdu.setType(-89);
            ResponseEvent respEvnt = this.snmp.send(pdu, (Target)target);
            if (respEvnt != null && respEvnt.getResponse() != null) {
                Vector recVBs = respEvnt.getResponse().getVariableBindings();
                for (int i = 0; i < recVBs.size(); ++i) {
                    VariableBinding recVB = (VariableBinding)recVBs.elementAt(i);
                    System.out.println(recVB.getOid() + " : " + recVB.getVariable());
                }
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    @Override
    public void snmpTrapTest() {
        try {
            System.out.println("go b");
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }
}

