/*
 * Decompiled with CFR 0.152.
 */
package com.sinba.common.security.action;

import com.opensymphony.xwork2.ActionSupport;
import com.sinba.common.dto.PageDTO;
import com.sinba.common.security.dto.CustomerDTO;
import com.sinba.common.security.dto.CustomerQueryDTO;
import com.sinba.common.security.service.ICustomerService;
import java.io.InputStream;
import java.util.Date;
import org.springframework.beans.factory.annotation.Autowired;

public class CustomerAction
extends ActionSupport {
    @Autowired
    private ICustomerService customerService;
    private PageDTO customers;
    private CustomerQueryDTO queryDto = new CustomerQueryDTO();
    private CustomerDTO customerDto = new CustomerDTO();
    private int page = 1;
    private int rows = 10;
    private Long[] orgNos;
    private Long orgNo;
    private String effect;
    private InputStream exportStream;
    private String fileName = "";
    private String sidx;
    private String sord;

    public String getSidx() {
        return this.sidx;
    }

    public void setSidx(String sidx) {
        this.sidx = sidx;
    }

    public String getSord() {
        return this.sord;
    }

    public void setSord(String sord) {
        this.sord = sord;
    }

    public String getEffect() {
        return this.effect;
    }

    public void setEffect(String effect) {
        this.effect = effect;
    }

    public InputStream getExportStream() {
        return this.exportStream;
    }

    public void setExportStream(InputStream exportStream) {
        this.exportStream = exportStream;
    }

    public String getFileName() {
        return this.fileName;
    }

    public void setFileName(String fileName) {
        this.fileName = fileName;
    }

    public ICustomerService getCustomerService() {
        return this.customerService;
    }

    public void setCustomerService(ICustomerService customerService) {
        this.customerService = customerService;
    }

    public PageDTO getCustomers() {
        return this.customers;
    }

    public void setCustomers(PageDTO customers) {
        this.customers = customers;
    }

    public CustomerQueryDTO getQueryDto() {
        return this.queryDto;
    }

    public void setQueryDto(CustomerQueryDTO queryDto) {
        this.queryDto = queryDto;
    }

    public CustomerDTO getCustomerDto() {
        return this.customerDto;
    }

    public void setCustomerDto(CustomerDTO customerDto) {
        this.customerDto = customerDto;
    }

    public int getPage() {
        return this.page;
    }

    public void setPage(int page) {
        this.page = page;
    }

    public int getRows() {
        return this.rows;
    }

    public void setRows(int rows) {
        this.rows = rows;
    }

    public Long[] getOrgNos() {
        return this.orgNos;
    }

    public void setOrgNos(Long[] orgNos) {
        this.orgNos = orgNos;
    }

    public Long getOrgNo() {
        return this.orgNo;
    }

    public void setOrgNo(Long orgNo) {
        this.orgNo = orgNo;
    }

    public String findByCompany() {
        int start = (this.page - 1) * this.rows;
        this.queryDto.setStart(start);
        this.queryDto.setLimit(this.rows);
        this.customers = this.customerService.findPagerCustomer(this.queryDto, this.sidx, this.sord);
        this.customers.setPage(this.page);
        this.customers.setRows(this.rows);
        return "success";
    }

    public String save() {
        this.customerService.saveCustomer(this.customerDto);
        return "success";
    }

    public String merge() {
        this.customerService.mergeCustomer(this.customerDto);
        return "success";
    }

    public String deleteCustomers() {
        this.customerService.deleteCustomer(this.orgNos);
        return "success";
    }

    public String deleteCustomer() {
        this.customerService.deleteCustomer(this.orgNo);
        return "success";
    }

    public String exportCustomer() {
        this.fileName = new Date().getTime() + ".xls";
        int start = (this.page - 1) * this.rows;
        this.queryDto.setStart(start);
        this.queryDto.setLimit(this.rows);
        try {
            this.exportStream = this.customerService.exportCustomerItems(this.queryDto, this.sidx, this.sord);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return "exportFileSuccessful";
    }

    public String importCustomerData() {
        this.effect = this.customerService.importCustomerItems(this.queryDto) + "";
        System.out.println("jeffect-------------:" + this.effect);
        return "importEffect";
    }
}

