/*
 * Decompiled with CFR 0.152.
 */
package com.sinba.common.security.action;

import com.opensymphony.xwork2.ActionSupport;
import com.sinba.common.dto.PageDTO;
import com.sinba.common.security.dto.FunctionDTO;
import com.sinba.common.security.dto.FunctionQueryDTO;
import com.sinba.common.security.dto.FunctionTreeDTO;
import com.sinba.common.security.service.IFunctionService;
import java.io.File;
import java.io.InputStream;
import java.io.UnsupportedEncodingException;
import org.springframework.beans.factory.annotation.Autowired;

public class FunctionAction
extends ActionSupport {
    @Autowired
    private IFunctionService functionService;
    private FunctionTreeDTO functionTreeDto;
    private FunctionDTO functionDto = new FunctionDTO();
    private FunctionQueryDTO functionQueryDTO = new FunctionQueryDTO();
    private int page = 1;
    private int rows = 10;
    private PageDTO functions;
    private Long[] resNos;
    private Boolean isExist = false;
    private File importFile;
    private InputStream exportFile;
    private String effect;

    public File getImportFile() {
        return this.importFile;
    }

    public void setImportFile(File importFile) {
        this.importFile = importFile;
    }

    public InputStream getExportFile() {
        return this.exportFile;
    }

    public void setExportFile(InputStream exportFile) {
        this.exportFile = exportFile;
    }

    public String getEffect() {
        return this.effect;
    }

    public void setEffect(String effect) {
        this.effect = effect;
    }

    public Boolean getIsExist() {
        return this.isExist;
    }

    public void setIsExist(Boolean isExist) {
        this.isExist = isExist;
    }

    public FunctionDTO getFunctionDto() {
        return this.functionDto;
    }

    public void setFunctionDto(FunctionDTO functionDto) {
        this.functionDto = functionDto;
    }

    public IFunctionService getFunctionService() {
        return this.functionService;
    }

    public void setFunctionService(IFunctionService functionService) {
        this.functionService = functionService;
    }

    public FunctionTreeDTO getFunctionTreeDto() {
        return this.functionTreeDto;
    }

    public void setFunctionTreeDto(FunctionTreeDTO functionTreeDto) {
        this.functionTreeDto = functionTreeDto;
    }

    public FunctionQueryDTO getFunctionQueryDTO() {
        return this.functionQueryDTO;
    }

    public void setFunctionQueryDTO(FunctionQueryDTO functionQueryDTO) {
        this.functionQueryDTO = functionQueryDTO;
    }

    public int getPage() {
        return this.page;
    }

    public void setPage(int page) {
        this.page = page;
    }

    public int getRows() {
        return this.rows;
    }

    public void setRows(int rows) {
        this.rows = rows;
    }

    public PageDTO getFunctions() {
        return this.functions;
    }

    public void setFunctions(PageDTO functions) {
        this.functions = functions;
    }

    public Long[] getResNos() {
        return this.resNos;
    }

    public void setResNos(Long[] resNos) {
        this.resNos = resNos;
    }

    public String findGrid() {
        int start = (this.page - 1) * this.rows;
        this.functionQueryDTO.setStart(start);
        this.functionQueryDTO.setLimit(this.rows);
        this.functions = this.functionService.findPagerFunction(this.functionQueryDTO);
        this.functions.setPage(this.page);
        this.functions.setRows(this.rows);
        return "functionGrid";
    }

    public String findTree() {
        this.functionTreeDto = new FunctionTreeDTO();
        this.functionTreeDto.setData("ROOT");
        this.functionTreeDto.setChildren(this.functionService.findFunctionTreeDtos());
        return "success";
    }

    public String addFunction() {
        this.functionService.addFunction(this.functionDto);
        return "success";
    }

    public String updateFunction() {
        this.functionService.upadteFunction(this.functionDto);
        return "success";
    }

    public String deleteFunction() {
        this.isExist = this.functionService.deleteFunction(this.functionDto.getResNo());
        return "isExist";
    }

    public String deleteFunctionByIds() {
        this.isExist = this.functionService.deleteFunction(this.resNos);
        return "isExist";
    }

    public String copyFunction() {
        this.functionDto = this.functionService.copyFunction(this.functionDto.getResNo(), this.functionDto.getParentFunctionNo());
        return "success";
    }

    public String cutFunction() {
        this.functionService.cutFunction(this.functionDto.getResNo(), this.functionDto.getParentFunctionNo());
        return "success";
    }

    public String findExist() throws UnsupportedEncodingException {
        if (this.functionQueryDTO.getResName() != null) {
            String resName = new String(this.functionQueryDTO.getResName().getBytes("ISO-8859-1"), "UTF-8");
            this.functionQueryDTO.setResName(resName);
        }
        if (this.functionQueryDTO.getResCode() != null) {
            String resCode = new String(this.functionQueryDTO.getResCode().getBytes("ISO-8859-1"), "UTF-8");
            this.functionQueryDTO.setResCode(resCode);
        }
        if (this.functionQueryDTO.getResUrl() != null) {
            String resUrl = new String(this.functionQueryDTO.getResUrl().getBytes("ISO-8859-1"), "UTF-8");
            this.functionQueryDTO.setResUrl(resUrl);
        }
        this.isExist = this.functionService.findFunctionExist(this.functionQueryDTO);
        return "isExist";
    }

    public String exportFunction() {
        int start = (this.page - 1) * this.rows;
        this.functionQueryDTO.setStart(start);
        this.functionQueryDTO.setLimit(this.rows);
        this.exportFile = this.functionService.exportFunction(this.functionQueryDTO);
        return "exportFile";
    }

    public String importFunction() {
        this.effect = this.functionService.importFunction(this.importFile.getAbsolutePath());
        return "effect";
    }
}

