/*
 * Decompiled with CFR 0.152.
 */
package com.sinba.common.security.action;

import com.opensymphony.xwork2.ActionSupport;
import com.sinba.common.dto.PageDTO;
import com.sinba.common.security.dto.LDAPCheckDTO;
import com.sinba.common.security.dto.LDAPDTO;
import com.sinba.common.security.dto.LDAPQueryDTO;
import com.sinba.common.security.dto.UserDTO;
import com.sinba.common.security.service.ILDAPService;
import java.util.List;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class LDAPAction
extends ActionSupport {
    private ILDAPService ldapService;
    private PageDTO pageDto;
    private LDAPDTO ldapDto = new LDAPDTO();
    private LDAPQueryDTO queryDto = new LDAPQueryDTO();
    private LDAPCheckDTO ldapCheckDto = new LDAPCheckDTO();
    private UserDTO userDto = new UserDTO();
    private List<LDAPDTO> ldapDtos;
    private Long[] ids;
    private boolean result = false;
    private int page = 1;
    private int rows = 10;

    public ILDAPService getLdapService() {
        return this.ldapService;
    }

    public void setLdapService(ILDAPService ldapService) {
        this.ldapService = ldapService;
    }

    public PageDTO getPageDto() {
        return this.pageDto;
    }

    public void setPageDto(PageDTO pageDto) {
        this.pageDto = pageDto;
    }

    public LDAPDTO getLdapDto() {
        return this.ldapDto;
    }

    public void setLdapDto(LDAPDTO ldapDto) {
        this.ldapDto = ldapDto;
    }

    public LDAPQueryDTO getQueryDto() {
        return this.queryDto;
    }

    public void setQueryDto(LDAPQueryDTO queryDto) {
        this.queryDto = queryDto;
    }

    public UserDTO getUserDto() {
        return this.userDto;
    }

    public void setUserDto(UserDTO userDto) {
        this.userDto = userDto;
    }

    public List<LDAPDTO> getLdapDtos() {
        return this.ldapDtos;
    }

    public void setLdapDtos(List<LDAPDTO> ldapDtos) {
        this.ldapDtos = ldapDtos;
    }

    public Long[] getIds() {
        return this.ids;
    }

    public void setIds(Long[] ids) {
        this.ids = ids;
    }

    public LDAPCheckDTO getLdapCheckDto() {
        return this.ldapCheckDto;
    }

    public void setLdapCheckDto(LDAPCheckDTO ldapCheckDto) {
        this.ldapCheckDto = ldapCheckDto;
    }

    public boolean isResult() {
        return this.result;
    }

    public void setResult(boolean result) {
        this.result = result;
    }

    public int getPage() {
        return this.page;
    }

    public void setPage(int page) {
        this.page = page;
    }

    public int getRows() {
        return this.rows;
    }

    public void setRows(int rows) {
        this.rows = rows;
    }

    public String getADByLDAP() {
        this.pageDto = this.ldapService.getAllLdap(this.page, this.rows, this.queryDto.getLdapId());
        return "success";
    }

    public String adUserImport() {
        this.result = this.ldapService.adUserImport(this.userDto);
        return "result";
    }

    public String save() {
        this.ldapService.saveLdap(this.ldapDto);
        return "success";
    }

    public String find() {
        int start = (this.page - 1) * this.rows;
        this.queryDto.setLimit(this.rows);
        this.queryDto.setStart(start);
        this.pageDto = this.ldapService.findPagerLdap(this.queryDto);
        this.pageDto.setPage(this.page);
        this.pageDto.setRows(this.rows);
        return "success";
    }

    public String mergeLdap() {
        this.ldapService.mergeLdap(this.ldapDto);
        return "success";
    }

    public String delete() {
        this.ldapService.deleteLdap(this.ids);
        return "success";
    }

    public String getLDAPAll() {
        this.ldapDtos = this.ldapService.getLDAPAll();
        return "ldapDtos";
    }

    public String ldapConfigCheck() {
        this.result = this.ldapService.ldapConfigCheck(this.ldapCheckDto);
        return "result";
    }
}

