/*
 * Decompiled with CFR 0.152.
 */
package com.sinba.common.security.action;

import com.opensymphony.xwork2.ActionSupport;
import com.sinba.common.dto.PageDTO;
import com.sinba.common.security.dto.CompanyDTO;
import com.sinba.common.security.dto.OrganizationDTO;
import com.sinba.common.security.dto.OrganizationQueryDTO;
import com.sinba.common.security.dto.OrganizationTreeDTO;
import com.sinba.common.security.entity.Role;
import com.sinba.common.security.service.ICompanyService;
import com.sinba.common.security.service.ICustomerService;
import com.sinba.common.security.service.IOrganizationInnerService;
import com.sinba.common.security.service.IOrganizationService;
import com.sinba.common.security.service.IOrganizationServicesService;
import com.sinba.common.security.service.ISupplierService;
import java.io.File;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.List;
import java.util.Set;
import org.springframework.beans.factory.annotation.Autowired;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class OrganizationAction
extends ActionSupport {
    @Autowired
    private IOrganizationService organizationService;
    @Autowired
    private ICompanyService companyService;
    @Autowired
    private ICustomerService customerService;
    @Autowired
    private ISupplierService supplierService;
    @Autowired
    private IOrganizationInnerService organizationInnerService;
    private OrganizationDTO organizationDto = new OrganizationDTO();
    private OrganizationQueryDTO organizationQueryDto = new OrganizationQueryDTO();
    private OrganizationTreeDTO organizations;
    private CompanyDTO company = new CompanyDTO();
    private String orgTypeString;
    private int page = 1;
    private int rows = 10;
    private PageDTO organizationPage;
    private Long[] orgNos;
    private String actionType;
    private String doTag;
    private Long orgNo;
    private String orgType;
    private List<Long> orgRoles;
    private File importFile;
    private InputStream exportFile;
    private String effect;
    private List<OrganizationDTO> orgList = new ArrayList<OrganizationDTO>();
    private IOrganizationServicesService organizationServicesService;

    public String getEffect() {
        return this.effect;
    }

    public void setEffect(String effect) {
        this.effect = effect;
    }

    public File getImportFile() {
        return this.importFile;
    }

    public void setImportFile(File importFile) {
        this.importFile = importFile;
    }

    public InputStream getExportFile() {
        return this.exportFile;
    }

    public void setExportFile(InputStream exportFile) {
        this.exportFile = exportFile;
    }

    public List<Long> getOrgRoles() {
        return this.orgRoles;
    }

    public void setOrgRoles(List<Long> orgRoles) {
        this.orgRoles = orgRoles;
    }

    public List<OrganizationDTO> getOrgList() {
        return this.orgList;
    }

    public void setOrgList(List<OrganizationDTO> orgList) {
        this.orgList = orgList;
    }

    public CompanyDTO getCompany() {
        return this.company;
    }

    public void setCompany(CompanyDTO company) {
        this.company = company;
    }

    public String getOrgType() {
        return this.orgType;
    }

    public void setOrgType(String orgType) {
        this.orgType = orgType;
    }

    public Long getOrgNo() {
        return this.orgNo;
    }

    public void setOrgNo(Long orgNo) {
        this.orgNo = orgNo;
    }

    public IOrganizationInnerService getOrganizationInnerService() {
        return this.organizationInnerService;
    }

    public void setOrganizationInnerService(IOrganizationInnerService organizationInnerService) {
        this.organizationInnerService = organizationInnerService;
    }

    public ICustomerService getCustomerService() {
        return this.customerService;
    }

    public void setCustomerService(ICustomerService customerService) {
        this.customerService = customerService;
    }

    public ISupplierService getSupplierService() {
        return this.supplierService;
    }

    public void setSupplierService(ISupplierService supplierService) {
        this.supplierService = supplierService;
    }

    public String getDoTag() {
        return this.doTag;
    }

    public void setDoTag(String doTag) {
        this.doTag = doTag;
    }

    public String getActionType() {
        return this.actionType;
    }

    public void setActionType(String actionType) {
        this.actionType = actionType;
    }

    public Long[] getOrgNos() {
        return this.orgNos;
    }

    public void setOrgNos(Long[] orgNos) {
        this.orgNos = orgNos;
    }

    public OrganizationQueryDTO getOrganizationQueryDto() {
        return this.organizationQueryDto;
    }

    public void setOrganizationQueryDto(OrganizationQueryDTO organizationQueryDto) {
        this.organizationQueryDto = organizationQueryDto;
    }

    public int getPage() {
        return this.page;
    }

    public void setPage(int page) {
        this.page = page;
    }

    public int getRows() {
        return this.rows;
    }

    public void setRows(int rows) {
        this.rows = rows;
    }

    public PageDTO getOrganizationPage() {
        return this.organizationPage;
    }

    public void setOrganizationPage(PageDTO organizationPage) {
        this.organizationPage = organizationPage;
    }

    public ICompanyService getCompanyService() {
        return this.companyService;
    }

    public void setCompanyService(ICompanyService companyService) {
        this.companyService = companyService;
    }

    public OrganizationTreeDTO getOrganizations() {
        return this.organizations;
    }

    public void setOrganizations(OrganizationTreeDTO organizations) {
        this.organizations = organizations;
    }

    public OrganizationDTO getOrganizationDto() {
        return this.organizationDto;
    }

    public void setOrganizationDto(OrganizationDTO organizationDto) {
        this.organizationDto = organizationDto;
    }

    public IOrganizationService getOrganizationService() {
        return this.organizationService;
    }

    public void setOrganizationService(IOrganizationService organizationService) {
        this.organizationService = organizationService;
    }

    public String getOrgTypeString() {
        return this.orgTypeString;
    }

    public void setOrgTypeString(String orgTypeString) {
        this.orgTypeString = orgTypeString;
    }

    public IOrganizationServicesService getOrganizationServicesService() {
        return this.organizationServicesService;
    }

    public void setOrganizationServicesService(IOrganizationServicesService organizationServicesService) {
        this.organizationServicesService = organizationServicesService;
    }

    public String findCompany() {
        this.company = new CompanyDTO();
        this.company = this.companyService.findCompany();
        return "company";
    }

    public String find() {
        int start = (this.page - 1) * this.rows;
        this.organizationQueryDto.setStart(start);
        this.organizationQueryDto.setLimit(this.rows);
        this.organizationPage = this.organizationService.findPagerOrganization(this.organizationQueryDto);
        this.organizationPage.setPage(this.page);
        this.organizationPage.setRows(this.rows);
        return "organizationPage";
    }

    public String findAll() {
        this.organizations = new OrganizationTreeDTO();
        this.organizations.setData("ROOT");
        this.organizations.getAttr().put("orgName", "ROOT");
        this.organizations.getAttr().put("orgType", "ROOT");
        this.organizations.getAttr().put("orgNo", "1");
        this.organizations.setChildren(this.organizationService.findOrgTreeDtos());
        return "success";
    }

    public String findAllWithPanel() {
        this.organizations = new OrganizationTreeDTO();
        this.organizations.setData("ROOT");
        this.organizations.getAttr().put("orgName", "ROOT");
        this.organizations.getAttr().put("orgType", "ROOT");
        this.organizations.getAttr().put("orgNo", "1");
        this.organizations.setChildren(this.organizationService.findAllWidthOutPanel());
        return "success";
    }

    public String findInner() {
        this.organizations = new OrganizationTreeDTO();
        this.organizations.setData("ROOT");
        this.organizations.getAttr().put("orgName", "ROOT");
        this.organizations.getAttr().put("orgType", "ROOT");
        this.organizations.getAttr().put("orgNo", "1");
        this.organizations.setChildren(this.organizationService.findInnerOrgTreeDtos());
        return "success";
    }

    public String findServicesTree() {
        this.organizations = new OrganizationTreeDTO();
        this.organizations.setData("ROOT");
        this.organizations.getAttr().put("orgName", "ROOT");
        this.organizations.getAttr().put("orgType", "ROOT");
        this.organizations.getAttr().put("orgNo", "1");
        this.organizations.setChildren(this.organizationService.findServicesOrgTreeDtos());
        return "success";
    }

    public String findOrganizationsByType() {
        this.orgList = this.organizationService.findOrganizationsByType(this.orgType);
        return "orgList";
    }

    public String findAllCompany() {
        this.organizations = new OrganizationTreeDTO();
        this.organizations.setData("ROOT");
        this.organizations.getAttr().put("orgName", "ROOT");
        this.organizations.getAttr().put("orgType", "ROOT");
        this.organizations.getAttr().put("orgNo", "1");
        this.organizations.setChildren(this.organizationService.findOrganizationSelectTree());
        return "success";
    }

    public String save() {
        if ("inner".equals(this.actionType)) {
            this.organizationInnerService.saveOrganizationInner(this.organizationDto);
        }
        if ("services".equals(this.actionType)) {
            this.organizationServicesService.saveOrganizationServices(this.organizationDto);
        }
        return "success";
    }

    public String updateOrg() {
        if ("inner".equals(this.orgType)) {
            this.organizationInnerService.mergeOrganizationInner(this.organizationDto);
        }
        if ("services".equals(this.orgType)) {
            this.organizationServicesService.mergeOrganizationServices(this.organizationDto);
        }
        if ("company".equals(this.orgType)) {
            this.companyService.mergeCompany(this.organizationDto);
        }
        return "success";
    }

    public String updateOrgWin() {
        if (this.companyService.findCompanyById(this.organizationDto.getOrgNo()) != null) {
            this.companyService.mergeCompany(this.organizationDto);
        }
        if (this.organizationInnerService.findOrganizationInnerById(this.organizationDto.getOrgNo()) != null) {
            this.organizationInnerService.mergeOrganizationInner(this.organizationDto);
        }
        if (this.organizationServicesService.findOrganizationServicesById(this.organizationDto.getOrgNo()) != null) {
            this.organizationServicesService.mergeOrganizationServices(this.organizationDto);
        }
        if (this.customerService.findCustomerById(this.organizationDto.getOrgNo()) != null) {
            this.customerService.mergeCustomer(this.organizationDto);
        }
        if (this.supplierService.findSupplierById(this.organizationDto.getOrgNo()) != null) {
            this.supplierService.mergeSupplier(this.organizationDto);
        }
        return "success";
    }

    public String remove() {
        this.organizationService.removeServicesOrg(this.orgNo);
        return "success";
    }

    public String deleteOrgs() {
        this.organizationService.deleteOrgs(this.orgNos);
        return "success";
    }

    public String moveOrg() {
        this.organizationService.moveOrg(this.organizationDto);
        return "success";
    }

    public String copyOrg() {
        this.orgNo = this.organizationService.copyOrg(this.organizationDto);
        return "success";
    }

    public String mergeCompany() {
        this.companyService.mergeCompany(this.organizationDto);
        return "success";
    }

    public String getOrgByOrgNo() {
        this.organizationDto = this.organizationService.findOrganizationById(this.orgNo);
        return "organizationDto";
    }

    public String findRolesByOrgNo() {
        if (this.orgNo != null) {
            Set<Role> entitys = this.organizationService.findRolesById(this.orgNo);
            ArrayList<Long> roleIds = new ArrayList<Long>();
            if (entitys != null) {
                for (Role r : entitys) {
                    roleIds.add(r.getRoleId());
                }
            }
            this.orgRoles = roleIds;
            return "orgRoles";
        }
        return null;
    }

    public String exportOrganization() {
        int start = (this.page - 1) * this.rows;
        this.organizationQueryDto.setStart(start);
        this.organizationQueryDto.setLimit(this.rows);
        this.exportFile = this.organizationService.exportOrganization(this.organizationQueryDto);
        return "exportFile";
    }

    public String importOrganization() {
        this.effect = this.organizationService.importOrganization(this.importFile.getAbsolutePath());
        return "effect";
    }
}

