/*
 * Decompiled with CFR 0.152.
 */
package com.sinba.common.security.action;

import com.opensymphony.xwork2.ActionSupport;
import com.sinba.common.dto.PageDTO;
import com.sinba.common.security.dto.EditUserPasswordDTO;
import com.sinba.common.security.dto.UserDTO;
import com.sinba.common.security.dto.UserQueryDTO;
import com.sinba.common.security.dto.UserRoleDTO;
import com.sinba.common.security.service.IUserInfoService;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class UserAction
extends ActionSupport {
    private IUserInfoService userInfoService;
    private UserDTO userDto = new UserDTO();
    private List<UserRoleDTO> userRoleDto = new ArrayList<UserRoleDTO>();
    private UserQueryDTO userQueryDto = new UserQueryDTO();
    private boolean result = false;
    private PageDTO users;
    private Long[] ids;
    private String sord;
    private String sidx;
    private int id;
    private int page = 1;
    private int rows = 10;
    private String str;
    private String userName;
    private String pwd;
    private String resultString;
    private String effect = "";
    private InputStream exportStream;
    private String fileName = "";
    private Long[] roleIds;
    private String[] userNames;
    private EditUserPasswordDTO editUserPasswordDTO;

    public String[] getUserNames() {
        return this.userNames;
    }

    public void setUserNames(String[] userNames) {
        this.userNames = userNames;
    }

    public String getEffect() {
        return this.effect;
    }

    public void setEffect(String effect) {
        this.effect = effect;
    }

    public InputStream getExportStream() {
        return this.exportStream;
    }

    public void setExportStream(InputStream exportStream) {
        this.exportStream = exportStream;
    }

    public String getFileName() {
        return this.fileName;
    }

    public void setFileName(String fileName) {
        this.fileName = fileName;
    }

    public String getPwd() {
        return this.pwd;
    }

    public void setPwd(String pwd) {
        this.pwd = pwd;
    }

    public String getResultString() {
        return this.resultString;
    }

    public void setResultString(String resultString) {
        this.resultString = resultString;
    }

    public String getUserName() {
        return this.userName;
    }

    public void setUserName(String userName) {
        this.userName = userName;
    }

    public String getStr() {
        return this.str;
    }

    public void setStr(String str) {
        this.str = str;
    }

    public IUserInfoService getUserInfoService() {
        return this.userInfoService;
    }

    public void setUserInfoService(IUserInfoService userInfoService) {
        this.userInfoService = userInfoService;
    }

    public UserDTO getUserDto() {
        return this.userDto;
    }

    public void setUserDto(UserDTO userDto) {
        this.userDto = userDto;
    }

    public UserQueryDTO getUserQueryDto() {
        return this.userQueryDto;
    }

    public void setUserQueryDto(UserQueryDTO userQueryDto) {
        this.userQueryDto = userQueryDto;
    }

    public boolean isResult() {
        return this.result;
    }

    public void setResult(boolean result) {
        this.result = result;
    }

    public List<UserRoleDTO> getUserRoleDto() {
        return this.userRoleDto;
    }

    public void setUserRoleDto(List<UserRoleDTO> userRoleDto) {
        this.userRoleDto = userRoleDto;
    }

    public PageDTO getUsers() {
        return this.users;
    }

    public void setUsers(PageDTO users) {
        this.users = users;
    }

    public Long[] getIds() {
        return this.ids;
    }

    public void setIds(Long[] ids) {
        this.ids = ids;
    }

    public String getSord() {
        return this.sord;
    }

    public void setSord(String sord) {
        this.sord = sord;
    }

    public String getSidx() {
        return this.sidx;
    }

    public void setSidx(String sidx) {
        this.sidx = sidx;
    }

    public int getId() {
        return this.id;
    }

    public void setId(int id) {
        this.id = id;
    }

    public int getPage() {
        return this.page;
    }

    public void setPage(int page) {
        this.page = page;
    }

    public int getRows() {
        return this.rows;
    }

    public void setRows(int rows) {
        this.rows = rows;
    }

    public Long[] getRoleIds() {
        return this.roleIds;
    }

    public void setRoleIds(Long[] roleIds) {
        this.roleIds = roleIds;
    }

    public EditUserPasswordDTO getEditUserPasswordDTO() {
        return this.editUserPasswordDTO;
    }

    public void setEditUserPasswordDTO(EditUserPasswordDTO editUserPasswordDTO) {
        this.editUserPasswordDTO = editUserPasswordDTO;
    }

    public String save() {
        this.userInfoService.saveUser(this.userDto);
        return "success";
    }

    public String find() {
        int start = (this.page - 1) * this.rows;
        this.userQueryDto.setStart(start);
        this.userQueryDto.setLimit(this.rows);
        this.users = this.userInfoService.findPagerUser(this.userQueryDto, this.sord, this.sidx);
        this.users.setPage(this.page);
        this.users.setRows(this.rows);
        return "success";
    }

    public String merge() {
        this.userInfoService.editUser(this.userDto);
        return "success";
    }

    public String delUser() {
        this.result = this.userInfoService.delUser(this.ids);
        return "result";
    }

    public String getUserRole() {
        this.userRoleDto = this.userInfoService.getUserRoleByUserId(this.id);
        return "userRole";
    }

    public String updateRoleByUserId() {
        this.userInfoService.mergeAllUser(this.ids, this.userDto.getRoleIds());
        return "success";
    }

    public String userExist() {
        this.result = this.userDto.getUserId() > 0L ? true : this.userInfoService.userExist(this.userDto.getLoginName());
        return "result";
    }

    public String mergeByOrg() {
        if (this.str != null && !this.str.equals("")) {
            String[] userIds = this.str.split(",");
            this.result = this.userInfoService.mergeByOrg(userIds, this.id);
        }
        return "result";
    }

    public String findByUserName() {
        this.userDto = this.userInfoService.findUserByName(this.userName);
        return "singleUser";
    }

    public String findDisable() {
        this.resultString = this.userInfoService.findDisable(this.userName, this.pwd);
        return "resultString";
    }

    public String vaildateUserByIds() {
        this.result = true;
        for (String userName : this.userNames) {
            if (userName == null || userName.equals("") || this.userInfoService.findUserByName(userName) != null) continue;
            this.result = false;
            break;
        }
        return "result";
    }

    public String exportUser() {
        this.fileName = new Date().getTime() + ".xls";
        int start = (this.page - 1) * this.rows;
        try {
            this.userQueryDto.setStart(start);
            this.userQueryDto.setLimit(this.rows);
            this.exportStream = this.userInfoService.exportUserItems(this.userQueryDto, this.sord, this.sidx);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return "exportFileSuccessful";
    }

    public String importUserData() {
        this.effect = this.userInfoService.importUserItems(this.userQueryDto) + "";
        return "importEffect";
    }

    public String resetPassword() {
        this.result = this.userInfoService.resetPassword(this.editUserPasswordDTO);
        return "result";
    }
}

