/*
 * Decompiled with CFR 0.152.
 */
package com.sinba.common.security.dao;

import com.sinba.common.dao.BaseDAOImplHibernate;
import com.sinba.common.dto.PageDTO;
import com.sinba.common.security.dao.ICustomerDAO;
import com.sinba.common.security.dto.CustomerQueryDTO;
import com.sinba.common.security.entity.Customer;
import com.sinba.common.util.StringUtils;
import java.util.List;
import org.hibernate.criterion.Criterion;
import org.hibernate.criterion.DetachedCriteria;
import org.hibernate.criterion.MatchMode;
import org.hibernate.criterion.Order;
import org.hibernate.criterion.Restrictions;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class CustomerDAO
extends BaseDAOImplHibernate<Customer>
implements ICustomerDAO {
    @Override
    public PageDTO findPager(CustomerQueryDTO qdto, String sidx, String sord) {
        DetachedCriteria dc = DetachedCriteria.forClass(Customer.class);
        int start = 0;
        int limit = 0;
        if (qdto != null) {
            start = qdto.getStart();
            limit = qdto.getLimit();
            if (qdto.getCompanyNo() != null) {
                dc.createAlias("parentOrg", "par");
                dc.add((Criterion)Restrictions.eq((String)"par.orgNo", (Object)qdto.getCompanyNo()));
            }
            if (StringUtils.hasText((String)qdto.getOrgName())) {
                dc.add((Criterion)Restrictions.like((String)"orgName", (String)qdto.getOrgName(), (MatchMode)MatchMode.ANYWHERE));
            }
            if (StringUtils.hasText((String)qdto.getOfficePhone())) {
                dc.add((Criterion)Restrictions.like((String)"officePhone", (String)qdto.getOfficePhone(), (MatchMode)MatchMode.ANYWHERE));
            }
            if (StringUtils.hasText((String)qdto.getEmail())) {
                dc.add((Criterion)Restrictions.like((String)"email", (String)qdto.getEmail(), (MatchMode)MatchMode.ANYWHERE));
            }
            if (StringUtils.hasText((String)qdto.getAddress())) {
                dc.add((Criterion)Restrictions.like((String)"address", (String)qdto.getAddress(), (MatchMode)MatchMode.ANYWHERE));
            }
        }
        if (sord != null && !sord.equals("") && sidx != null && !sidx.equals("")) {
            if (sord.equals("desc")) {
                dc.addOrder(Order.desc((String)sidx));
            } else {
                dc.addOrder(Order.asc((String)sidx));
            }
        }
        return super.findPageByCriteria(dc, start, limit);
    }

    @Override
    public List<Customer> findByCompanyNo(Long companyNo) {
        List customers = super.getHibernateTemplate().find(" from Customer cus where cus.parentOrg.orgNo=" + companyNo);
        return customers;
    }
}

