/*
 * Decompiled with CFR 0.152.
 */
package com.sinba.common.security.dao;

import com.sinba.common.dao.BaseDAOImplHibernate;
import com.sinba.common.dto.PageDTO;
import com.sinba.common.security.dao.ILDAPDAO;
import com.sinba.common.security.dto.LDAPCheckDTO;
import com.sinba.common.security.dto.LDAPDTO;
import com.sinba.common.security.dto.LDAPQueryDTO;
import com.sinba.common.security.dto.UserDTO;
import com.sinba.common.security.entity.LDAP;
import com.sinba.common.util.StringUtils;
import java.util.ArrayList;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.List;
import java.util.Properties;
import javax.naming.NamingEnumeration;
import javax.naming.directory.Attributes;
import javax.naming.directory.InitialDirContext;
import javax.naming.directory.SearchControls;
import javax.naming.directory.SearchResult;
import javax.naming.ldap.InitialLdapContext;
import org.hibernate.criterion.Criterion;
import org.hibernate.criterion.DetachedCriteria;
import org.hibernate.criterion.MatchMode;
import org.hibernate.criterion.Restrictions;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class LDAPDAO
extends BaseDAOImplHibernate<LDAP>
implements ILDAPDAO {
    @Override
    public PageDTO findPager(LDAPQueryDTO queryDto) {
        DetachedCriteria dc = DetachedCriteria.forClass(LDAP.class);
        int start = 0;
        int limit = 0;
        if (queryDto != null) {
            start = queryDto.getStart();
            limit = queryDto.getLimit();
            if (StringUtils.hasText((String)queryDto.getLdapType())) {
                dc.add((Criterion)Restrictions.like((String)"ldapType", (String)queryDto.getLdapType(), (MatchMode)MatchMode.ANYWHERE));
            }
            if (StringUtils.hasText((String)queryDto.getLdapName())) {
                dc.add((Criterion)Restrictions.like((String)"ldapName", (String)queryDto.getLdapName(), (MatchMode)MatchMode.ANYWHERE));
            }
            if (StringUtils.hasText((String)queryDto.getLdapURL())) {
                dc.add((Criterion)Restrictions.like((String)"ldapURL", (String)queryDto.getLdapURL(), (MatchMode)MatchMode.ANYWHERE));
            }
        }
        return super.findPageByCriteria(dc, start, limit);
    }

    @Override
    public List<UserDTO> microsoftLDAP(LDAPDTO parDto) {
        ArrayList<UserDTO> listUser = new ArrayList<UserDTO>();
        Hashtable<String, String> hashEnv = new Hashtable<String, String>();
        hashEnv.put("java.naming.security.authentication", "simple");
        hashEnv.put("java.naming.security.principal", parDto.getAdminName());
        hashEnv.put("java.naming.security.credentials", parDto.getAdminPassword());
        hashEnv.put("java.naming.factory.initial", "com.sun.jndi.ldap.LdapCtxFactory");
        hashEnv.put("java.naming.provider.url", parDto.getLdapURL() + ":" + parDto.getProt());
        try {
            InitialLdapContext ctx = new InitialLdapContext(hashEnv, null);
            SearchControls searchCtls = new SearchControls();
            searchCtls.setSearchScope(2);
            NamingEnumeration<SearchResult> answer = ctx.search(parDto.getSearchBase(), parDto.getSearchFilter(), searchCtls);
            while (answer.hasMoreElements()) {
                SearchResult sr = answer.next();
                Attributes attrs = sr.getAttributes();
                UserDTO userDto = new UserDTO();
                userDto.setLoginName(attrs.get("sAMAccountName").get().toString());
                try {
                    userDto.setEmail(attrs.get("mail").get().toString());
                }
                catch (Exception e) {
                    userDto.setEmail("");
                }
                try {
                    userDto.setFirstName(attrs.get("givenName").get().toString());
                }
                catch (Exception e) {
                    userDto.setFirstName("");
                }
                try {
                    userDto.setLastName(attrs.get("sn").get().toString());
                }
                catch (Exception e) {
                    userDto.setLastName("");
                }
                try {
                    userDto.setMoblie(attrs.get("homePhone").get().toString());
                }
                catch (Exception e) {
                    userDto.setMoblie("");
                }
                try {
                    userDto.setPhone(attrs.get("telephoneNumber").get().toString());
                }
                catch (Exception e) {
                    userDto.setPhone("");
                }
                listUser.add(userDto);
            }
            ctx.close();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return listUser;
    }

    @Override
    public List<UserDTO> linuxLDAP(LDAPDTO parDto) {
        ArrayList<UserDTO> listUser = new ArrayList<UserDTO>();
        Hashtable<String, String> hashEnv = new Hashtable<String, String>();
        hashEnv.put("java.naming.security.authentication", "simple");
        hashEnv.put("java.naming.security.principal", parDto.getAdminName());
        hashEnv.put("java.naming.security.credentials", parDto.getAdminPassword());
        hashEnv.put("java.naming.factory.initial", "com.sun.jndi.ldap.LdapCtxFactory");
        hashEnv.put("java.naming.provider.url", parDto.getLdapURL() + ":" + parDto.getProt() + "/" + parDto.getSearchBase());
        try {
            InitialLdapContext ctx = new InitialLdapContext(hashEnv, null);
            SearchControls searchCtls = new SearchControls();
            searchCtls.setSearchScope(2);
            NamingEnumeration<SearchResult> answer = ctx.search(parDto.getSearchBase(), parDto.getSearchFilter(), searchCtls);
            while (answer.hasMoreElements()) {
                SearchResult sr = answer.next();
                Attributes attrs = sr.getAttributes();
                UserDTO userDto = new UserDTO();
                userDto.setLoginName(attrs.get("sAMAccountName").get().toString());
                try {
                    userDto.setEmail(attrs.get("mail").get().toString());
                }
                catch (Exception e) {
                    userDto.setEmail("");
                }
                try {
                    userDto.setFirstName(attrs.get("givenName").get().toString());
                }
                catch (Exception e) {
                    userDto.setFirstName("");
                }
                try {
                    userDto.setLastName(attrs.get("sn").get().toString());
                }
                catch (Exception e) {
                    userDto.setLastName("");
                }
                try {
                    userDto.setMoblie(attrs.get("homePhone").get().toString());
                }
                catch (Exception e) {
                    // empty catch block
                }
                try {
                    userDto.setPhone(attrs.get("telephoneNumber").get().toString());
                }
                catch (Exception e) {
                    userDto.setPhone("");
                }
                listUser.add(userDto);
            }
            ctx.close();
        }
        catch (Exception e) {
            // empty catch block
        }
        return listUser;
    }

    @Override
    public List<UserDTO> ciscoLDAP(LDAPDTO parDto) {
        ArrayList<UserDTO> listUser = new ArrayList<UserDTO>();
        return listUser;
    }

    @Override
    public List<UserDTO> otherLDAP(LDAPDTO parDto) {
        ArrayList<UserDTO> listUser = new ArrayList<UserDTO>();
        return listUser;
    }

    @Override
    public boolean ldapAuthentication(String usrName, String userPwd, String ldapURL, String port) {
        boolean result = false;
        Properties props = new Properties();
        props.put("java.naming.factory.initial", "com.sun.jndi.ldap.LdapCtxFactory");
        props.put("java.naming.security.authentication", "simple");
        props.put("java.naming.security.credentials", userPwd);
        props.put("java.naming.security.principal", usrName);
        props.put("java.naming.provider.url", ldapURL + ":" + port);
        try {
            new InitialDirContext(props);
            result = true;
        }
        catch (Exception ex) {
            result = false;
        }
        return result;
    }

    @Override
    public boolean ldapAuthentication(List<LDAPDTO> ldapDtos, String userName, String password) {
        boolean result;
        block1: {
            LDAPDTO ldapDto;
            result = false;
            if (ldapDtos == null) break block1;
            Iterator<LDAPDTO> i$ = ldapDtos.iterator();
            while (i$.hasNext() && !(result = this.ldapAuthentication(userName, password, (ldapDto = i$.next()).getLdapURL(), ldapDto.getProt()))) {
            }
        }
        return result;
    }

    @Override
    public boolean microsoftLDAPCheck(LDAPCheckDTO ldapCheckDto) {
        boolean result = false;
        Hashtable<String, String> hashEnv = new Hashtable<String, String>();
        hashEnv.put("java.naming.security.authentication", "simple");
        hashEnv.put("java.naming.security.principal", ldapCheckDto.getAdminName());
        hashEnv.put("java.naming.security.credentials", ldapCheckDto.getAdminPassword());
        hashEnv.put("java.naming.factory.initial", "com.sun.jndi.ldap.LdapCtxFactory");
        hashEnv.put("java.naming.provider.url", ldapCheckDto.getLdapURL() + ":" + ldapCheckDto.getProt());
        try {
            InitialLdapContext ctx = new InitialLdapContext(hashEnv, null);
            SearchControls searchCtls = new SearchControls();
            searchCtls.setSearchScope(2);
            ctx.search(ldapCheckDto.getSearchBase(), ldapCheckDto.getSearchFilter(), searchCtls);
            result = true;
        }
        catch (Exception e) {
            result = false;
        }
        return result;
    }

    @Override
    public boolean linuxLDAPCheck(LDAPCheckDTO ldapCheckDto) {
        boolean result = false;
        Hashtable<String, String> hashEnv = new Hashtable<String, String>();
        hashEnv.put("java.naming.security.authentication", "simple");
        hashEnv.put("java.naming.security.principal", ldapCheckDto.getAdminName());
        hashEnv.put("java.naming.security.credentials", ldapCheckDto.getAdminPassword());
        hashEnv.put("java.naming.factory.initial", "com.sun.jndi.ldap.LdapCtxFactory");
        hashEnv.put("java.naming.provider.url", ldapCheckDto.getLdapURL() + ":" + ldapCheckDto.getProt() + "/" + ldapCheckDto.getSearchBase());
        try {
            InitialLdapContext ctx = new InitialLdapContext(hashEnv, null);
            SearchControls searchCtls = new SearchControls();
            searchCtls.setSearchScope(2);
            ctx.search(ldapCheckDto.getSearchBase(), ldapCheckDto.getSearchFilter(), searchCtls);
            result = true;
        }
        catch (Exception e) {
            result = false;
        }
        return result;
    }

    @Override
    public boolean ciscoLDAPCheck(LDAPCheckDTO ldapCheckDto) {
        boolean result = false;
        return result;
    }

    @Override
    public boolean otherLDAPCheck(LDAPCheckDTO ldapCheckDto) {
        boolean result = false;
        return result;
    }
}

