/*
 * Decompiled with CFR 0.152.
 */
package com.sinba.common.security.dao;

import com.sinba.common.dao.BaseDAOImplHibernate;
import com.sinba.common.dto.PageDTO;
import com.sinba.common.security.dao.IOrganizationDAO;
import com.sinba.common.security.dto.OrganizationQueryDTO;
import com.sinba.common.security.entity.Organization;
import com.sinba.common.util.StringUtils;
import java.util.List;
import org.hibernate.criterion.Criterion;
import org.hibernate.criterion.DetachedCriteria;
import org.hibernate.criterion.MatchMode;
import org.hibernate.criterion.Order;
import org.hibernate.criterion.Restrictions;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class OrganizationDAO
extends BaseDAOImplHibernate<Organization>
implements IOrganizationDAO {
    @Override
    public PageDTO findPager(OrganizationQueryDTO qdto) {
        DetachedCriteria dc = DetachedCriteria.forClass(Organization.class);
        int start = 0;
        int limit = 0;
        if (qdto != null) {
            start = qdto.getStart();
            limit = qdto.getLimit();
            if (StringUtils.hasText((String)qdto.getOrgName())) {
                dc.add((Criterion)Restrictions.like((String)"orgName", (String)qdto.getOrgName(), (MatchMode)MatchMode.ANYWHERE));
            }
            if (StringUtils.hasText((String)qdto.getOfficePhone())) {
                dc.add((Criterion)Restrictions.like((String)"officePhone", (String)qdto.getOfficePhone(), (MatchMode)MatchMode.ANYWHERE));
            }
            if (StringUtils.hasText((String)qdto.getAddress())) {
                dc.add((Criterion)Restrictions.like((String)"address", (String)qdto.getAddress(), (MatchMode)MatchMode.ANYWHERE));
            }
        }
        dc.add(Restrictions.in((String)"orgType", (Object[])new String[]{"company", "inner", "services"}));
        if (qdto.getSord() != null && !qdto.getSord().equals("") && qdto.getSidx() != null && !qdto.getSidx().equals("")) {
            if ("desc".equals(qdto.getSord())) {
                dc.addOrder(Order.desc((String)qdto.getSidx()));
            } else {
                dc.addOrder(Order.asc((String)qdto.getSidx()));
            }
        } else {
            dc.addOrder(Order.desc((String)"orgNo"));
        }
        return super.findPageByCriteria(dc, start, limit);
    }

    @Override
    public PageDTO findPagerByIds(OrganizationQueryDTO qdto) {
        DetachedCriteria dc = DetachedCriteria.forClass(Organization.class);
        int start = 0;
        int limit = 0;
        if (qdto != null && qdto.getOrgNos() != null) {
            start = qdto.getStart();
            limit = qdto.getLimit();
            dc.add(Restrictions.in((String)"orgNo", (Object[])qdto.getOrgNos()));
            return super.findPageByCriteria(dc, start, limit);
        }
        return null;
    }

    @Override
    public List<Organization> findByParent(Long parentNo) {
        String hql = " from Organization og where og.parentOrg.orgNo=" + parentNo;
        return super.getHibernateTemplate().find(hql);
    }
}

