/*
 * Decompiled with CFR 0.152.
 */
package com.sinba.common.security.dao;

import com.sinba.common.dao.BaseDAOImplHibernate;
import com.sinba.common.dto.PageDTO;
import com.sinba.common.security.dao.ISupplierDAO;
import com.sinba.common.security.dto.SupplierQueryDTO;
import com.sinba.common.security.entity.Supplier;
import com.sinba.common.util.StringUtils;
import java.util.List;
import org.hibernate.criterion.Criterion;
import org.hibernate.criterion.DetachedCriteria;
import org.hibernate.criterion.MatchMode;
import org.hibernate.criterion.Order;
import org.hibernate.criterion.Restrictions;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SupplierDAO
extends BaseDAOImplHibernate<Supplier>
implements ISupplierDAO {
    @Override
    public PageDTO findPager(SupplierQueryDTO qdto, String sidx, String sord) {
        DetachedCriteria dc = DetachedCriteria.forClass(Supplier.class);
        int start = 0;
        int limit = 0;
        if (qdto != null) {
            start = qdto.getStart();
            limit = qdto.getLimit();
            if (qdto.getCompanyNo() != null) {
                dc.createAlias("parentOrg", "par");
                dc.add((Criterion)Restrictions.eq((String)"par.orgNo", (Object)qdto.getCompanyNo()));
            }
            if (StringUtils.hasText((String)qdto.getOrgName())) {
                dc.add((Criterion)Restrictions.like((String)"orgName", (String)qdto.getOrgName(), (MatchMode)MatchMode.ANYWHERE));
            }
            if (StringUtils.hasText((String)qdto.getOfficePhone())) {
                dc.add((Criterion)Restrictions.like((String)"officePhone", (String)qdto.getOfficePhone(), (MatchMode)MatchMode.ANYWHERE));
            }
            if (StringUtils.hasText((String)qdto.getEmail())) {
                dc.add((Criterion)Restrictions.like((String)"email", (String)qdto.getEmail(), (MatchMode)MatchMode.ANYWHERE));
            }
            if (StringUtils.hasText((String)qdto.getAddress())) {
                dc.add((Criterion)Restrictions.like((String)"address", (String)qdto.getAddress(), (MatchMode)MatchMode.ANYWHERE));
            }
        }
        if (sord != null && !sord.equals("") && sidx != null && !sidx.equals("")) {
            if (sord.equals("desc")) {
                dc.addOrder(Order.desc((String)sidx));
            } else {
                dc.addOrder(Order.asc((String)sidx));
            }
        }
        return super.findPageByCriteria(dc, start, limit);
    }

    @Override
    public void delete(Long orgNo) {
        String hql = "delete from Supplier sp where sp.orgNo='" + orgNo + "'";
        this.getSessionFactory().getCurrentSession().createQuery(hql);
    }

    @Override
    public List<Supplier> findByCompanyNo(Long companyNo) {
        List suppliers = super.getHibernateTemplate().find(" from Supplier sp where sp.parentOrg.orgNo=" + companyNo);
        return suppliers;
    }
}

