/*
 * Decompiled with CFR 0.152.
 */
package com.sinba.common.security.dao;

import com.sinba.common.dao.BaseDAOImplHibernate;
import com.sinba.common.dto.PageDTO;
import com.sinba.common.security.dao.IUserDAO;
import com.sinba.common.security.dto.UserQueryDTO;
import com.sinba.common.security.entity.User;
import com.sinba.common.util.StringUtils;
import org.hibernate.criterion.Criterion;
import org.hibernate.criterion.DetachedCriteria;
import org.hibernate.criterion.MatchMode;
import org.hibernate.criterion.Order;
import org.hibernate.criterion.Restrictions;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class UserDAO
extends BaseDAOImplHibernate<User>
implements IUserDAO {
    @Override
    public PageDTO findPager(UserQueryDTO qdto, String sord, String sidx) {
        DetachedCriteria dc = DetachedCriteria.forClass(User.class);
        int start = 0;
        int limit = 0;
        if (qdto != null) {
            start = qdto.getStart();
            limit = qdto.getLimit();
            if (qdto.getOrgNo() > 0L) {
                dc.add(Restrictions.in((String)"orgnization.orgNo", (Object[])qdto.getOrgNos()));
            }
            if (StringUtils.hasText((String)qdto.getLoginName())) {
                dc.add((Criterion)Restrictions.like((String)"loginName", (String)qdto.getLoginName(), (MatchMode)MatchMode.ANYWHERE));
            }
            if (StringUtils.hasText((String)qdto.getFirstName())) {
                dc.add((Criterion)Restrictions.like((String)"firstName", (String)qdto.getFirstName(), (MatchMode)MatchMode.ANYWHERE));
            }
            if (StringUtils.hasText((String)qdto.getLastName())) {
                dc.add((Criterion)Restrictions.like((String)"lastName", (String)qdto.getLastName(), (MatchMode)MatchMode.ANYWHERE));
            }
            if (StringUtils.hasText((String)qdto.getEmail())) {
                dc.add((Criterion)Restrictions.like((String)"email", (String)qdto.getEmail(), (MatchMode)MatchMode.ANYWHERE));
            }
            if (StringUtils.hasText((String)qdto.getMobilePhone())) {
                dc.add((Criterion)Restrictions.like((String)"mobilePhone", (String)qdto.getMobilePhone(), (MatchMode)MatchMode.ANYWHERE));
            }
        }
        if (sord != null && !sord.equals("") && sidx != null && !sidx.equals("")) {
            if (sord.equals("desc")) {
                dc.addOrder(Order.desc((String)sidx));
            } else {
                dc.addOrder(Order.asc((String)sidx));
            }
        }
        return super.findPageByCriteria(dc, start, limit);
    }

    @Override
    public String findDisable(String userName, String pwd) {
        DetachedCriteria dc = DetachedCriteria.forClass(User.class);
        dc.add((Criterion)Restrictions.eq((String)"loginName", (Object)userName));
        dc.add((Criterion)Restrictions.eq((String)"password", (Object)pwd));
        dc.add((Criterion)Restrictions.or((Criterion)Restrictions.eq((String)"userState", (Object)false), (Criterion)Restrictions.eq((String)"dataFlag", (Object)Byte.parseByte("99"))));
        if (super.getHibernateTemplate().findByCriteria(dc) != null && super.getHibernateTemplate().findByCriteria(dc).size() > 0) {
            return "exist";
        }
        return "notexist";
    }
}

