/*
 * Decompiled with CFR 0.152.
 */
package com.sinba.common.security.entity;

import com.sinba.common.entity.BaseDomainEntity;
import com.sinba.common.security.entity.Role;
import com.sinba.common.security.entity.ServiceTime;
import com.sinba.common.security.entity.User;
import java.util.Set;
import javax.persistence.CascadeType;
import javax.persistence.Entity;
import javax.persistence.GeneratedValue;
import javax.persistence.GenerationType;
import javax.persistence.Id;
import javax.persistence.Inheritance;
import javax.persistence.InheritanceType;
import javax.persistence.JoinColumn;
import javax.persistence.ManyToOne;
import javax.persistence.OneToMany;
import javax.persistence.OneToOne;
import javax.persistence.Transient;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@Entity
@Inheritance(strategy=InheritanceType.JOINED)
public class Organization
extends BaseDomainEntity {
    private Long orgNo;
    private String orgName;
    private String address;
    private String email;
    private String officePhone;
    private String officeFax;
    private Set<User> users;
    private Organization parentOrg;
    private Set<Organization> suborgs;
    private User personInCharge;
    private Set<Role> orgRoles;
    private ServiceTime serviceTime;
    @Transient
    private String orgType;

    public String getOrgType() {
        return this.orgType;
    }

    public void setOrgType(String orgType) {
        this.orgType = orgType;
    }

    @ManyToOne
    @JoinColumn(name="personInChargeNo")
    public User getPersonInCharge() {
        return this.personInCharge;
    }

    public void setPersonInCharge(User personInCharge) {
        this.personInCharge = personInCharge;
    }

    @Id
    @GeneratedValue(strategy=GenerationType.AUTO)
    public Long getOrgNo() {
        return this.orgNo;
    }

    public void setOrgNo(Long orgNo) {
        this.orgNo = orgNo;
    }

    public String getOrgName() {
        return this.orgName;
    }

    public void setOrgName(String orgName) {
        this.orgName = orgName;
    }

    public String getAddress() {
        return this.address;
    }

    public void setAddress(String address) {
        this.address = address;
    }

    public String getEmail() {
        return this.email;
    }

    public void setEmail(String email) {
        this.email = email;
    }

    public String getOfficePhone() {
        return this.officePhone;
    }

    public void setOfficePhone(String officePhone) {
        this.officePhone = officePhone;
    }

    public String getOfficeFax() {
        return this.officeFax;
    }

    public void setOfficeFax(String officeFax) {
        this.officeFax = officeFax;
    }

    @OneToMany
    @JoinColumn(name="orgNo")
    public Set<User> getUsers() {
        return this.users;
    }

    public void setUsers(Set<User> users) {
        this.users = users;
    }

    @ManyToOne
    @JoinColumn(name="parentOrgNo")
    public Organization getParentOrg() {
        return this.parentOrg;
    }

    public void setParentOrg(Organization parentOrg) {
        this.parentOrg = parentOrg;
    }

    @OneToMany(mappedBy="parentOrg", cascade={CascadeType.REMOVE})
    @JoinColumn(name="parentOrgNo")
    public Set<Organization> getSuborgs() {
        return this.suborgs;
    }

    public void setSuborgs(Set<Organization> suborgs) {
        this.suborgs = suborgs;
    }

    @OneToMany
    public Set<Role> getOrgRoles() {
        return this.orgRoles;
    }

    public void setOrgRoles(Set<Role> orgRoles) {
        this.orgRoles = orgRoles;
    }

    @OneToOne
    @JoinColumn(name="serviceTimeNo")
    public ServiceTime getServiceTime() {
        return this.serviceTime;
    }

    public void setServiceTime(ServiceTime serviceTime) {
        this.serviceTime = serviceTime;
    }
}

