/*
 * Decompiled with CFR 0.152.
 */
package com.sinba.common.security.service;

import com.sinba.common.file.csv.CSVReader;
import com.sinba.common.file.csv.CSVWriter;
import com.sinba.common.security.dao.ICompanyDAO;
import com.sinba.common.security.dao.IRoleDAO;
import com.sinba.common.security.dao.IUserDAO;
import com.sinba.common.security.dto.CompanyDTO;
import com.sinba.common.security.dto.OrganizationDTO;
import com.sinba.common.security.entity.Company;
import com.sinba.common.security.entity.Organization;
import com.sinba.common.security.entity.Role;
import com.sinba.common.security.entity.User;
import com.sinba.common.security.service.ICompanyService;
import java.io.ByteArrayInputStream;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.io.StringWriter;
import java.io.Writer;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.transaction.annotation.Transactional;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class CompanyService
implements ICompanyService {
    @Autowired
    private ICompanyDAO companyDAO;
    @Autowired
    private IUserDAO userDAO;
    @Autowired
    private IRoleDAO roleDAO;

    @Override
    public List<CompanyDTO> findCompanyATree() {
        List<Company> entities = this.companyDAO.findATree();
        ArrayList<CompanyDTO> dtos = new ArrayList<CompanyDTO>();
        for (Company entity : entities) {
            CompanyDTO dto = new CompanyDTO();
            CompanyDTO.entity2dto((Object)((Object)entity), (Object)((Object)dto));
            dtos.add(dto);
        }
        return dtos;
    }

    @Override
    @Transactional
    public CompanyDTO findCompany() {
        Company entity = this.companyDAO.findCompany();
        CompanyDTO dto = new CompanyDTO();
        CompanyDTO.entity2dto((Object)((Object)entity), (Object)((Object)dto));
        if (entity.getPersonInCharge() != null) {
            dto.setPersonInChargeNo(entity.getPersonInCharge().getUserId());
            dto.setPersonInChargeName(entity.getPersonInCharge().getLoginName());
        }
        return dto;
    }

    @Override
    @Transactional
    public void saveCompany(OrganizationDTO dto) {
        Company com = new Company();
        com.setOrgName(dto.getOrgName());
        com.setOfficeFax(dto.getOfficeFax());
        com.setOfficePhone(dto.getOfficePhone());
        com.setAddress(dto.getAddress());
        com.setEmail(dto.getEmail());
        com.setHomePage(dto.getHomePage());
        com.setLogo(dto.getLogo());
        if (dto.getParentOrgNo() != null) {
            com.setParentOrg((Organization)((Object)this.companyDAO.findById(dto.getParentOrgNo())));
        }
        this.companyDAO.save((Object)com);
        dto.setOrgNo(com.getOrgNo());
    }

    @Override
    @Transactional
    public void mergeCompany(OrganizationDTO dto) {
        Company com = (Company)((Object)this.companyDAO.findById(dto.getOrgNo()));
        com.setOrgName(dto.getOrgName());
        com.setOfficeFax(dto.getOfficeFax());
        com.setOfficePhone(dto.getOfficePhone());
        com.setAddress(dto.getAddress());
        com.setEmail(dto.getEmail());
        com.setHomePage(dto.getHomePage());
        com.setLogo(dto.getLogo());
        if (dto.getOrgNo() != 1L && dto.getParentOrgNo() != null) {
            com.setParentOrg((Organization)((Object)this.companyDAO.findById(dto.getParentOrgNo())));
        }
        HashSet<Role> roles = new HashSet<Role>();
        if (dto.getOrgRole() != null) {
            for (Long id : dto.getOrgRole()) {
                Role role = (Role)((Object)this.roleDAO.findById(id));
                roles.add(role);
            }
        }
        com.setOrgRoles(roles);
        if (dto.getPersonInChargeNo() != null) {
            com.setPersonInCharge((User)((Object)this.userDAO.findById(dto.getPersonInChargeNo())));
        }
        this.companyDAO.merge((Object)com);
    }

    @Override
    @Transactional
    public void deleteCompany(Long orgNo) {
        this.companyDAO.delete(this.companyDAO.findById(orgNo));
    }

    @Override
    public Company findCompanyById(Long id) {
        return (Company)((Object)this.companyDAO.findById(id));
    }

    @Override
    public OrganizationDTO findById(Long id) {
        OrganizationDTO dto = new OrganizationDTO();
        Company entity = (Company)((Object)this.companyDAO.findById(id));
        if (entity != null) {
            OrganizationDTO.entity2dto((Object)((Object)entity), (Object)((Object)dto));
            if (entity.getParentOrg() != null) {
                dto.setParentOrgNo(entity.getParentOrg().getOrgNo());
            }
        }
        return dto;
    }

    @Override
    @Transactional
    public InputStream exportCompanyInfo() {
        ArrayList<String[]> data = new ArrayList<String[]>();
        data.add(new String[]{"CompanyName", "OfficePhone", "OfficeFax", "Email", "Address", "HomePage", "Logo"});
        Company company = this.companyDAO.findCompany();
        data.add(new String[]{company.getOrgName(), company.getOfficePhone(), company.getOfficeFax(), company.getEmail(), company.getAddress(), company.getHomePage(), company.getLogo()});
        StringWriter sw = new StringWriter();
        CSVWriter csvw = new CSVWriter((Writer)sw);
        csvw.writeAll(data);
        ByteArrayInputStream stream = new ByteArrayInputStream(sw.getBuffer().toString().getBytes());
        return stream;
    }

    @Override
    @Transactional
    public String importCompanyInfo(String importFile) {
        try {
            InputStreamReader rd = new InputStreamReader(new FileInputStream(importFile));
            CSVReader reader = new CSVReader((Reader)rd);
            String[] line = null;
            try {
                while ((line = reader.readNext()) != null) {
                    Company company = this.companyDAO.findCompany();
                    if (company == null) {
                        company = new Company();
                    }
                    company.setOrgName(line[0].toString());
                    company.setOfficePhone(line[1].toString());
                    company.setOfficeFax(line[2].toString());
                    company.setEmail(line[3].toString());
                    company.setAddress(line[4].toString());
                    company.setHomePage(line[5].toString());
                    company.setLogo(line[6].toString());
                    this.companyDAO.merge((Object)company);
                }
                return "Success";
            }
            catch (IOException e) {
                e.printStackTrace();
                return "IOError";
            }
        }
        catch (FileNotFoundException e1) {
            e1.printStackTrace();
            return "FileNotFound";
        }
    }
}

