/*
 * Decompiled with CFR 0.152.
 */
package com.sinba.common.security.service;

import com.sinba.common.dto.PageDTO;
import com.sinba.common.file.excel.ExcelUtil;
import com.sinba.common.security.dao.ICompanyDAO;
import com.sinba.common.security.dao.ICustomerDAO;
import com.sinba.common.security.dto.CustomerDTO;
import com.sinba.common.security.dto.CustomerQueryDTO;
import com.sinba.common.security.dto.OrganizationDTO;
import com.sinba.common.security.entity.Company;
import com.sinba.common.security.entity.Customer;
import com.sinba.common.security.entity.Organization;
import com.sinba.common.security.service.ICustomerService;
import java.io.File;
import java.io.FileInputStream;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.List;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.transaction.annotation.Transactional;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class CustomerService
implements ICustomerService {
    @Autowired
    private ICustomerDAO customerDAO;
    @Autowired
    private ICompanyDAO companyDAO;

    @Override
    public PageDTO findPagerCustomer(CustomerQueryDTO customerQueryDTO, String sidx, String sord) {
        PageDTO p = this.customerDAO.findPager(customerQueryDTO, sidx, sord);
        List entities = p.getData();
        ArrayList<CustomerDTO> dtos = new ArrayList<CustomerDTO>();
        for (Customer cus : entities) {
            CustomerDTO dto = new CustomerDTO();
            if (cus.getParentOrg() != null) {
                dto.setCompanyNo(cus.getParentOrg().getOrgNo());
            }
            CustomerDTO.entity2dto((Object)((Object)cus), (Object)((Object)dto));
            dtos.add(dto);
        }
        p.setData(dtos);
        return p;
    }

    @Override
    @Transactional
    public void saveCustomer(OrganizationDTO dto) {
        Customer customer = new Customer();
        customer.setOrgName(dto.getOrgName());
        customer.setOfficeFax(dto.getOfficeFax());
        customer.setOfficePhone(dto.getOfficePhone());
        customer.setEmail(dto.getEmail());
        customer.setAddress(dto.getAddress());
        if (dto.getParentOrgNo() != -1L) {
            Company company = (Company)((Object)this.companyDAO.findById(dto.getParentOrgNo()));
            customer.setParentOrg(company);
        }
        this.customerDAO.save((Object)customer);
        dto.setOrgNo(customer.getOrgNo());
    }

    @Override
    @Transactional
    public void saveCustomer(CustomerDTO dto) {
        Customer customer = new Customer();
        customer.setOrgName(dto.getOrgName());
        customer.setOfficeFax(dto.getOfficeFax());
        customer.setOfficePhone(dto.getOfficePhone());
        customer.setEmail(dto.getEmail());
        customer.setAddress(dto.getAddress());
        if (dto.getCompanyNo() != null) {
            Company company = (Company)((Object)this.companyDAO.findById(dto.getCompanyNo()));
            customer.setParentOrg(company);
        }
        this.customerDAO.save((Object)customer);
        dto.setOrgNo(customer.getOrgNo());
    }

    @Override
    @Transactional
    public void mergeCustomer(CustomerDTO dto) {
        Customer customer = (Customer)((Object)this.customerDAO.findById(dto.getOrgNo()));
        customer.setOrgName(dto.getOrgName());
        customer.setOfficeFax(dto.getOfficeFax());
        customer.setOfficePhone(dto.getOfficePhone());
        customer.setEmail(dto.getEmail());
        customer.setAddress(dto.getAddress());
        if (dto.getCompanyNo() != null) {
            customer.setParentOrg((Organization)((Object)this.companyDAO.findById(dto.getCompanyNo())));
        }
        this.customerDAO.merge((Object)customer);
    }

    @Override
    @Transactional
    public void mergeCustomer(OrganizationDTO dto) {
        Customer customer = (Customer)((Object)this.customerDAO.findById(dto.getOrgNo()));
        customer.setOrgName(dto.getOrgName());
        customer.setOfficeFax(dto.getOfficeFax());
        customer.setOfficePhone(dto.getOfficePhone());
        customer.setEmail(dto.getEmail());
        customer.setAddress(dto.getAddress());
        if (dto.getParentOrgNo() != -1L) {
            customer.setParentOrg((Organization)((Object)this.companyDAO.findById(dto.getParentOrgNo())));
        }
        this.customerDAO.merge((Object)customer);
    }

    @Override
    @Transactional
    public void deleteCustomer(Long orgNo) {
        this.customerDAO.delete(this.customerDAO.findById(orgNo));
    }

    @Override
    @Transactional
    public void deleteCustomer(Long[] orgNo) {
        this.customerDAO.deleteByIds(orgNo);
    }

    @Override
    @Transactional
    public Customer findCustomerById(Long id) {
        return (Customer)((Object)this.customerDAO.findById(id));
    }

    @Override
    @Transactional
    public CustomerDTO findById(Long id) {
        CustomerDTO dto = new CustomerDTO();
        Customer entity = (Customer)((Object)this.customerDAO.findById(id));
        CustomerDTO.entity2dto((Object)((Object)entity), (Object)((Object)dto));
        if (entity.getParentOrg() != null) {
            dto.setCompanyNo(entity.getParentOrg().getOrgNo());
        }
        return dto;
    }

    @Override
    @Transactional
    public InputStream exportCustomerItems(CustomerQueryDTO customerQueryDTO, String sidx, String sord) {
        String sheetName = "\u5ba2\u6237\u7ba1\u7406";
        String[] colNames = new String[]{"\u5ba2\u6237\u540d\u79f0", "\u5ba2\u6237\u7535\u8bdd", "\u8054\u7cfb\u90ae\u4ef6", "\u5ba2\u6237\u5730\u5740", "\u4f20\u771f\u53f7\u7801"};
        ArrayList<String[]> data = new ArrayList<String[]>();
        PageDTO p = this.customerDAO.findPager(customerQueryDTO, sidx, sord);
        if (p != null && p.getData() != null && p.getData().size() > 0) {
            List entities = p.getData();
            for (Customer item : entities) {
                this.convertChangeToStringArray(item, data);
            }
            try {
                return ExcelUtil.createSheetExcel((String)sheetName, (String[])colNames, data);
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
        return ExcelUtil.createSheetExcel((String)sheetName, (String[])colNames, data);
    }

    public void convertChangeToStringArray(Customer item, List<String[]> data) {
        CustomerDTO dto = new CustomerDTO();
        if (item.getParentOrg() != null) {
            dto.setCompanyNo(item.getParentOrg().getOrgNo());
        }
        CustomerDTO.entity2dto((Object)((Object)item), (Object)((Object)dto));
        data.add(new String[]{dto.getOrgName(), dto.getOfficePhone(), dto.getEmail(), dto.getAddress(), dto.getOfficeFax()});
    }

    @Override
    public Integer importCustomerItems(CustomerQueryDTO customerQueryDTO) {
        block8: {
            File importFile = customerQueryDTO.getImportFile();
            String sheetName = "\u5ba2\u6237\u7ba1\u7406";
            List data = null;
            try {
                data = ExcelUtil.readSheet((String)sheetName, (InputStream)new FileInputStream(importFile));
            }
            catch (Exception e) {
                return -1;
            }
            try {
                if (data == null || data.size() <= 0) break block8;
                int count = 0;
                try {
                    for (String[] rowData : data) {
                        CustomerDTO dto = new CustomerDTO();
                        dto.setOrgName(rowData[0].toString());
                        dto.setOfficePhone(rowData[1].toString());
                        dto.setEmail(rowData[2].toString());
                        dto.setAddress(rowData[3].toString());
                        dto.setOfficeFax(rowData[4].toString());
                        Customer entity = new Customer();
                        CustomerDTO.entity2dto((Object)((Object)dto), (Object)((Object)entity));
                        if (customerQueryDTO.getCompanyNo() != null) {
                            entity.setParentOrg((Organization)((Object)this.companyDAO.findById(customerQueryDTO.getCompanyNo())));
                        }
                        this.customerDAO.save((Object)entity);
                        ++count;
                    }
                }
                catch (Exception e) {
                    return -2;
                }
                return count;
            }
            catch (Exception e) {
                return -2;
            }
        }
        return 0;
    }
}

