/*
 * Decompiled with CFR 0.152.
 */
package com.sinba.common.security.service;

import com.sinba.common.dto.PageDTO;
import com.sinba.common.exception.ApplicationException;
import com.sinba.common.file.csv.CSVReader;
import com.sinba.common.file.csv.CSVWriter;
import com.sinba.common.security.dao.IFunctionDAO;
import com.sinba.common.security.dao.IOperationDAO;
import com.sinba.common.security.dto.FunctionDTO;
import com.sinba.common.security.dto.FunctionQueryDTO;
import com.sinba.common.security.dto.FunctionTreeDTO;
import com.sinba.common.security.entity.Function;
import com.sinba.common.security.entity.Operation;
import com.sinba.common.security.service.IFunctionService;
import java.io.ByteArrayInputStream;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.io.StringWriter;
import java.io.Writer;
import java.util.ArrayList;
import java.util.List;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.transaction.annotation.Transactional;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class FunctionService
implements IFunctionService {
    @Autowired
    private IFunctionDAO functionDAO;
    @Autowired
    private IOperationDAO operationDAO;

    @Override
    @Transactional
    public PageDTO findPagerFunction(FunctionQueryDTO functionQueryDTO) {
        PageDTO p = this.functionDAO.findPager(functionQueryDTO);
        List entities = p.getData();
        ArrayList<FunctionDTO> dtos = new ArrayList<FunctionDTO>();
        for (Function entity : entities) {
            FunctionDTO dto = new FunctionDTO();
            if (entity.getParentFunction() != null) {
                dto.setParentFunctionName(entity.getParentFunction().getResName());
                dto.setParentFunctionNo(entity.getParentFunction().getResNo());
            }
            FunctionDTO.entity2dto((Object)((Object)entity), (Object)((Object)dto));
            dtos.add(dto);
        }
        p.setData(dtos);
        return p;
    }

    @Override
    public List<FunctionDTO> findAllFunction() {
        List entities = this.functionDAO.findAll();
        ArrayList<FunctionDTO> dtos = new ArrayList<FunctionDTO>(entities.size());
        for (Function entity : entities) {
            FunctionDTO dto = new FunctionDTO();
            FunctionDTO.entity2dto((Object)((Object)entity), (Object)((Object)dto));
            dtos.add(dto);
        }
        return dtos;
    }

    @Override
    @Transactional
    public List<FunctionTreeDTO> findFunctionTreeDtos() {
        ArrayList<FunctionTreeDTO> dtos = new ArrayList<FunctionTreeDTO>();
        List<Function> entities = this.functionDAO.findRoots();
        for (Function func : entities) {
            if (func.getDataFlag() == 99) continue;
            FunctionTreeDTO dto = new FunctionTreeDTO();
            FunctionTreeDTO.entity2dto(func, dto);
            dtos.add(dto);
        }
        return dtos;
    }

    @Override
    @Transactional
    public void addFunction(FunctionDTO functionDto) {
        Function entity = new Function();
        FunctionDTO.dto2entity((Object)((Object)functionDto), (Object)((Object)entity));
        if (functionDto.getParentFunctionNo() != null) {
            Function parentFunction = (Function)((Object)this.functionDAO.findById(functionDto.getParentFunctionNo()));
            entity.setParentFunction(parentFunction);
        }
        this.functionDAO.save((Object)entity);
        functionDto.setResNo(entity.getResNo());
        String resUrl = functionDto.getResUrl();
        String resCode = functionDto.getResCode();
        if (resUrl != null) {
            if (resUrl.indexOf(".") != -1) {
                resUrl = resUrl.substring(0, resUrl.indexOf("."));
            }
        } else {
            resUrl = "";
        }
        if (resCode == null) {
            resCode = "";
        }
        Operation add = new Operation();
        add.setFunction(entity);
        add.setResName("\u589e\u52a0");
        add.setResCode(resCode + "AD");
        add.setResUrl(resUrl + "!add.action");
        add.setResIcon("add.png");
        this.operationDAO.save((Object)add);
        Operation delete = new Operation();
        delete.setFunction(entity);
        delete.setResName("\u5220\u9664");
        delete.setResCode(resCode + "DL");
        delete.setResUrl(resUrl + "!delete.action");
        delete.setResIcon("delete.png");
        this.operationDAO.save((Object)delete);
        Operation find = new Operation();
        find.setFunction(entity);
        find.setResName("\u67e5\u627e");
        find.setResCode(resCode + "SL");
        find.setResUrl(resUrl + "!find.action");
        find.setResIcon("find.png");
        this.operationDAO.save((Object)find);
        Operation edit = new Operation();
        edit.setFunction(entity);
        edit.setResName("\u7f16\u8f91");
        edit.setResCode(resCode + "ED");
        edit.setResUrl(resUrl + "!edit.action");
        edit.setResIcon("edit.png");
        this.operationDAO.save((Object)edit);
    }

    @Override
    @Transactional
    public void upadteFunction(FunctionDTO functionDto) {
        Function entity = (Function)((Object)this.functionDAO.findById(functionDto.getResNo()));
        if (functionDto.getResName() != null) {
            entity.setResName(functionDto.getResName());
        }
        if (functionDto.getResCode() != null) {
            entity.setResCode(functionDto.getResCode());
        }
        if (functionDto.getResIcon() != null) {
            entity.setResIcon(functionDto.getResIcon());
        }
        if (functionDto.getResUrl() != null) {
            entity.setResUrl(functionDto.getResUrl());
        }
        if (functionDto.getParentFunctionNo() != null && !functionDto.getParentFunctionNo().equals("0") && !functionDto.getParentFunctionNo().equals("")) {
            Function parent = (Function)((Object)this.functionDAO.findById(functionDto.getParentFunctionNo()));
            entity.setParentFunction(parent);
        }
        this.functionDAO.merge((Object)entity);
    }

    @Override
    @Transactional
    public boolean deleteFunction(Long resNo) {
        Boolean result = true;
        Byte delete = 1;
        Function entity = (Function)((Object)this.functionDAO.findById(resNo));
        if (entity.getDataFlag().toString().equals(delete.toString())) {
            result = false;
        }
        if (result.booleanValue()) {
            this.functionDAO.delete((Object)entity);
        }
        return result;
    }

    @Override
    @Transactional
    public boolean deleteFunction(Long[] resNos) {
        Boolean result = true;
        Byte delete = 1;
        for (Long id : resNos) {
            Function function = (Function)((Object)this.functionDAO.findById(id));
            if (!function.getDataFlag().toString().equals(delete.toString())) continue;
            result = false;
        }
        if (result.booleanValue()) {
            this.functionDAO.deleteByIds(resNos);
        }
        return result;
    }

    @Override
    @Transactional
    public FunctionDTO copyFunction(Long resNo, Long parentFunctionNo) {
        Function newFunction = new Function();
        Function sourceFunction = (Function)((Object)this.functionDAO.findById(resNo));
        Function parentFunction = (Function)((Object)this.functionDAO.findById(parentFunctionNo));
        newFunction.setResName(sourceFunction.getResName());
        newFunction.setParentFunction(parentFunction);
        this.functionDAO.save((Object)newFunction);
        FunctionDTO dto = new FunctionDTO();
        if (newFunction != null) {
            FunctionDTO.entity2dto((Object)((Object)newFunction), (Object)((Object)dto));
        }
        if (newFunction.getParentFunction() != null) {
            dto.setParentFunctionNo(newFunction.getParentFunction().getResNo());
            dto.setParentFunctionName(newFunction.getParentFunction().getResName());
        }
        return dto;
    }

    @Override
    @Transactional
    public void cutFunction(Long resNo, Long parentFunctionNo) {
        Function sourceFunction = (Function)((Object)this.functionDAO.findById(resNo));
        if (parentFunctionNo == -1L) {
            sourceFunction.setParentFunction(null);
        } else {
            Function parentFunction = (Function)((Object)this.functionDAO.findById(parentFunctionNo));
            sourceFunction.setParentFunction(parentFunction);
        }
        this.functionDAO.merge((Object)sourceFunction);
    }

    @Override
    public Boolean findFunctionExist(FunctionQueryDTO qdto) {
        return this.functionDAO.findExist(qdto);
    }

    @Override
    @Transactional
    public FunctionDTO findById(Long resNo) {
        FunctionDTO dto = new FunctionDTO();
        Function entity = (Function)((Object)this.functionDAO.findById(resNo));
        if (entity != null) {
            FunctionDTO.entity2dto((Object)((Object)entity), (Object)((Object)dto));
        }
        if (entity.getParentFunction() != null) {
            dto.setParentFunctionNo(entity.getParentFunction().getResNo());
            dto.setParentFunctionName(entity.getParentFunction().getResName());
        }
        return dto;
    }

    @Override
    @Transactional
    public InputStream exportFunction(FunctionQueryDTO qdto) {
        ArrayList<String[]> data = new ArrayList<String[]>();
        data.add(new String[]{"functionNo", "functionName", "functionCode", "functionUrl", "functionIcon", "parentFunctionNo"});
        qdto.setSord("asc");
        qdto.setSidx("resNo");
        PageDTO p = this.functionDAO.findPager(qdto);
        List entities = p.getData();
        String parentFunctionNo = "";
        for (Function func : entities) {
            if (func.getParentFunction() != null) {
                parentFunctionNo = func.getParentFunction().getResNo() + "";
            }
            data.add(new String[]{func.getResNo() + "", func.getResName(), func.getResCode() + "", func.getResUrl(), func.getResIcon(), parentFunctionNo});
        }
        StringWriter sw = new StringWriter();
        CSVWriter csvw = new CSVWriter((Writer)sw);
        csvw.writeAll(data);
        ByteArrayInputStream stream = new ByteArrayInputStream(sw.getBuffer().toString().getBytes());
        return stream;
    }

    @Override
    @Transactional
    public String importFunction(String filePath) {
        try {
            InputStreamReader rd = new InputStreamReader(new FileInputStream(filePath));
            CSVReader reader = new CSVReader((Reader)rd);
            String[] line = null;
            while ((line = reader.readNext()) != null) {
                Function func = new Function();
                func.setResNo(Long.parseLong(line[0].toString()));
                func.setResName(line[1].toString());
                func.setResCode(line[2].toString());
                func.setResUrl(line[3].toString());
                func.setResIcon(line[4].toString());
                if (line[5].toString() != null && !"".equals(line[5].toString().trim())) {
                    func.setParentFunction(this.getFunctionByFunctionNoStr(line[5].toString()));
                }
                this.functionDAO.save((Object)func);
                System.out.println(":::::::::::::::::::::::::\u4fdd\u5b58\u540e\u7684\u7f16\u53f7\uff1a" + func.getResNo());
            }
            return "Success";
        }
        catch (FileNotFoundException ex) {
            throw new ApplicationException("ERROR_CSV_FILE_NOT_EXISTS\n" + ex);
        }
        catch (IOException ex) {
            throw new ApplicationException("ERROR_CSV_FILE_IO\n" + ex);
        }
    }

    @Override
    @Transactional
    public Function getFunctionByFunctionNoStr(String functionNoStr) {
        System.out.println(":::::::::::::::::::::::::::::" + functionNoStr);
        try {
            Long parentResNo = Long.parseLong(functionNoStr);
            Function func = (Function)((Object)this.functionDAO.findById(parentResNo));
            if (func == null) {
                System.out.println(":::::::::::::::::ERROR_NULL_PARENT_FUNCTION");
                throw new ApplicationException("ERROR_NULL_PARENT_FUNCTION");
            }
            return func;
        }
        catch (NumberFormatException ex) {
            System.out.println(":::::::::::::::::ERROR_NUMBERFORMAT");
            throw new ApplicationException("ERROR_NUMBERFORMAT\n" + ex);
        }
    }
}

