/*
 * Decompiled with CFR 0.152.
 */
package com.sinba.common.security.service;

import com.sinba.common.dto.PageDTO;
import com.sinba.common.security.dao.IHolidayDAO;
import com.sinba.common.security.dao.IOrganizationDAO;
import com.sinba.common.security.dto.HolidayDTO;
import com.sinba.common.security.dto.HolidayQueryDTO;
import com.sinba.common.security.entity.Holiday;
import com.sinba.common.security.entity.Organization;
import com.sinba.common.security.service.IHolidayService;
import java.util.ArrayList;
import java.util.GregorianCalendar;
import java.util.List;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.transaction.annotation.Transactional;

public class HolidayService
implements IHolidayService {
    @Autowired
    private IHolidayDAO holidayDAO;
    @Autowired
    private IOrganizationDAO organizationDAO;

    @Transactional
    public PageDTO findHolidayPager(HolidayQueryDTO qdto) {
        PageDTO p = this.holidayDAO.findHolidayPage(qdto);
        List entities = p.getData();
        ArrayList<HolidayDTO> dtos = new ArrayList<HolidayDTO>();
        for (Holiday ho : entities) {
            HolidayDTO dto = new HolidayDTO();
            HolidayDTO.entity2dto((Object)((Object)ho), (Object)((Object)dto));
            dtos.add(dto);
        }
        p.setData(dtos);
        return p;
    }

    @Transactional
    public Long[] addHoliday(HolidayDTO holidayDTO) {
        Long startTime = holidayDTO.getHdate().getTime() - 86400000L;
        Long endTime = holidayDTO.getHdate().getTime() + 86400000L;
        if (holidayDTO.getHedate() != null) {
            endTime = holidayDTO.getHedate().getTime();
        }
        int day = (int)(endTime - startTime) / 86400000;
        GregorianCalendar c1 = new GregorianCalendar();
        c1.setTimeInMillis(startTime);
        Organization os = (Organization)((Object)this.organizationDAO.findById(holidayDTO.getOrgNo()));
        Long[] hids = new Long[day];
        for (int i = 0; i < day; ++i) {
            c1.set(5, c1.get(5) + 1);
            Holiday holiday = new Holiday();
            holiday.setHdate(c1.getTime());
            holiday.setHdesc(holidayDTO.getHdesc());
            holiday.setOrganization(os);
            this.holidayDAO.save((Object)holiday);
            hids[i] = holiday.getHid();
        }
        return hids;
    }

    @Transactional
    public void updateHoliday(HolidayDTO holidayDTO) {
        if (holidayDTO.getHid() != null) {
            Holiday holiday = (Holiday)((Object)this.holidayDAO.findById(holidayDTO.getHid()));
            HolidayDTO.dto2entity((Object)((Object)holidayDTO), (Object)((Object)holiday));
            this.holidayDAO.update((Object)holiday);
        }
    }

    @Transactional
    public void deteleHoliday(Long[] hids) {
        this.holidayDAO.deleteByIds(hids);
    }

    @Transactional
    public HolidayDTO findById(Long hid) {
        HolidayDTO dto = new HolidayDTO();
        Holiday entity = (Holiday)((Object)this.holidayDAO.findById(hid));
        if (entity != null) {
            HolidayDTO.entity2dto((Object)((Object)entity), (Object)((Object)dto));
        }
        if (entity.getOrganization() != null) {
            dto.setOrgNo(entity.getOrganization().getOrgNo());
        }
        return dto;
    }
}

