/*
 * Decompiled with CFR 0.152.
 */
package com.sinba.common.security.service;

import com.sinba.common.dto.PageDTO;
import com.sinba.common.security.dao.ILDAPDAO;
import com.sinba.common.security.dao.IOrganizationDAO;
import com.sinba.common.security.dao.IUserDAO;
import com.sinba.common.security.dto.LDAPCheckDTO;
import com.sinba.common.security.dto.LDAPDTO;
import com.sinba.common.security.dto.LDAPQueryDTO;
import com.sinba.common.security.dto.UserDTO;
import com.sinba.common.security.entity.LDAP;
import com.sinba.common.security.entity.Organization;
import com.sinba.common.security.entity.Role;
import com.sinba.common.security.entity.User;
import com.sinba.common.security.service.ILDAPService;
import com.sinba.common.security.service.IUserInfoService;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import org.springframework.transaction.annotation.Transactional;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class LDAPService
implements ILDAPService {
    private ILDAPDAO ldapDAO;
    private IUserDAO userDAO;
    private IUserInfoService userInfoService;
    private IOrganizationDAO organizationDAO;

    public ILDAPDAO getLdapDAO() {
        return this.ldapDAO;
    }

    public void setLdapDAO(ILDAPDAO ldapDAO) {
        this.ldapDAO = ldapDAO;
    }

    public IUserDAO getUserDAO() {
        return this.userDAO;
    }

    public void setUserDAO(IUserDAO userDAO) {
        this.userDAO = userDAO;
    }

    public IUserInfoService getUserInfoService() {
        return this.userInfoService;
    }

    public void setUserInfoService(IUserInfoService userInfoService) {
        this.userInfoService = userInfoService;
    }

    public IOrganizationDAO getOrganizationDAO() {
        return this.organizationDAO;
    }

    public void setOrganizationDAO(IOrganizationDAO organizationDAO) {
        this.organizationDAO = organizationDAO;
    }

    @Override
    public void saveLdap(LDAPDTO ldapDto) {
        LDAP ldap = new LDAP();
        LDAPDTO.dto2entity((Object)((Object)ldapDto), (Object)((Object)ldap));
        this.ldapDAO.save((Object)ldap);
    }

    @Override
    @Transactional
    public void deleteLdap(Long[] ldapIds) {
        this.ldapDAO.deleteByIds(ldapIds);
    }

    @Override
    public void mergeLdap(LDAPDTO ldapDto) {
        LDAP ldap = new LDAP();
        LDAPDTO.dto2entity((Object)((Object)ldapDto), (Object)((Object)ldap));
        this.ldapDAO.merge((Object)ldap);
    }

    @Override
    public PageDTO findPagerLdap(LDAPQueryDTO queryDto) {
        PageDTO p = this.ldapDAO.findPager(queryDto);
        List entities = p.getData();
        ArrayList<LDAPDTO> dtos = new ArrayList<LDAPDTO>(entities.size());
        for (LDAP entity : entities) {
            LDAPDTO dto = new LDAPDTO();
            UserDTO.entity2dto((Object)((Object)entity), (Object)((Object)dto));
            dtos.add(dto);
        }
        p.setData(dtos);
        return p;
    }

    @Override
    @Transactional
    public PageDTO getAllLdap(int page, int rows, long ldapId) {
        PageDTO pageDto = new PageDTO();
        List<Object> userDtoList = new ArrayList();
        ArrayList<UserDTO> userDtoLists = new ArrayList<UserDTO>();
        if (ldapId != 0L) {
            LDAPDTO ldapDto = this.getLDAPById(ldapId);
            if (ldapDto.getLdapType().equals("Microsoft AD(Active Directory)")) {
                userDtoList = this.ldapDAO.microsoftLDAP(ldapDto);
            }
            if (ldapDto.getLdapType().equals("Novell eDirectory")) {
                userDtoList = this.ldapDAO.ciscoLDAP(ldapDto);
            }
            if (ldapDto.getLdapType().equals("OpenLDAP")) {
                userDtoList = this.ldapDAO.linuxLDAP(ldapDto);
            }
            if (ldapDto.getLdapType().equals("other")) {
                userDtoList = this.ldapDAO.otherLDAP(ldapDto);
            }
            int totalSize = userDtoList.size();
            int total = totalSize / rows;
            if (totalSize % rows != 0) {
                ++total;
            }
            int start = (page - 1) * rows;
            int end = rows * page;
            if (end > totalSize) {
                end = totalSize;
            }
            for (int i = start; i < end; ++i) {
                UserDTO userDto = (UserDTO)((Object)userDtoList.get(i));
                userDtoLists.add(userDto);
            }
            pageDto.setPage(page);
            pageDto.setRows(rows);
            pageDto.setTotal(total);
            pageDto.setData(userDtoLists);
            pageDto.setTotalSize(totalSize);
        }
        return pageDto;
    }

    @Override
    @Transactional
    public boolean adUserImport(UserDTO userDto) {
        boolean result = false;
        User user = (User)((Object)this.userDAO.findUniqueBy("loginName", userDto.getLoginName()));
        if (user == null) {
            this.userInfoService.saveUser(userDto);
            result = true;
        } else {
            result = false;
            user.setEmail(userDto.getEmail());
            user.setFirstName(userDto.getFirstName());
            user.setLastName(userDto.getLastName());
            user.setFax(userDto.getFax());
            user.setMoblie(userDto.getMoblie());
            user.setPhone(userDto.getPhone());
            user.setUserState(userDto.isUserState());
            if (userDto.getOrgNo() > 0L) {
                Organization org = new Organization();
                org = (Organization)((Object)this.organizationDAO.findById(Long.valueOf(userDto.getOrgNo())));
                user.setOrgnization(org);
            }
            HashSet<Role> roles = new HashSet();
            roles = this.userInfoService.getRoleByIds(userDto.getRoleIds());
            user.setRoles(roles);
            this.userDAO.merge((Object)user);
        }
        return result;
    }

    @Override
    public List<LDAPDTO> getLDAPAll() {
        List ldapList = this.ldapDAO.findAll();
        ArrayList<LDAPDTO> dtos = new ArrayList<LDAPDTO>(ldapList.size());
        for (LDAP entity : ldapList) {
            LDAPDTO ldapDto = new LDAPDTO();
            LDAPDTO.entity2dto((Object)((Object)entity), (Object)((Object)ldapDto));
            dtos.add(ldapDto);
        }
        return dtos;
    }

    @Override
    public LDAPDTO getLDAPById(long ldapId) {
        LDAPDTO ldapDto = new LDAPDTO();
        LDAP ldap = (LDAP)((Object)this.ldapDAO.findById(Long.valueOf(ldapId)));
        LDAPDTO.entity2dto((Object)((Object)ldap), (Object)((Object)ldapDto));
        return ldapDto;
    }

    @Override
    public boolean ldapAuthentication(String userName, String password) {
        boolean result = false;
        List<LDAPDTO> ldapDtos = this.getLDAPAll();
        result = this.ldapDAO.ldapAuthentication(ldapDtos, userName, password);
        return result;
    }

    @Override
    public boolean ldapConfigCheck(LDAPCheckDTO ldapCheckDto) {
        boolean result = false;
        if (ldapCheckDto.getLdapURL() != null && ldapCheckDto.getProt() != null && ldapCheckDto.getAdminName() != null && ldapCheckDto.getAdminPassword() != null && ldapCheckDto.getLdapType() != null && ldapCheckDto.getSearchBase() != null && ldapCheckDto.getSearchFilter() != null) {
            try {
                if (ldapCheckDto.getLdapType().equals("Microsoft AD(Active Directory)")) {
                    result = this.ldapDAO.microsoftLDAPCheck(ldapCheckDto);
                }
                if (ldapCheckDto.getLdapType().equals("Novell eDirectory")) {
                    result = this.ldapDAO.ciscoLDAPCheck(ldapCheckDto);
                }
                if (ldapCheckDto.getLdapType().equals("OpenLDAP")) {
                    result = this.ldapDAO.linuxLDAPCheck(ldapCheckDto);
                }
                if (ldapCheckDto.getLdapType().equals("other")) {
                    result = this.ldapDAO.otherLDAPCheck(ldapCheckDto);
                }
            }
            catch (Exception e) {
                result = false;
            }
        }
        return result;
    }
}

