/*
 * Decompiled with CFR 0.152.
 */
package com.sinba.common.security.service;

import com.sinba.common.security.dao.IResourceDAO;
import com.sinba.common.security.entity.Resource;
import com.sinba.common.security.entity.Role;
import java.util.Collection;
import java.util.Set;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.security.core.Authentication;
import org.springframework.security.core.GrantedAuthority;
import org.springframework.security.web.access.WebInvocationPrivilegeEvaluator;
import org.springframework.transaction.annotation.Transactional;

public class MyWebInvocationPrivilegeEvaluator
implements WebInvocationPrivilegeEvaluator {
    @Autowired
    private IResourceDAO resourceDAO;

    @Transactional
    public boolean isAllowed(String uri, Authentication authentication) {
        Resource resource = this.resourceDAO.findByResUrl(uri);
        Boolean isAllowed = false;
        if (resource == null) {
            isAllowed = true;
        } else {
            Set<Role> roles = resource.getRoles();
            Collection authorities = authentication.getAuthorities();
            for (GrantedAuthority ga : authorities) {
                String authority = ga.getAuthority();
                for (Role role : roles) {
                    String roleCode = role.getRoleCode();
                    if (!roleCode.equals(authority)) continue;
                    return true;
                }
            }
        }
        return isAllowed;
    }

    public boolean isAllowed(String contextPath, String uri, String method, Authentication authentication) {
        return this.isAllowed(uri, authentication);
    }
}

