/*
 * Decompiled with CFR 0.152.
 */
package com.sinba.common.security.service;

import com.sinba.common.dto.PageDTO;
import com.sinba.common.exception.ApplicationException;
import com.sinba.common.file.csv.CSVReader;
import com.sinba.common.file.csv.CSVWriter;
import com.sinba.common.security.dao.IFunctionDAO;
import com.sinba.common.security.dao.IOperationDAO;
import com.sinba.common.security.dto.OperationDTO;
import com.sinba.common.security.dto.OperationQueryDTO;
import com.sinba.common.security.entity.Function;
import com.sinba.common.security.entity.Operation;
import com.sinba.common.security.service.IFunctionService;
import com.sinba.common.security.service.IOperationService;
import java.io.ByteArrayInputStream;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.io.StringWriter;
import java.io.Writer;
import java.util.ArrayList;
import java.util.List;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.transaction.annotation.Transactional;

public class OperationService
implements IOperationService {
    @Autowired
    private IOperationDAO operationDAO;
    @Autowired
    private IFunctionDAO functionDAO;
    @Autowired
    private IFunctionService functionService;

    public PageDTO findPagerOperation(OperationQueryDTO operationQueryDTO) {
        PageDTO p = this.operationDAO.findPager(operationQueryDTO);
        List entities = p.getData();
        ArrayList<OperationDTO> dtos = new ArrayList<OperationDTO>(entities.size());
        for (Operation entity : entities) {
            OperationDTO dto = new OperationDTO();
            OperationDTO.entity2dto((Object)((Object)entity), (Object)((Object)dto));
            dtos.add(dto);
        }
        p.setData(dtos);
        return p;
    }

    @Transactional
    public void addOperation(OperationDTO operationDTO) {
        Operation entity = new Operation();
        OperationDTO.dto2entity((Object)((Object)operationDTO), (Object)((Object)entity));
        if (operationDTO.getFunctionNo() != null) {
            Function function = (Function)((Object)this.functionDAO.findById(operationDTO.getFunctionNo()));
            entity.setFunction(function);
        }
        this.operationDAO.save((Object)entity);
        operationDTO.setResNo(entity.getResNo());
    }

    @Transactional
    public void upadteOperation(OperationDTO operationDto) {
        Operation entity = (Operation)((Object)this.operationDAO.findById(operationDto.getResNo()));
        if (operationDto.getResName() != null) {
            entity.setResName(operationDto.getResName());
        }
        if (operationDto.getResCode() != null) {
            entity.setResCode(operationDto.getResCode());
        }
        if (operationDto.getResIcon() != null) {
            entity.setResIcon(operationDto.getResIcon());
        }
        if (operationDto.getResUrl() != null) {
            entity.setResUrl(operationDto.getResUrl());
        }
        this.operationDAO.merge((Object)entity);
    }

    @Transactional
    public Boolean deleteOperation(Long resNo) {
        Boolean result = true;
        Byte delete = 1;
        Operation entity = (Operation)((Object)this.operationDAO.findById(resNo));
        if (entity.getDataFlag().toString().equals(delete.toString())) {
            result = false;
        }
        if (result.booleanValue()) {
            this.operationDAO.delete((Object)entity);
        }
        return result;
    }

    @Transactional
    public Boolean deleteOperations(Long[] resNos) {
        Boolean result = true;
        Byte delete = 1;
        for (Long id : resNos) {
            Operation opt = (Operation)((Object)this.operationDAO.findById(id));
            if (!opt.getDataFlag().toString().equals(delete.toString())) continue;
            result = false;
        }
        if (result.booleanValue()) {
            this.operationDAO.deleteByIds(resNos);
        }
        return result;
    }

    public Boolean findOperationExist(OperationQueryDTO qdto) {
        return this.operationDAO.findExist(qdto);
    }

    @Transactional
    public OperationDTO findById(Long resNo) {
        OperationDTO dto = new OperationDTO();
        Operation entity = (Operation)((Object)this.operationDAO.findById(resNo));
        if (entity != null) {
            OperationDTO.entity2dto((Object)((Object)entity), (Object)((Object)dto));
        }
        return dto;
    }

    @Transactional
    public InputStream exportOperation(OperationQueryDTO qdto) {
        ArrayList<String[]> data = new ArrayList<String[]>();
        data.add(new String[]{"operationNo", "operationName", "operationCode", "operationUrl", "operationIcon", "functionNo"});
        qdto.setSord("asc");
        qdto.setSidx("resNo");
        PageDTO p = this.operationDAO.findPager(qdto);
        List entities = p.getData();
        String functionNo = "";
        for (Operation op : entities) {
            if (op.getFunction() != null) {
                functionNo = op.getFunction().getResNo() + "";
            }
            data.add(new String[]{op.getResNo() + "", op.getResName(), op.getResCode() + "", op.getResUrl(), op.getResIcon(), functionNo});
        }
        StringWriter sw = new StringWriter();
        CSVWriter csvw = new CSVWriter((Writer)sw);
        csvw.writeAll(data);
        ByteArrayInputStream stream = new ByteArrayInputStream(sw.getBuffer().toString().getBytes());
        return stream;
    }

    @Transactional
    public String importOperation(String filePath) {
        try {
            InputStreamReader rd = new InputStreamReader(new FileInputStream(filePath));
            CSVReader reader = new CSVReader((Reader)rd);
            String[] line = null;
            while ((line = reader.readNext()) != null) {
                Operation op = new Operation();
                op.setResNo(Long.parseLong(line[0].toString()));
                op.setResName(line[1].toString());
                op.setResCode(line[2].toString());
                op.setResUrl(line[3].toString());
                op.setResIcon(line[4].toString());
                if (line[5].toString() != null && !"".equals(line[5].toString().trim())) {
                    op.setFunction(this.functionService.getFunctionByFunctionNoStr(line[5].toString()));
                }
                this.operationDAO.save((Object)op);
            }
            return "Success";
        }
        catch (FileNotFoundException ex) {
            throw new ApplicationException("ERROR_CSV_FILE_NOT_EXISTS\n" + ex);
        }
        catch (IOException ex) {
            throw new ApplicationException("ERROR_CSV_FILE_IO\n" + ex);
        }
    }
}

