/*
 * Decompiled with CFR 0.152.
 */
package com.sinba.common.security.service;

import com.sinba.common.jbpm.JbpmFacade;
import com.sinba.common.security.dao.IOrganizationDAO;
import com.sinba.common.security.dao.IOrganizationInnerDAO;
import com.sinba.common.security.dao.IRoleDAO;
import com.sinba.common.security.dao.IUserDAO;
import com.sinba.common.security.dto.OrganizationDTO;
import com.sinba.common.security.entity.Organization;
import com.sinba.common.security.entity.OrganizationInner;
import com.sinba.common.security.entity.Role;
import com.sinba.common.security.entity.User;
import com.sinba.common.security.service.IOrganizationInnerService;
import com.sinba.common.security.service.IUserInfoService;
import java.util.HashSet;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.transaction.annotation.Transactional;

public class OrganizationInnerService
implements IOrganizationInnerService {
    @Autowired
    private IOrganizationInnerDAO organizationInnerDAO;
    @Autowired
    private IOrganizationDAO organizationDAO;
    @Autowired
    private IUserDAO userDAO;
    private JbpmFacade jbpmFacade;
    private IUserInfoService userInfoService;
    @Autowired
    private IRoleDAO roleDAO;

    public IUserInfoService getUserInfoService() {
        return this.userInfoService;
    }

    public void setUserInfoService(IUserInfoService userInfoService) {
        this.userInfoService = userInfoService;
    }

    public JbpmFacade getJbpmFacade() {
        return this.jbpmFacade;
    }

    public void setJbpmFacade(JbpmFacade jbpmFacade) {
        this.jbpmFacade = jbpmFacade;
    }

    @Transactional
    public void saveOrganizationInner(OrganizationDTO dto) {
        Organization org;
        OrganizationInner inner = new OrganizationInner();
        inner.setOrgName(dto.getOrgName());
        inner.setOfficeFax(dto.getOfficeFax());
        inner.setOfficePhone(dto.getOfficePhone());
        inner.setEmail(dto.getEmail());
        inner.setAddress(dto.getAddress());
        if (dto.getParentOrgNo() != null && (org = (Organization)((Object)this.organizationDAO.findById(dto.getParentOrgNo()))) != null) {
            inner.setParentOrg(org);
        }
        if (dto.getPersonInChargeNo() != null) {
            inner.setPersonInCharge((User)((Object)this.userDAO.findById(dto.getPersonInChargeNo())));
        }
        this.organizationInnerDAO.save((Object)inner);
        dto.setOrgNo(inner.getOrgNo());
    }

    @Transactional
    public void mergeOrganizationInner(OrganizationDTO dto) {
        OrganizationInner inner = (OrganizationInner)((Object)this.organizationInnerDAO.findById(dto.getOrgNo()));
        inner.setOrgName(dto.getOrgName());
        inner.setOfficeFax(dto.getOfficeFax());
        inner.setOfficePhone(dto.getOfficePhone());
        inner.setEmail(dto.getEmail());
        inner.setAddress(dto.getAddress());
        if (dto.getParentOrgNo() != -1L) {
            inner.setParentOrg((Organization)((Object)this.organizationDAO.findById(dto.getParentOrgNo())));
        }
        if (dto.getPersonInChargeNo() != null) {
            inner.setPersonInCharge((User)((Object)this.userDAO.findById(dto.getPersonInChargeNo())));
        }
        HashSet<Role> roles = new HashSet<Role>();
        if (dto.getOrgRole() != null) {
            for (Long id : dto.getOrgRole()) {
                Role role = (Role)((Object)this.roleDAO.findById(id));
                roles.add(role);
            }
        }
        inner.setOrgRoles(roles);
        this.organizationInnerDAO.merge((Object)inner);
    }

    @Transactional
    public void deleteOrganizationInner(Long orgNo) {
        this.organizationInnerDAO.delete(this.organizationInnerDAO.findById(orgNo));
    }

    public OrganizationInner findOrganizationInnerById(Long id) {
        return (OrganizationInner)((Object)this.organizationInnerDAO.findById(id));
    }

    public OrganizationDTO findById(Long id) {
        OrganizationDTO dto = new OrganizationDTO();
        OrganizationInner entity = (OrganizationInner)((Object)this.organizationInnerDAO.findById(id));
        if (entity != null) {
            OrganizationDTO.entity2dto((Object)((Object)entity), (Object)((Object)dto));
            if (entity.getParentOrg() != null) {
                dto.setParentOrgNo(entity.getParentOrg().getOrgNo());
            }
        }
        return dto;
    }
}

