/*
 * Decompiled with CFR 0.152.
 */
package com.sinba.common.security.service;

import com.sinba.common.dto.PageDTO;
import com.sinba.common.exception.ApplicationException;
import com.sinba.common.file.csv.CSVReader;
import com.sinba.common.file.csv.CSVWriter;
import com.sinba.common.security.dao.ICompanyDAO;
import com.sinba.common.security.dao.ICustomerDAO;
import com.sinba.common.security.dao.IOrganizationDAO;
import com.sinba.common.security.dao.IOrganizationInnerDAO;
import com.sinba.common.security.dao.IOrganizationServicesDAO;
import com.sinba.common.security.dao.IRoleDAO;
import com.sinba.common.security.dao.ISupplierDAO;
import com.sinba.common.security.dao.IUserDAO;
import com.sinba.common.security.dto.OrganizationDTO;
import com.sinba.common.security.dto.OrganizationGridDTO;
import com.sinba.common.security.dto.OrganizationQueryDTO;
import com.sinba.common.security.dto.OrganizationTreeDTO;
import com.sinba.common.security.entity.Company;
import com.sinba.common.security.entity.Organization;
import com.sinba.common.security.entity.OrganizationInner;
import com.sinba.common.security.entity.OrganizationServices;
import com.sinba.common.security.entity.Role;
import com.sinba.common.security.entity.User;
import com.sinba.common.security.service.IOrganizationService;
import java.io.ByteArrayInputStream;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.io.StringWriter;
import java.io.Writer;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.transaction.annotation.Transactional;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class OrganizationService
implements IOrganizationService {
    @Autowired
    private IOrganizationDAO organizationDAO;
    @Autowired
    private ICompanyDAO companyDAO;
    @Autowired
    private IOrganizationInnerDAO organizationInnerDAO;
    @Autowired
    private ICustomerDAO customerDAO;
    @Autowired
    private ISupplierDAO supplierDAO;
    @Autowired
    private IOrganizationServicesDAO organizationServicesDAO;
    @Autowired
    private IUserDAO userDAO;
    @Autowired
    private IRoleDAO roleDAO;

    @Override
    @Transactional
    public PageDTO findPagerOrganization(OrganizationQueryDTO organizationQueryDTO) {
        PageDTO p = this.organizationDAO.findPager(organizationQueryDTO);
        List entities = p.getData();
        ArrayList<OrganizationGridDTO> dtos = new ArrayList<OrganizationGridDTO>();
        for (Organization entity : entities) {
            OrganizationGridDTO dto = new OrganizationGridDTO();
            OrganizationGridDTO.entity2dto((Object)((Object)entity), (Object)((Object)dto));
            if (entity.getParentOrg() != null) {
                dto.setParentOrgName(entity.getParentOrg().getOrgName());
                dto.setParentNo(entity.getParentOrg().getOrgNo());
            }
            if (entity.getPersonInCharge() != null) {
                dto.setPersonInChargeNo(entity.getPersonInCharge().getUserId());
                dto.setPersonInChargeName(entity.getPersonInCharge().getLoginName());
            }
            dto.setOrgType(entity.getOrgType());
            dtos.add(dto);
        }
        p.setData(dtos);
        return p;
    }

    @Override
    @Transactional
    public PageDTO findPagerOrganizationByIds(OrganizationQueryDTO organizationQueryDTO) {
        PageDTO p = this.organizationDAO.findPagerByIds(organizationQueryDTO);
        List entities = p.getData();
        ArrayList<OrganizationGridDTO> dtos = new ArrayList<OrganizationGridDTO>();
        for (Organization entity : entities) {
            OrganizationGridDTO dto = new OrganizationGridDTO();
            OrganizationGridDTO.entity2dto((Object)((Object)entity), (Object)((Object)dto));
            if (this.organizationInnerDAO.findById(entity.getOrgNo()) != null) {
                dto.setOrgType("organization");
            }
            if (this.companyDAO.findById(entity.getOrgNo()) != null) {
                dto.setOrgType("company");
            }
            if (this.organizationServicesDAO.findById(entity.getOrgNo()) != null) {
                dto.setOrgType("services");
            }
            if (entity.getParentOrg() != null) {
                dto.setParentOrgName(entity.getParentOrg().getOrgName());
                dto.setParentNo(entity.getParentOrg().getOrgNo());
            }
            if (entity.getPersonInCharge() != null) {
                dto.setPersonInChargeNo(entity.getPersonInCharge().getUserId());
                dto.setPersonInChargeName(entity.getPersonInCharge().getLoginName());
            }
            dtos.add(dto);
        }
        p.setData(dtos);
        return p;
    }

    @Override
    @Transactional
    public List<OrganizationDTO> findAllOrganization() {
        List entities = this.organizationDAO.findAll();
        ArrayList<OrganizationDTO> dtos = new ArrayList<OrganizationDTO>();
        for (Organization entity : entities) {
            OrganizationDTO dto = new OrganizationDTO();
            OrganizationDTO.entity2dto((Object)((Object)entity), (Object)((Object)dto));
            dtos.add(dto);
        }
        return dtos;
    }

    @Override
    public OrganizationDTO findOrganizationById(Long orgNo) {
        OrganizationDTO dto = new OrganizationDTO();
        Organization entity = (Organization)((Object)this.organizationDAO.findById(orgNo));
        OrganizationDTO.entity2dto((Object)((Object)entity), (Object)((Object)dto));
        return dto;
    }

    @Override
    @Transactional
    public List<OrganizationTreeDTO> findOrgTreeDtos() {
        List<Company> entities = this.companyDAO.findATree();
        ArrayList<OrganizationTreeDTO> dtos = new ArrayList<OrganizationTreeDTO>();
        for (Company entity : entities) {
            OrganizationTreeDTO dto = new OrganizationTreeDTO();
            this.company2dto(entity, dto);
            dtos.add(dto);
        }
        return dtos;
    }

    @Override
    @Transactional
    public List<OrganizationTreeDTO> findAllWidthOutPanel() {
        List<Company> entities = this.companyDAO.findATree();
        ArrayList<OrganizationTreeDTO> dtos = new ArrayList<OrganizationTreeDTO>();
        for (Company entity : entities) {
            OrganizationTreeDTO dto = new OrganizationTreeDTO();
            this.company22dto(entity, dto);
            dtos.add(dto);
        }
        return dtos;
    }

    @Override
    @Transactional
    public List<OrganizationTreeDTO> findInnerOrgTreeDtos() {
        List<Company> entities = this.companyDAO.findATree();
        ArrayList<OrganizationTreeDTO> dtos = new ArrayList<OrganizationTreeDTO>();
        for (Company entity : entities) {
            List<OrganizationInner> organizationInners = this.organizationInnerDAO.findByCompany(entity.getOrgNo());
            if (organizationInners.isEmpty()) continue;
            for (OrganizationInner inner : organizationInners) {
                OrganizationTreeDTO dto = new OrganizationTreeDTO();
                this.inner2dto(inner, dto);
                dtos.add(dto);
            }
        }
        return dtos;
    }

    @Override
    @Transactional
    public List<OrganizationTreeDTO> findServicesOrgTreeDtos() {
        List<Company> entities = this.companyDAO.findATree();
        ArrayList<OrganizationTreeDTO> dtos = new ArrayList<OrganizationTreeDTO>();
        for (Company entity : entities) {
            List<OrganizationServices> organizationServices = this.organizationServicesDAO.findByCompany(entity.getOrgNo());
            if (organizationServices.isEmpty()) continue;
            for (OrganizationServices ser : organizationServices) {
                OrganizationTreeDTO serData = new OrganizationTreeDTO();
                this.services2dto(ser, serData);
                dtos.add(serData);
            }
        }
        return dtos;
    }

    @Override
    @Transactional
    public List<OrganizationTreeDTO> findOrganizationSelectTree() {
        List<Company> entities = this.companyDAO.findATree();
        ArrayList<OrganizationTreeDTO> dtos = new ArrayList<OrganizationTreeDTO>();
        for (Company entity : entities) {
            OrganizationTreeDTO dto = new OrganizationTreeDTO();
            this.select2dto(entity, dto);
            dtos.add(dto);
        }
        return dtos;
    }

    public void select2dto(Company company, OrganizationTreeDTO dto) {
        try {
            List<OrganizationInner> organizationInners;
            if (company.getOrgRoles() != null) {
                HashSet<Role> roles = new HashSet<Role>();
                for (Role role : company.getOrgRoles()) {
                    roles.add(role);
                }
                dto.setOrgRoles(roles);
            }
            dto.setData(company.getOrgName());
            dto.getAttr().put("orgNo", "" + company.getOrgNo());
            dto.getAttr().put("orgName", company.getOrgName());
            dto.getAttr().put("address", company.getAddress());
            dto.getAttr().put("email", company.getEmail());
            dto.getAttr().put("officeFax", company.getOfficeFax());
            dto.getAttr().put("officePhone", company.getOfficePhone());
            dto.getAttr().put("description", company.getDescription());
            dto.getAttr().put("companyNo", company.getOrgNo() + "");
            dto.getAttr().put("homePage", company.getHomePage());
            dto.getAttr().put("logo", company.getLogo());
            dto.getAttr().put("orgType", "company");
            if (company.getParentOrg() != null) {
                dto.getAttr().put("parentNo", company.getParentOrg().getOrgNo() + "");
            }
            if (company.getPersonInCharge() != null) {
                dto.getAttr().put("personInChargeName", company.getPersonInCharge().getLoginName());
                dto.getAttr().put("personInChargeNo", company.getPersonInCharge().getUserId() + "");
            }
            if (!(organizationInners = this.organizationInnerDAO.findByCompany(company.getOrgNo())).isEmpty()) {
                for (OrganizationInner inner : organizationInners) {
                    OrganizationTreeDTO innerData = new OrganizationTreeDTO();
                    this.inner2dto(inner, innerData);
                    dto.getChildren().add(innerData);
                }
            }
            if (!company.getSuborgs().isEmpty()) {
                for (Organization org : company.getSuborgs()) {
                    Company com = (Company)((Object)this.companyDAO.findById(org.getOrgNo()));
                    if (com == null) continue;
                    OrganizationTreeDTO subDto = new OrganizationTreeDTO();
                    this.company2dto(com, subDto);
                    dto.getChildren().add(subDto);
                }
            }
        }
        catch (Exception ex) {
            throw new ApplicationException("Exception caused while converting Entity into DTO: " + ex.getMessage());
        }
    }

    public void company2dto(Company company, OrganizationTreeDTO dto) {
        try {
            if (company.getOrgRoles() != null) {
                HashSet<Role> roles = new HashSet<Role>();
                for (Role role : company.getOrgRoles()) {
                    roles.add(role);
                }
                dto.setOrgRoles(roles);
            }
            dto.setData(company.getOrgName());
            dto.getAttr().put("orgNo", "" + company.getOrgNo());
            dto.getAttr().put("orgName", company.getOrgName());
            dto.getAttr().put("address", company.getAddress());
            dto.getAttr().put("email", company.getEmail());
            dto.getAttr().put("officeFax", company.getOfficeFax());
            dto.getAttr().put("officePhone", company.getOfficePhone());
            dto.getAttr().put("description", company.getDescription());
            dto.getAttr().put("companyNo", company.getOrgNo() + "");
            dto.getAttr().put("homePage", company.getHomePage());
            dto.getAttr().put("logo", company.getLogo());
            if (company.getParentOrg() != null) {
                dto.getAttr().put("parentNo", company.getParentOrg().getOrgNo() + "");
            }
            dto.getAttr().put("orgType", "company");
            if (company.getPersonInCharge() != null) {
                dto.getAttr().put("personInChargeName", company.getPersonInCharge().getLoginName());
                dto.getAttr().put("personInChargeNo", company.getPersonInCharge().getUserId() + "");
            }
            OrganizationTreeDTO innerPanel = new OrganizationTreeDTO();
            innerPanel.setData("\u5185\u90e8\u673a\u6784");
            innerPanel.getAttr().put("companyNo", company.getOrgNo() + "");
            innerPanel.getAttr().put("orgType", "innerPanel");
            dto.getChildren().add(innerPanel);
            List<OrganizationInner> organizationInners = this.organizationInnerDAO.findByCompany(company.getOrgNo());
            if (!organizationInners.isEmpty()) {
                for (OrganizationInner inner : organizationInners) {
                    OrganizationTreeDTO innerData = new OrganizationTreeDTO();
                    this.inner2dto(inner, innerData);
                    innerPanel.getChildren().add(innerData);
                }
            }
            OrganizationTreeDTO servicePanel = new OrganizationTreeDTO();
            servicePanel.setData("\u670d\u52a1\u673a\u6784");
            servicePanel.getAttr().put("companyNo", company.getOrgNo() + "");
            servicePanel.getAttr().put("orgType", "servicePanel");
            dto.getChildren().add(servicePanel);
            List<OrganizationServices> organizationServices = this.organizationServicesDAO.findByCompany(company.getOrgNo());
            if (!organizationServices.isEmpty()) {
                for (OrganizationServices ser : organizationServices) {
                    OrganizationTreeDTO serData = new OrganizationTreeDTO();
                    this.services2dto(ser, serData);
                    servicePanel.getChildren().add(serData);
                }
            }
            if (!company.getSuborgs().isEmpty()) {
                for (Organization org : company.getSuborgs()) {
                    Company com = (Company)((Object)this.companyDAO.findById(org.getOrgNo()));
                    if (com == null) continue;
                    OrganizationTreeDTO subDto = new OrganizationTreeDTO();
                    this.company2dto(com, subDto);
                    dto.getChildren().add(subDto);
                }
            }
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
    }

    public void company22dto(Company company, OrganizationTreeDTO dto) {
        if (company != null) {
            try {
                List<OrganizationServices> organizationServices;
                List<OrganizationInner> organizationInners;
                dto.setData(company.getOrgName());
                dto.getAttr().put("orgNo", "" + company.getOrgNo());
                dto.getAttr().put("orgName", company.getOrgName());
                dto.getAttr().put("address", company.getAddress());
                dto.getAttr().put("email", company.getEmail());
                dto.getAttr().put("officeFax", company.getOfficeFax());
                dto.getAttr().put("officePhone", company.getOfficePhone());
                dto.getAttr().put("description", company.getDescription());
                dto.getAttr().put("companyNo", company.getOrgNo() + "");
                dto.getAttr().put("homePage", company.getHomePage());
                dto.getAttr().put("logo", company.getLogo());
                dto.getAttr().put("orgType", "company");
                if (company.getParentOrg() != null) {
                    dto.getAttr().put("parentNo", company.getParentOrg().getOrgNo() + "");
                }
                if (company.getPersonInCharge() != null) {
                    dto.getAttr().put("personInChargeName", company.getPersonInCharge().getLoginName());
                    dto.getAttr().put("personInChargeNo", company.getPersonInCharge().getUserId() + "");
                }
                if (!(organizationInners = this.organizationInnerDAO.findByCompany(company.getOrgNo())).isEmpty()) {
                    for (OrganizationInner inner : organizationInners) {
                        OrganizationTreeDTO innerData = new OrganizationTreeDTO();
                        this.inner2dto(inner, innerData);
                    }
                }
                if (!(organizationServices = this.organizationServicesDAO.findByCompany(company.getOrgNo())).isEmpty()) {
                    for (OrganizationServices ser : organizationServices) {
                        OrganizationTreeDTO serData = new OrganizationTreeDTO();
                        this.services2dto(ser, serData);
                        dto.getChildren().add(serData);
                    }
                }
                if (!company.getSuborgs().isEmpty()) {
                    for (Organization org : company.getSuborgs()) {
                        Company com = (Company)((Object)this.companyDAO.findById(org.getOrgNo()));
                        if (com == null) continue;
                        OrganizationTreeDTO subDto = new OrganizationTreeDTO();
                        this.company2dto(com, subDto);
                        dto.getChildren().add(subDto);
                    }
                }
            }
            catch (Exception ex) {
                throw new ApplicationException("Exception caused while converting Entity into DTO: " + ex.getMessage());
            }
        }
    }

    public void inner2dto(OrganizationInner inner, OrganizationTreeDTO dto) {
        if (inner.getDataFlag() != null && inner.getDataFlag() < 99) {
            dto.setData(inner.getOrgName());
            dto.getAttr().put("orgNo", "" + inner.getOrgNo());
            dto.getAttr().put("orgName", inner.getOrgName());
            dto.getAttr().put("address", inner.getAddress());
            dto.getAttr().put("email", inner.getEmail());
            dto.getAttr().put("officeFax", inner.getOfficeFax());
            dto.getAttr().put("officePhone", inner.getOfficePhone());
            dto.getAttr().put("description", inner.getDescription());
            if (inner.getParentOrg() != null) {
                dto.getAttr().put("parentNo", inner.getParentOrg().getOrgNo() + "");
            }
            dto.getAttr().put("orgType", "inner");
            if (inner.getPersonInCharge() != null) {
                dto.getAttr().put("personInChargeName", inner.getPersonInCharge().getLoginName());
                dto.getAttr().put("personInChargeNo", inner.getPersonInCharge().getUserId() + "");
            }
            if (inner.getSuborgs() != null && !inner.getSuborgs().isEmpty()) {
                for (Organization org : inner.getSuborgs()) {
                    OrganizationTreeDTO innerData = new OrganizationTreeDTO();
                    this.inner2dto((OrganizationInner)((Object)this.organizationInnerDAO.findById(org.getOrgNo())), innerData);
                    dto.getChildren().add(innerData);
                }
            }
        }
    }

    public void services2dto(OrganizationServices services, OrganizationTreeDTO dto) {
        if (services.getDataFlag() < 99) {
            dto.setData(services.getOrgName());
            dto.getAttr().put("orgNo", "" + services.getOrgNo());
            dto.getAttr().put("orgName", services.getOrgName());
            dto.getAttr().put("address", services.getAddress());
            dto.getAttr().put("email", services.getEmail());
            dto.getAttr().put("officeFax", services.getOfficeFax());
            dto.getAttr().put("officePhone", services.getOfficePhone());
            dto.getAttr().put("description", services.getDescription());
            if (services.getParentOrg() != null) {
                dto.getAttr().put("parentNo", services.getParentOrg().getOrgNo() + "");
            }
            dto.getAttr().put("orgType", "services");
            if (services.getPersonInCharge() != null) {
                dto.getAttr().put("personInChargeName", services.getPersonInCharge().getLoginName());
                dto.getAttr().put("personInChargeNo", services.getPersonInCharge().getUserId() + "");
            }
            if (services.getSuborgs() != null && !services.getSuborgs().isEmpty()) {
                for (Organization org : services.getSuborgs()) {
                    OrganizationTreeDTO serData = new OrganizationTreeDTO();
                    this.services2dto((OrganizationServices)((Object)this.organizationServicesDAO.findById(org.getOrgNo())), serData);
                    dto.getChildren().add(serData);
                }
            }
        }
    }

    @Override
    @Transactional
    public List<OrganizationDTO> findOrganizationsByType(String flag) {
        ArrayList<OrganizationDTO> orgList;
        block5: {
            List slist;
            block6: {
                block4: {
                    orgList = new ArrayList<OrganizationDTO>();
                    if (!"all".equals(flag)) break block4;
                    List olist = this.organizationDAO.findAll();
                    if (olist.size() <= 0) break block5;
                    for (Organization o : olist) {
                        if (o.getDataFlag() == 99) continue;
                        OrganizationDTO dto = new OrganizationDTO();
                        dto.setOrgNo(o.getOrgNo());
                        dto.setOrgName(o.getOrgName());
                        orgList.add(dto);
                    }
                    break block5;
                }
                if (!"inner".equals(flag)) break block6;
                List ilist = this.organizationInnerDAO.findAll();
                if (ilist.size() <= 0) break block5;
                for (OrganizationInner i : ilist) {
                    if (i.getDataFlag() == 99) continue;
                    OrganizationDTO dto = new OrganizationDTO();
                    dto.setOrgNo(i.getOrgNo());
                    dto.setOrgName(i.getOrgName());
                    orgList.add(dto);
                }
                break block5;
            }
            if ("service".equals(flag) && (slist = this.organizationServicesDAO.findAll()).size() > 0) {
                for (OrganizationServices s : slist) {
                    if (s.getDataFlag() == 99) continue;
                    OrganizationDTO dto = new OrganizationDTO();
                    dto.setOrgNo(s.getOrgNo());
                    dto.setOrgName(s.getOrgName());
                    orgList.add(dto);
                }
            }
        }
        return orgList;
    }

    @Override
    @Transactional
    public void removeServicesOrg(Long orgNo) {
        if (this.companyDAO.findById(orgNo) != null) {
            this.companyDAO.delete(this.companyDAO.findById(orgNo));
            return;
        }
        if (this.organizationInnerDAO.findById(orgNo) != null) {
            this.organizationInnerDAO.delete(this.organizationInnerDAO.findById(orgNo));
            return;
        }
        if (this.organizationServicesDAO.findById(orgNo) != null) {
            this.organizationServicesDAO.delete(this.organizationServicesDAO.findById(orgNo));
            return;
        }
        if (this.customerDAO.findById(orgNo) != null) {
            this.customerDAO.delete(this.customerDAO.findById(orgNo));
            return;
        }
        if (this.supplierDAO.findById(orgNo) != null) {
            this.supplierDAO.delete(this.supplierDAO.findById(orgNo));
            return;
        }
    }

    @Override
    @Transactional
    public void deleteOrgs(Long[] orgNos) {
        this.organizationDAO.deleteByIds(orgNos);
    }

    @Override
    @Transactional
    public void updateOrganization(OrganizationDTO dto) {
        System.out.print("");
        Organization entity = (Organization)((Object)this.organizationDAO.findById(dto.getOrgNo()));
        if (dto.getOrgName() != null) {
            entity.setOrgName(dto.getOrgName());
        }
        if (dto.getOfficeFax() != null) {
            entity.setOfficeFax(dto.getOfficeFax());
        }
        if (dto.getOfficePhone() != null) {
            entity.setOfficePhone(dto.getOfficePhone());
        }
        if (dto.getEmail() != null) {
            entity.setEmail(dto.getEmail());
        }
        if (dto.getAddress() != null) {
            entity.setAddress(dto.getAddress());
        }
        this.organizationDAO.merge((Object)entity);
    }

    @Override
    @Transactional
    public void moveOrg(OrganizationDTO dto) {
        Organization entity = (Organization)((Object)this.organizationDAO.findById(dto.getOrgNo()));
        Organization parent = (Organization)((Object)this.organizationDAO.findById(dto.getParentOrgNo()));
        entity.setParentOrg(parent);
        this.organizationDAO.merge((Object)entity);
    }

    @Override
    @Transactional
    public Long copyOrg(OrganizationDTO dto) {
        Organization source = (Organization)((Object)this.organizationDAO.findById(dto.getOrgNo()));
        Organization parent = (Organization)((Object)this.organizationDAO.findById(dto.getParentOrgNo()));
        if (this.organizationInnerDAO.findById(dto.getOrgNo()) != null) {
            OrganizationInner entity = new OrganizationInner();
            entity.setParentOrg(parent);
            entity.setOrgName(source.getOrgName());
            entity.setOfficeFax(source.getOfficeFax());
            entity.setOfficePhone(source.getOfficePhone());
            entity.setEmail(source.getEmail());
            entity.setAddress(source.getAddress());
            this.organizationInnerDAO.save((Object)entity);
            return entity.getOrgNo();
        }
        if (this.organizationServicesDAO.findById(dto.getOrgNo()) != null) {
            OrganizationServices entity = new OrganizationServices();
            entity.setParentOrg(parent);
            entity.setOrgName(source.getOrgName());
            entity.setOfficeFax(source.getOfficeFax());
            entity.setOfficePhone(source.getOfficePhone());
            entity.setEmail(source.getEmail());
            entity.setAddress(source.getAddress());
            this.organizationServicesDAO.save((Object)entity);
            return entity.getOrgNo();
        }
        return null;
    }

    @Override
    @Transactional
    public Set<Role> findRolesById(Long orgNo) {
        Organization org = (Organization)((Object)this.organizationDAO.findById(orgNo));
        org.getOrgRoles().size();
        Set<Role> roles = org.getOrgRoles();
        return roles;
    }

    @Override
    @Transactional
    public InputStream exportOrganization(OrganizationQueryDTO qdto) {
        ArrayList<String[]> data = new ArrayList<String[]>();
        data.add(new String[]{"orgNo", "orgType", "dataFlag", "orgName", "officePhone", "officeFax", "email", "address", "personInChargeNo", "orgRolesNoStr", "parentNo"});
        qdto.setSord("asc");
        qdto.setSidx("orgNo");
        PageDTO p = this.organizationDAO.findPager(qdto);
        List entities = p.getData();
        String parentNo = "";
        String personInChargeNo = "";
        String orgRolesNoStr = "";
        for (Organization org : entities) {
            if (org.getParentOrg() != null) {
                parentNo = org.getParentOrg().getOrgNo() + "";
            }
            if (org.getPersonInCharge() != null) {
                personInChargeNo = org.getPersonInCharge().getUserId() + "";
            }
            if (org.getOrgRoles() != null && org.getOrgRoles().size() > 0) {
                for (Role role : org.getOrgRoles()) {
                    orgRolesNoStr = orgRolesNoStr + "," + role.getRoleId();
                }
            }
            data.add(new String[]{org.getOrgNo() + "", org.getOrgType(), org.getDataFlag() + "", org.getOrgName(), org.getOfficePhone(), org.getOfficeFax(), org.getEmail(), org.getAddress(), personInChargeNo, orgRolesNoStr, parentNo});
        }
        StringWriter sw = new StringWriter();
        CSVWriter csvw = new CSVWriter((Writer)sw);
        csvw.writeAll(data);
        ByteArrayInputStream stream = new ByteArrayInputStream(sw.getBuffer().toString().getBytes());
        return stream;
    }

    @Override
    @Transactional
    public String importOrganization(String importFile) {
        try {
            InputStreamReader rd = new InputStreamReader(new FileInputStream(importFile));
            CSVReader reader = new CSVReader((Reader)rd);
            String[] line = null;
            try {
                while ((line = reader.readNext()) != null) {
                    String orgType = line[1].toString();
                    if ("company".equals(orgType)) {
                        this.importCompanyInfo(line);
                    }
                    if ("services".equals(orgType)) {
                        this.importServicesInfo(line);
                    }
                    if (!"inner".equals(orgType)) continue;
                    this.importInnerInfo(line);
                }
                return "Success";
            }
            catch (IOException e) {
                e.printStackTrace();
                return "IOError";
            }
        }
        catch (FileNotFoundException e1) {
            e1.printStackTrace();
            return "FileNotFound";
        }
    }

    public void importCompanyInfo(String[] line) {
        Long orgNo = 0L;
        try {
            orgNo = Long.parseLong(line[0].toString());
        }
        catch (Exception ex) {
            throw new ApplicationException("ERROR_NUMBER_FORMAT_PERSONINCHARGE");
        }
        if (orgNo == 0L || this.companyDAO.findById(orgNo) != null) {
            throw new ApplicationException("ERROR_IMPORT_DATA_EXISTS");
        }
        Company company = new Company();
        company.setOrgNo(orgNo);
        company.setOrgType(line[1].toString());
        company.setDataFlag(Byte.parseByte(line[2].toString()));
        company.setOrgName(line[3].toString());
        company.setOfficePhone(line[4].toString());
        company.setOfficeFax(line[5].toString());
        company.setEmail(line[6].toString());
        company.setAddress(line[7].toString());
        company.setPersonInCharge(this.getPersonIncharge(line[8].toString()));
        company.setOrgRoles(this.getRoles(line[9].toString()));
        company.setParentOrg(this.getParentOrg(line[10].toString()));
    }

    public void importServicesInfo(String[] line) {
        Long orgNo = 0L;
        try {
            orgNo = Long.parseLong(line[0].toString());
        }
        catch (Exception ex) {
            throw new ApplicationException("ERROR_NUMBER_FORMAT_SERVICES");
        }
        if (orgNo == 0L || this.organizationServicesDAO.findById(orgNo) != null) {
            throw new ApplicationException("ERROR_IMPORT_DATA_EXISTS");
        }
        OrganizationServices orgService = new OrganizationServices();
        orgService.setOrgNo(orgNo);
        orgService.setOrgType(line[1].toString());
        orgService.setDataFlag(Byte.parseByte(line[2].toString()));
        orgService.setOrgName(line[3].toString());
        orgService.setOfficePhone(line[4].toString());
        orgService.setOfficeFax(line[5].toString());
        orgService.setEmail(line[6].toString());
        orgService.setAddress(line[7].toString());
        orgService.setPersonInCharge(this.getPersonIncharge(line[8].toString()));
        orgService.setOrgRoles(this.getRoles(line[9].toString()));
        orgService.setParentOrg(this.getParentOrg(line[10].toString()));
        this.organizationServicesDAO.save((Object)orgService);
    }

    public void importInnerInfo(String[] line) {
        Long orgNo = 0L;
        try {
            orgNo = Long.parseLong(line[0].toString());
        }
        catch (Exception ex) {
            throw new ApplicationException("ERROR_NUMBER_FORMAT_INNER");
        }
        if (orgNo == 0L || this.organizationInnerDAO.findById(orgNo) != null) {
            throw new ApplicationException("ERROR_IMPORT_DATA_EXISTS");
        }
        OrganizationInner inner = new OrganizationInner();
        inner.setOrgNo(orgNo);
        inner.setOrgType(line[1].toString());
        inner.setDataFlag(Byte.parseByte(line[2].toString()));
        inner.setOrgName(line[3].toString());
        inner.setOfficePhone(line[4].toString());
        inner.setOfficeFax(line[5].toString());
        inner.setEmail(line[6].toString());
        inner.setAddress(line[7].toString());
        inner.setPersonInCharge(this.getPersonIncharge(line[8].toString()));
        inner.setOrgRoles(this.getRoles(line[9].toString()));
        inner.setParentOrg(this.getParentOrg(line[10].toString()));
        this.organizationInnerDAO.save((Object)inner);
    }

    public User getPersonIncharge(String personInChargeNoStr) {
        try {
            Long personInChargeNo = Long.parseLong(personInChargeNoStr);
            try {
                return (User)((Object)this.userDAO.findById(personInChargeNo));
            }
            catch (NullPointerException ex) {
                throw new ApplicationException("ERROR_PERSONINCHARGE_UNDEFINED");
            }
        }
        catch (NumberFormatException ex) {
            throw new ApplicationException("ERROR_NUMBER_FORMAT_PERSONINCHARGE");
        }
    }

    public Set<Role> getRoles(String orgRolesNoStr) {
        if (orgRolesNoStr != null && orgRolesNoStr.trim().equals("")) {
            String[] arr = orgRolesNoStr.split(",");
            HashSet<Role> roles = new HashSet<Role>();
            for (String r : arr) {
                if (r.equals("")) continue;
                roles.add((Role)((Object)this.roleDAO.findById(Long.valueOf(Long.parseLong(r)))));
            }
            return roles;
        }
        return null;
    }

    public Organization getParentOrg(String parentOrgNoStr) {
        try {
            Long parentOrgNo = Long.parseLong(parentOrgNoStr);
            try {
                return (Organization)((Object)this.organizationDAO.findById(parentOrgNo));
            }
            catch (NullPointerException ex) {
                throw new ApplicationException("ERROR_PARENTORG_UNDEFINED");
            }
        }
        catch (NumberFormatException ex) {
            throw new ApplicationException("ERROR_NUMBER_FORMAT_PARENTORG");
        }
    }
}

