/*
 * Decompiled with CFR 0.152.
 */
package com.sinba.common.security.service;

import com.sinba.common.security.dao.IOrganizationDAO;
import com.sinba.common.security.dao.IOrganizationServicesDAO;
import com.sinba.common.security.dao.IRoleDAO;
import com.sinba.common.security.dao.IUserDAO;
import com.sinba.common.security.dto.OrganizationDTO;
import com.sinba.common.security.entity.Organization;
import com.sinba.common.security.entity.OrganizationServices;
import com.sinba.common.security.entity.Role;
import com.sinba.common.security.entity.User;
import com.sinba.common.security.service.IOrganizationServicesService;
import com.sinba.common.security.service.IUserInfoService;
import java.util.HashSet;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.transaction.annotation.Transactional;

public class OrganizationServicesService
implements IOrganizationServicesService {
    @Autowired
    private IOrganizationDAO organizationDAO;
    @Autowired
    private IOrganizationServicesDAO organizationServicesDAO;
    @Autowired
    private IUserDAO userDAO;
    @Autowired
    private IUserInfoService userInfoService;
    @Autowired
    private IRoleDAO roleDAO;

    @Transactional
    public void saveOrganizationServices(OrganizationDTO dto) {
        Organization org;
        OrganizationServices ser = new OrganizationServices();
        ser.setOrgName(dto.getOrgName());
        ser.setOfficeFax(dto.getOfficeFax());
        ser.setOfficePhone(dto.getOfficePhone());
        ser.setEmail(dto.getEmail());
        ser.setAddress(dto.getAddress());
        if (dto.getParentOrgNo() != null && (org = (Organization)((Object)this.organizationDAO.findById(dto.getParentOrgNo()))) != null) {
            ser.setParentOrg(org);
        }
        if (dto.getPersonInChargeNo() != null) {
            ser.setPersonInCharge((User)((Object)this.userDAO.findById(dto.getPersonInChargeNo())));
        }
        this.organizationServicesDAO.save((Object)ser);
        dto.setOrgNo(ser.getOrgNo());
    }

    @Transactional
    public void mergeOrganizationServices(OrganizationDTO dto) {
        OrganizationServices ser = (OrganizationServices)((Object)this.organizationServicesDAO.findById(dto.getOrgNo()));
        ser.setOrgName(dto.getOrgName());
        ser.setOfficeFax(dto.getOfficeFax());
        ser.setOfficePhone(dto.getOfficePhone());
        ser.setEmail(dto.getEmail());
        ser.setAddress(dto.getAddress());
        if (dto.getParentOrgNo() != null) {
            ser.setParentOrg((Organization)((Object)this.organizationDAO.findById(dto.getParentOrgNo())));
        }
        if (dto.getPersonInChargeNo() != null) {
            ser.setPersonInCharge((User)((Object)this.userDAO.findById(dto.getPersonInChargeNo())));
        }
        HashSet<Role> roles = new HashSet<Role>();
        if (dto.getOrgRole() != null) {
            for (Long id : dto.getOrgRole()) {
                Role role = (Role)((Object)this.roleDAO.findById(id));
                roles.add(role);
            }
        }
        ser.setOrgRoles(roles);
        this.organizationServicesDAO.merge((Object)ser);
    }

    @Transactional
    public void deleteOrganizationServices(Long[] orgNos) {
        this.organizationServicesDAO.deleteByIds(orgNos);
    }

    public OrganizationServices findOrganizationServicesById(Long id) {
        return (OrganizationServices)((Object)this.organizationServicesDAO.findById(id));
    }

    public OrganizationDTO findById(Long id) {
        OrganizationDTO dto = new OrganizationDTO();
        OrganizationServices entity = (OrganizationServices)((Object)this.organizationServicesDAO.findById(id));
        if (entity != null) {
            OrganizationDTO.entity2dto((Object)((Object)entity), (Object)((Object)dto));
            if (entity.getParentOrg() != null) {
                dto.setParentOrgNo(entity.getParentOrg().getOrgNo());
            }
        }
        return dto;
    }
}

