/*
 * Decompiled with CFR 0.152.
 */
package com.sinba.common.security.service;

import com.sinba.common.security.dao.IResourceDAO;
import com.sinba.common.security.entity.Resource;
import com.sinba.common.security.entity.Role;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Set;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.security.access.ConfigAttribute;
import org.springframework.security.access.SecurityConfig;
import org.springframework.security.web.FilterInvocation;
import org.springframework.security.web.access.intercept.FilterInvocationSecurityMetadataSource;
import org.springframework.transaction.annotation.Transactional;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ResourceSecurityMetaDataSource
implements FilterInvocationSecurityMetadataSource {
    @Autowired
    private IResourceDAO resourceDAO;

    @Transactional
    public Collection<ConfigAttribute> getAttributes(Object secureObject) {
        String requestUrl = ((FilterInvocation)secureObject).getRequestUrl();
        Resource resource = this.resourceDAO.findByResUrl(requestUrl);
        if (resource == null) {
            return null;
        }
        Set<Role> roles = resource.getRoles();
        ArrayList<ConfigAttribute> configAttributes = new ArrayList<ConfigAttribute>();
        for (Role role : roles) {
            SecurityConfig configAttribute = new SecurityConfig(role.getRoleCode());
            configAttributes.add((ConfigAttribute)configAttribute);
        }
        return configAttributes;
    }

    public Collection<ConfigAttribute> getAllConfigAttributes() {
        ArrayList<ConfigAttribute> configAttributes = new ArrayList<ConfigAttribute>();
        configAttributes.add((ConfigAttribute)new SecurityConfig("ROLE_ANONYMOUS"));
        configAttributes.add((ConfigAttribute)new SecurityConfig("ROLE_ADMIN"));
        configAttributes.add((ConfigAttribute)new SecurityConfig("ROLE_USER"));
        return configAttributes;
    }

    public boolean supports(Class<?> cls) {
        return cls.equals(FilterInvocation.class);
    }
}

