/*
 * Decompiled with CFR 0.152.
 */
package com.sinba.common.security.service;

import com.sinba.common.dto.PageDTO;
import com.sinba.common.file.excel.ExcelUtil;
import com.sinba.common.security.dao.IOperationDAO;
import com.sinba.common.security.dao.IRoleDAO;
import com.sinba.common.security.dto.RoleDTO;
import com.sinba.common.security.dto.RoleQueryDTO;
import com.sinba.common.security.dto.UserRoleDTO;
import com.sinba.common.security.entity.Function;
import com.sinba.common.security.entity.Operation;
import com.sinba.common.security.entity.Resource;
import com.sinba.common.security.entity.Role;
import com.sinba.common.security.service.IRoleService;
import java.io.File;
import java.io.FileInputStream;
import java.io.InputStream;
import java.sql.Date;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.transaction.annotation.Transactional;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class RoleService
implements IRoleService {
    @Autowired
    private IRoleDAO roleDAO;
    @Autowired
    private IOperationDAO operationDAO;

    @Override
    public PageDTO findPagerRole(RoleQueryDTO rqdto, String sidx, String sord) {
        PageDTO p = this.roleDAO.findpager(rqdto, sidx, sord);
        List entities = p.getData();
        ArrayList<RoleDTO> dtos = new ArrayList<RoleDTO>(entities.size());
        for (Role entity : entities) {
            RoleDTO dto = new RoleDTO();
            RoleDTO.entity2dto((Object)((Object)entity), (Object)((Object)dto));
            dtos.add(dto);
        }
        p.setData(dtos);
        return p;
    }

    @Override
    public void saveRole(RoleDTO roleDto) {
        Role role = new Role();
        RoleDTO.dto2entity((Object)((Object)roleDto), (Object)((Object)role));
        role.setCreateTime(new Date(new java.util.Date().getTime()));
        this.roleDAO.save((Object)role);
        roleDto.setRoleId(role.getRoleId());
    }

    @Override
    @Transactional
    public boolean deleteRole(Long[] ids) {
        Boolean result = true;
        Byte delete = 1;
        for (Long id : ids) {
            Role role = (Role)((Object)this.roleDAO.findById(id));
            if (!role.getDataFlag().toString().equals(delete.toString())) continue;
            result = false;
        }
        if (result.booleanValue()) {
            this.roleDAO.deleteByIds(ids);
        }
        return result;
    }

    @Override
    public void editRole(RoleDTO roleDto) {
        Role role1 = this.findRoleById(roleDto.getRoleId());
        Role role = new Role();
        role.setLastUpdateTime(new Date(new java.util.Date().getTime()));
        RoleDTO.dto2entity((Object)((Object)roleDto), (Object)((Object)role));
        role.setResources(role1.getResources());
        this.roleDAO.merge((Object)role);
    }

    @Override
    public List<UserRoleDTO> findRoleByPropertyName(String propertyName, Object value) {
        ArrayList<UserRoleDTO> userRoleDtos = new ArrayList<UserRoleDTO>();
        List<Role> list = this.roleDAO.findBy(propertyName, value);
        for (Role entity : list) {
            UserRoleDTO userRoleDto = new UserRoleDTO();
            UserRoleDTO.entity2dto((Object)((Object)entity), (Object)((Object)userRoleDto));
            userRoleDtos.add(userRoleDto);
        }
        return userRoleDtos;
    }

    @Override
    public Role findRoleById(long id) {
        return (Role)((Object)this.roleDAO.findById(Long.valueOf(id)));
    }

    @Override
    public RoleDTO findRoleDTOById(long id) {
        RoleDTO dto = new RoleDTO();
        Role entity = this.findRoleById(id);
        RoleDTO.entity2dto((Object)((Object)entity), (Object)((Object)dto));
        return dto;
    }

    @Override
    public boolean existByRoleCode(String roleCode) {
        Boolean result = true;
        Role role = (Role)((Object)this.roleDAO.findUniqueBy("roleCode", roleCode));
        if (role != null) {
            result = false;
        }
        return result;
    }

    @Override
    public boolean existByRoleName(String roleName) {
        boolean result = true;
        Role role = (Role)((Object)this.roleDAO.findUniqueBy("roleName", roleName));
        if (role != null) {
            result = false;
        }
        return result;
    }

    @Override
    @Transactional
    public void setRoleResourceByRoleIds(String[] roleIds, String[] resIds) {
        ArrayList<Role> roleList = new ArrayList<Role>();
        HashSet<Resource> resourceList = new HashSet<Resource>();
        for (int i = 0; i < roleIds.length; ++i) {
            Role role = this.findRoleById(Integer.parseInt(roleIds[i]));
            for (int j = 0; j < resIds.length; ++j) {
                Function function;
                Resource resource = new Resource();
                resource.setResNo(Long.parseLong(resIds[j]));
                resourceList.add(resource);
                Operation operation = (Operation)((Object)this.operationDAO.findById(Long.valueOf(Long.parseLong(resIds[j]))));
                if (operation == null || (function = operation.getFunction()) == null) continue;
                Resource resourcep = new Resource();
                resourcep.setResNo(function.getResNo());
                if (!resourceList.contains((Object)resourcep)) {
                    resourceList.add(resourcep);
                }
                this.setParentFunction(function, resourceList);
            }
            role.setResources(resourceList);
            roleList.add(role);
        }
        this.roleDAO.mergeAll(roleList);
    }

    public void setParentFunction(Function function, Set<Resource> resourceList) {
        Function parentFunction = function.getParentFunction();
        if (parentFunction != null) {
            Resource resource = new Resource();
            resource.setResNo(parentFunction.getResNo());
            if (!resourceList.contains((Object)resource)) {
                resourceList.add(resource);
            }
            this.setParentFunction(parentFunction, resourceList);
        }
    }

    @Override
    @Transactional
    public String getResourceRoleByRoleId(Long roleId) {
        Role role = this.findRoleById(roleId);
        if (role != null) {
            String str = "";
            if (role.getResources() != null) {
                for (Resource entity : role.getResources()) {
                    if (str == "") {
                        str = entity.getResNo().toString();
                        continue;
                    }
                    str = str + "," + entity.getResNo();
                }
            }
            return str;
        }
        return null;
    }

    @Override
    @Transactional
    public InputStream exportRoleItems(RoleQueryDTO roleQueryDTO, String sidx, String sord) throws Exception {
        String sheetName = "\u89d2\u8272\u7ba1\u7406";
        String[] colNames = new String[]{"\u89d2\u8272\u540d", "\u4ee3\u7801", "\u63cf\u8ff0", "\u5907\u6ce8", "\u72b6\u6001"};
        ArrayList<String[]> data = new ArrayList<String[]>();
        PageDTO p = this.roleDAO.findpager(roleQueryDTO, sidx, sord);
        if (p != null && p.getData() != null && p.getData().size() > 0) {
            List entities = p.getData();
            for (Role item : entities) {
                RoleDTO dto = new RoleDTO();
                RoleDTO.entity2dto((Object)((Object)item), (Object)((Object)dto));
                String roleState = "\u7981\u7528";
                if (dto.isRoleState()) {
                    roleState = "\u542f\u7528";
                }
                data.add(new String[]{dto.getRoleName(), dto.getRoleCode(), dto.getDescription(), dto.getRemark(), roleState});
            }
            try {
                return ExcelUtil.createSheetExcel((String)sheetName, (String[])colNames, data);
            }
            catch (Exception e) {
                throw new Exception(e);
            }
        }
        return ExcelUtil.createSheetExcel((String)sheetName, (String[])colNames, data);
    }

    @Override
    public Integer importRoleItems(RoleQueryDTO roleQueryDTO) {
        File importFile = roleQueryDTO.getImportFile();
        String sheetName = "\u89d2\u8272\u7ba1\u7406";
        List data = null;
        try {
            data = ExcelUtil.readSheet((String)sheetName, (InputStream)new FileInputStream(importFile));
        }
        catch (Exception e) {
            return -1;
        }
        if (data != null && data.size() > 0) {
            int count = 0;
            for (String[] rowData : data) {
                try {
                    RoleDTO dto = new RoleDTO();
                    boolean roleState = false;
                    if (rowData[4].toString().equals("\u542f\u7528")) {
                        roleState = true;
                    }
                    dto.setRoleName(rowData[0].toString());
                    dto.setRoleCode(rowData[1].toString());
                    dto.setDescription(rowData[2].toString());
                    dto.setRemark(rowData[3].toString());
                    dto.setRoleState(roleState);
                    Role entity = new Role();
                    RoleDTO.entity2dto((Object)((Object)dto), (Object)((Object)entity));
                    this.roleDAO.save((Object)entity);
                    ++count;
                }
                catch (Exception e) {
                    return -2;
                }
            }
            return count;
        }
        return 0;
    }
}

